/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.StorageMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyWithNodeGroup;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.NetworkTopologyWithNodeGroup;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.PathUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestReplicationPolicyWithNodeGroup {
    private static final int BLOCK_SIZE = 1024;
    private static final int NUM_OF_DATANODES = 8;
    private static final int NUM_OF_DATANODES_BOUNDARY = 6;
    private static final int NUM_OF_DATANODES_MORE_TARGETS = 12;
    private static final int NUM_OF_DATANODES_FOR_DEPENDENCIES = 6;
    private final Configuration CONF = new HdfsConfiguration();
    private NetworkTopology cluster;
    private NameNode namenode;
    private BlockPlacementPolicy replicator;
    private static final String filename = "/dummyfile.txt";
    private DatanodeStorageInfo[] storages;
    private DatanodeDescriptor[] dataNodes;
    private DatanodeStorageInfo[] storagesInBoundaryCase;
    private DatanodeDescriptor[] dataNodesInBoundaryCase;
    private DatanodeStorageInfo[] storagesInMoreTargetsCase;
    private DatanodeDescriptor[] dataNodesInMoreTargetsCase;
    private DatanodeDescriptor NODE;
    private DatanodeStorageInfo[] storagesForDependencies;
    private DatanodeDescriptor[] dataNodesForDependencies;

    @Before
    public void setUp() throws Exception {
        HdfsStorageFactory.setConfiguration((Configuration)this.CONF);
        HdfsStorageFactory.formatStorage();
        String[] racks = new String[]{"/d1/r1/n1", "/d1/r1/n1", "/d1/r1/n2", "/d1/r2/n3", "/d1/r2/n3", "/d1/r2/n4", "/d2/r3/n5", "/d2/r3/n6"};
        this.storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        this.dataNodes = DFSTestUtil.toDatanodeDescriptor(this.storages);
        String[] racksInBoundaryCase = new String[]{"/d1/r1/n1", "/d1/r1/n1", "/d1/r1/n1", "/d1/r1/n2", "/d1/r2/n3", "/d1/r2/n3"};
        this.storagesInBoundaryCase = DFSTestUtil.createDatanodeStorageInfos(racksInBoundaryCase);
        this.dataNodesInBoundaryCase = DFSTestUtil.toDatanodeDescriptor(this.storagesInBoundaryCase);
        String[] racksInMoreTargetsCase = new String[]{"/r1/n1", "/r1/n1", "/r1/n2", "/r1/n2", "/r1/n3", "/r1/n3", "/r2/n4", "/r2/n4", "/r2/n5", "/r2/n5", "/r2/n6", "/r2/n6"};
        this.storagesInMoreTargetsCase = DFSTestUtil.createDatanodeStorageInfos(racksInMoreTargetsCase);
        this.dataNodesInMoreTargetsCase = DFSTestUtil.toDatanodeDescriptor(this.storagesInMoreTargetsCase);
        String[] racksForDependencies = new String[]{"/d1/r1/n1", "/d1/r1/n1", "/d1/r1/n2", "/d1/r1/n2", "/d1/r1/n3", "/d1/r1/n4"};
        String[] hostNamesForDependencies = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
        this.storagesForDependencies = DFSTestUtil.createDatanodeStorageInfos(racksForDependencies, hostNamesForDependencies);
        this.dataNodesForDependencies = DFSTestUtil.toDatanodeDescriptor(this.storagesForDependencies);
        this.NODE = new DatanodeDescriptor(new StorageMap(false), (DatanodeID)DFSTestUtil.getDatanodeDescriptor("9.9.9.9", "/d2/r4/n7"));
        FileSystem.setDefaultUri((Configuration)this.CONF, (String)"hdfs://localhost:0");
        this.CONF.set("dfs.namenode.http-address", "0.0.0.0:0");
        this.CONF.set("dfs.block.replicator.classname", BlockPlacementPolicyWithNodeGroup.class.getName());
        this.CONF.set("net.topology.impl", NetworkTopologyWithNodeGroup.class.getName());
        this.CONF.setBoolean("dfs.namenode.avoid.write.stale.datanode", true);
        File baseDir = PathUtils.getTestDir(TestReplicationPolicyWithNodeGroup.class);
        DFSTestUtil.formatNameNode(this.CONF);
        this.namenode = new NameNode(this.CONF);
        BlockManager bm = this.namenode.getNamesystem().getBlockManager();
        this.replicator = bm.getBlockPlacementPolicy();
        this.cluster = bm.getDatanodeManager().getNetworkTopology();
        for (int i = 0; i < 8; ++i) {
            this.cluster.add((Node)this.dataNodes[i]);
        }
        this.setupDataNodeCapacity();
    }

    @After
    public void tearDown() throws Exception {
        this.namenode.stop();
    }

    private static void updateHeartbeatWithUsage(DatanodeDescriptor dn, long capacity, long dfsUsed, long remaining, long blockPoolUsed, long dnCacheCapacity, long dnCacheUsed, int xceiverCount, int volFailures) {
        dn.getStorageInfos()[0].setUtilizationForTesting(capacity, dfsUsed, remaining, blockPoolUsed);
        dn.updateHeartbeat(BlockManagerTestUtil.getStorageReportsForDatanode(dn), dnCacheCapacity, dnCacheUsed, xceiverCount, volFailures, null);
    }

    private void setupDataNodeCapacity() {
        for (int i = 0; i < 8; ++i) {
            TestReplicationPolicyWithNodeGroup.updateHeartbeatWithUsage(this.dataNodes[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        }
    }

    private static boolean checkTargetsOnDifferentNodeGroup(DatanodeStorageInfo[] targets) {
        if (targets.length == 0) {
            return true;
        }
        HashSet<String> targetSet = new HashSet<String>();
        for (DatanodeStorageInfo storage : targets) {
            DatanodeDescriptor node = storage.getDatanodeDescriptor();
            String nodeGroup = NetworkTopology.getLastHalf((String)node.getNetworkLocation());
            if (targetSet.contains(nodeGroup)) {
                return false;
            }
            targetSet.add(nodeGroup);
        }
        return true;
    }

    private boolean isOnSameRack(DatanodeStorageInfo left, DatanodeStorageInfo right) {
        return this.isOnSameRack(left.getDatanodeDescriptor(), right);
    }

    private boolean isOnSameRack(DatanodeDescriptor left, DatanodeStorageInfo right) {
        return this.cluster.isOnSameRack((Node)left, (Node)right.getDatanodeDescriptor());
    }

    private boolean isOnSameNodeGroup(DatanodeStorageInfo left, DatanodeStorageInfo right) {
        return this.isOnSameNodeGroup(left.getDatanodeDescriptor(), right);
    }

    private boolean isOnSameNodeGroup(DatanodeDescriptor left, DatanodeStorageInfo right) {
        return this.cluster.isOnSameNodeGroup((Node)left, (Node)right.getDatanodeDescriptor());
    }

    private DatanodeStorageInfo[] chooseTarget(int numOfReplicas) {
        return this.chooseTarget(numOfReplicas, this.dataNodes[0]);
    }

    private DatanodeStorageInfo[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer) {
        return this.chooseTarget(numOfReplicas, writer, new ArrayList<DatanodeStorageInfo>());
    }

    private DatanodeStorageInfo[] chooseTarget(int numOfReplicas, List<DatanodeStorageInfo> chosenNodes) {
        return this.chooseTarget(numOfReplicas, this.dataNodes[0], chosenNodes);
    }

    private DatanodeStorageInfo[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer, List<DatanodeStorageInfo> chosenNodes) {
        return this.chooseTarget(numOfReplicas, writer, chosenNodes, null);
    }

    private DatanodeStorageInfo[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer, List<DatanodeStorageInfo> chosenNodes, Set<Node> excludedNodes) {
        return this.replicator.chooseTarget(filename, numOfReplicas, (Node)writer, chosenNodes, false, excludedNodes, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY);
    }

    @Test
    public void testChooseTarget1() throws Exception {
        TestReplicationPolicyWithNodeGroup.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 1024L, 0L, 0L, 0L, 4, 0);
        DatanodeStorageInfo[] targets = this.chooseTarget(0);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        targets = this.chooseTarget(2);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        Assert.assertTrue((boolean)this.isOnSameRack(targets[1], targets[2]));
        Assert.assertFalse((boolean)this.isOnSameNodeGroup(targets[1], targets[2]));
        targets = this.chooseTarget(4);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assert.assertTrue((this.isOnSameRack(targets[1], targets[2]) || this.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[2]));
        this.verifyNoTwoTargetsOnSameNodeGroup(targets);
        TestReplicationPolicyWithNodeGroup.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 1024L, 0L, 0L, 0L, 0, 0);
    }

    private void verifyNoTwoTargetsOnSameNodeGroup(DatanodeStorageInfo[] targets) {
        HashSet<String> nodeGroupSet = new HashSet<String>();
        for (DatanodeStorageInfo target : targets) {
            nodeGroupSet.add(target.getDatanodeDescriptor().getNetworkLocation());
        }
        Assert.assertEquals((long)nodeGroupSet.size(), (long)targets.length);
    }

    @Test
    public void testChooseTarget2() throws Exception {
        int i;
        BlockPlacementPolicyDefault repl = (BlockPlacementPolicyDefault)this.replicator;
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        HashSet<DatanodeDescriptor> excludedNodes = new HashSet<DatanodeDescriptor>();
        excludedNodes.add(this.dataNodes[1]);
        DatanodeStorageInfo[] targets = repl.chooseTarget(filename, 4, (Node)this.dataNodes[0], chosenNodes, false, excludedNodes, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assert.assertTrue((boolean)this.cluster.isNodeGroupAware());
        for (i = 1; i < 4; ++i) {
            Assert.assertFalse((boolean)this.isOnSameNodeGroup(targets[0], targets[i]));
        }
        Assert.assertTrue((this.isOnSameRack(targets[1], targets[2]) || this.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[1], targets[3]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add(this.dataNodes[1]);
        chosenNodes.add(this.storages[2]);
        targets = repl.chooseTarget(filename, 1, (Node)this.dataNodes[0], chosenNodes, true, excludedNodes, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY);
        System.out.println("targets=" + Arrays.asList(targets));
        Assert.assertEquals((long)2L, (long)targets.length);
        for (i = 0; i < targets.length && !this.storages[2].equals((Object)targets[i]); ++i) {
        }
        Assert.assertTrue((i < targets.length ? 1 : 0) != 0);
    }

    @Test
    public void testChooseTarget3() throws Exception {
        TestReplicationPolicyWithNodeGroup.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 0L, 0L, 0L, 0L, 0, 0);
        DatanodeStorageInfo[] targets = this.chooseTarget(0);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)this.storages[1], (Object)targets[0]);
        targets = this.chooseTarget(2);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)this.storages[1], (Object)targets[0]);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)this.storages[1], (Object)targets[0]);
        Assert.assertTrue((boolean)this.isOnSameRack(targets[1], targets[2]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(4);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)this.storages[1], (Object)targets[0]);
        Assert.assertTrue((boolean)this.cluster.isNodeGroupAware());
        this.verifyNoTwoTargetsOnSameNodeGroup(targets);
        Assert.assertTrue((this.isOnSameRack(targets[1], targets[2]) || this.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        TestReplicationPolicyWithNodeGroup.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 1024L, 0L, 0L, 0L, 0, 0);
    }

    @Test
    public void testChooseTarget4() throws Exception {
        for (int i = 0; i < 3; ++i) {
            TestReplicationPolicyWithNodeGroup.updateHeartbeatWithUsage(this.dataNodes[i], 2048L, 0L, 0L, 0L, 0L, 0L, 0, 0);
        }
        DatanodeStorageInfo[] targets = this.chooseTarget(0);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        targets = this.chooseTarget(2);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3);
        Assert.assertEquals((long)targets.length, (long)3L);
        for (int i = 0; i < 3; ++i) {
            Assert.assertFalse((boolean)this.isOnSameRack(this.dataNodes[0], targets[i]));
        }
        this.verifyNoTwoTargetsOnSameNodeGroup(targets);
        Assert.assertTrue((this.isOnSameRack(targets[0], targets[1]) || this.isOnSameRack(targets[1], targets[2]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[2]));
    }

    @Test
    public void testChooseTarget5() throws Exception {
        this.setupDataNodeCapacity();
        DatanodeStorageInfo[] targets = this.chooseTarget(0, this.NODE);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1, this.NODE);
        Assert.assertEquals((long)targets.length, (long)1L);
        targets = this.chooseTarget(2, this.NODE);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3, this.NODE);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)this.isOnSameRack(targets[1], targets[2]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        this.verifyNoTwoTargetsOnSameNodeGroup(targets);
    }

    @Test
    public void testRereplicate1() throws Exception {
        this.setupDataNodeCapacity();
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(this.storages[0]);
        DatanodeStorageInfo[] targets = this.chooseTarget(0, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        targets = this.chooseTarget(2, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        Assert.assertFalse((boolean)this.isOnSameNodeGroup(this.dataNodes[0], targets[0]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[2]));
    }

    @Test
    public void testRereplicate2() throws Exception {
        this.setupDataNodeCapacity();
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(this.storages[0]);
        chosenNodes.add(this.storages[1]);
        DatanodeStorageInfo[] targets = this.chooseTarget(0, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        targets = this.chooseTarget(2, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((this.isOnSameRack(this.dataNodes[0], targets[0]) && this.isOnSameRack(this.dataNodes[0], targets[1]) ? 1 : 0) != 0);
    }

    @Test
    public void testRereplicate3() throws Exception {
        this.setupDataNodeCapacity();
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(this.storages[0]);
        chosenNodes.add(this.storages[3]);
        DatanodeStorageInfo[] targets = this.chooseTarget(0, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertTrue((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        Assert.assertFalse((boolean)this.isOnSameRack(this.dataNodes[3], targets[0]));
        targets = this.chooseTarget(1, this.dataNodes[3], chosenNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertTrue((boolean)this.isOnSameRack(this.dataNodes[3], targets[0]));
        Assert.assertFalse((boolean)this.isOnSameNodeGroup(this.dataNodes[3], targets[0]));
        Assert.assertFalse((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        targets = this.chooseTarget(2, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        Assert.assertFalse((boolean)this.isOnSameNodeGroup(this.dataNodes[0], targets[0]));
        targets = this.chooseTarget(2, this.dataNodes[3], chosenNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)this.isOnSameRack(this.dataNodes[3], targets[0]));
    }

    @Test
    public void testChooseReplicaToDelete() throws Exception {
        ArrayList<DatanodeStorageInfo> replicaList = new ArrayList<DatanodeStorageInfo>();
        HashMap rackMap = new HashMap();
        this.dataNodes[0].setRemaining(0x400000L);
        replicaList.add(this.storages[0]);
        this.dataNodes[1].setRemaining(0x300000L);
        replicaList.add(this.storages[1]);
        this.dataNodes[2].setRemaining(0x200000L);
        replicaList.add(this.storages[2]);
        this.dataNodes[5].setRemaining(0x100000L);
        replicaList.add(this.storages[5]);
        ArrayList first = new ArrayList();
        ArrayList second = new ArrayList();
        this.replicator.splitNodesWithRack(replicaList, rackMap, first, second);
        Assert.assertEquals((long)3L, (long)first.size());
        Assert.assertEquals((long)1L, (long)second.size());
        ArrayList<StorageType> excessTypes = new ArrayList<StorageType>();
        excessTypes.add(StorageType.DEFAULT);
        DatanodeStorageInfo chosen = this.replicator.chooseReplicaToDelete(null, null, (short)3, first, second, excessTypes);
        Assert.assertEquals((Object)chosen, (Object)this.storages[1]);
        this.replicator.adjustSetsWithChosenReplica(rackMap, first, second, chosen);
        Assert.assertEquals((long)2L, (long)first.size());
        Assert.assertEquals((long)1L, (long)second.size());
        excessTypes.add(StorageType.DEFAULT);
        chosen = this.replicator.chooseReplicaToDelete(null, null, (short)2, first, second, excessTypes);
        Assert.assertEquals((Object)chosen, (Object)this.storages[2]);
        this.replicator.adjustSetsWithChosenReplica(rackMap, first, second, chosen);
        Assert.assertEquals((long)0L, (long)first.size());
        Assert.assertEquals((long)2L, (long)second.size());
        excessTypes.add(StorageType.DEFAULT);
        chosen = this.replicator.chooseReplicaToDelete(null, null, (short)1, first, second, excessTypes);
        Assert.assertEquals((Object)chosen, (Object)this.storages[5]);
    }

    @Test
    public void testChooseTargetsOnBoundaryTopology() throws Exception {
        int i;
        for (i = 0; i < 8; ++i) {
            this.cluster.remove((Node)this.dataNodes[i]);
        }
        for (i = 0; i < 6; ++i) {
            this.cluster.add((Node)this.dataNodesInBoundaryCase[i]);
        }
        for (i = 0; i < 6; ++i) {
            TestReplicationPolicyWithNodeGroup.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 0L, 0L, 0L, 0L, 0, 0);
            TestReplicationPolicyWithNodeGroup.updateHeartbeatWithUsage(this.dataNodesInBoundaryCase[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        }
        DatanodeStorageInfo[] targets = this.chooseTarget(0, this.dataNodesInBoundaryCase[0]);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1, this.dataNodesInBoundaryCase[0]);
        Assert.assertEquals((long)targets.length, (long)1L);
        targets = this.chooseTarget(2, this.dataNodesInBoundaryCase[0]);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3, this.dataNodesInBoundaryCase[0]);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)TestReplicationPolicyWithNodeGroup.checkTargetsOnDifferentNodeGroup(targets));
    }

    @Test
    public void testRereplicateOnBoundaryTopology() throws Exception {
        for (int i = 0; i < 6; ++i) {
            TestReplicationPolicyWithNodeGroup.updateHeartbeatWithUsage(this.dataNodesInBoundaryCase[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        }
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(this.storagesInBoundaryCase[0]);
        chosenNodes.add(this.storagesInBoundaryCase[5]);
        DatanodeStorageInfo[] targets = this.chooseTarget(1, this.dataNodesInBoundaryCase[0], chosenNodes);
        Assert.assertFalse((boolean)this.isOnSameNodeGroup(this.dataNodesInBoundaryCase[0], targets[0]));
        Assert.assertFalse((boolean)this.isOnSameNodeGroup(this.dataNodesInBoundaryCase[5], targets[0]));
        Assert.assertTrue((boolean)TestReplicationPolicyWithNodeGroup.checkTargetsOnDifferentNodeGroup(targets));
    }

    @Test
    public void testChooseMoreTargetsThanNodeGroups() throws Exception {
        int i;
        for (i = 0; i < 8; ++i) {
            this.cluster.remove((Node)this.dataNodes[i]);
        }
        for (i = 0; i < 6; ++i) {
            DatanodeDescriptor node = this.dataNodesInBoundaryCase[i];
            if (!this.cluster.contains((Node)node)) continue;
            this.cluster.remove((Node)node);
        }
        for (i = 0; i < 12; ++i) {
            this.cluster.add((Node)this.dataNodesInMoreTargetsCase[i]);
        }
        for (i = 0; i < 12; ++i) {
            TestReplicationPolicyWithNodeGroup.updateHeartbeatWithUsage(this.dataNodesInMoreTargetsCase[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        }
        DatanodeStorageInfo[] targets = this.chooseTarget(3, this.dataNodesInMoreTargetsCase[0]);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)TestReplicationPolicyWithNodeGroup.checkTargetsOnDifferentNodeGroup(targets));
        targets = this.chooseTarget(10, this.dataNodesInMoreTargetsCase[0]);
        Assert.assertTrue((boolean)TestReplicationPolicyWithNodeGroup.checkTargetsOnDifferentNodeGroup(targets));
        Assert.assertEquals((long)targets.length, (long)6L);
    }

    @Test
    public void testChooseTargetWithDependencies() throws Exception {
        int i;
        int i2;
        for (i2 = 0; i2 < 8; ++i2) {
            this.cluster.remove((Node)this.dataNodes[i2]);
        }
        for (i2 = 0; i2 < 12; ++i2) {
            DatanodeDescriptor node = this.dataNodesInMoreTargetsCase[i2];
            if (!this.cluster.contains((Node)node)) continue;
            this.cluster.remove((Node)node);
        }
        Host2NodesMap host2DatanodeMap = this.namenode.getNamesystem().getBlockManager().getDatanodeManager().getHost2DatanodeMap();
        for (i = 0; i < 6; ++i) {
            this.cluster.add((Node)this.dataNodesForDependencies[i]);
            host2DatanodeMap.add(this.dataNodesForDependencies[i]);
        }
        this.dataNodesForDependencies[1].addDependentHostName(this.dataNodesForDependencies[2].getHostName());
        this.dataNodesForDependencies[2].addDependentHostName(this.dataNodesForDependencies[1].getHostName());
        this.dataNodesForDependencies[3].addDependentHostName(this.dataNodesForDependencies[4].getHostName());
        this.dataNodesForDependencies[4].addDependentHostName(this.dataNodesForDependencies[3].getHostName());
        for (i = 0; i < 6; ++i) {
            TestReplicationPolicyWithNodeGroup.updateHeartbeatWithUsage(this.dataNodesForDependencies[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        }
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        HashSet<Node> excludedNodes = new HashSet<Node>();
        excludedNodes.add((Node)this.dataNodesForDependencies[5]);
        DatanodeStorageInfo[] targets = this.chooseTarget(3, this.dataNodesForDependencies[1], chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)targets[0], (Object)this.storagesForDependencies[1]);
        Assert.assertTrue((targets[1].equals((Object)this.storagesForDependencies[3]) || targets[1].equals((Object)this.storagesForDependencies[4]) ? 1 : 0) != 0);
        Assert.assertEquals((long)excludedNodes.size(), (long)6L);
        for (int i3 = 0; i3 < 6; ++i3) {
            Assert.assertTrue((boolean)excludedNodes.contains(this.dataNodesForDependencies[i3]));
        }
    }
}

