/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestRollingUpgrade;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.test.GenericTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestDataNodeRollingUpgrade {
    private static final Log LOG = LogFactory.getLog(TestDataNodeRollingUpgrade.class);
    private static final short REPL_FACTOR = 1;
    private static final int BLOCK_SIZE = 0x100000;
    private static final long FILE_SIZE = 0x100000L;
    private static final long SEED = 464384013L;
    Configuration conf;
    MiniDFSCluster cluster = null;
    DistributedFileSystem fs = null;
    DataNode dn0 = null;
    NameNode nn = null;
    String blockPoolId = null;

    private void startCluster() throws IOException {
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.blocksize", 0x100000);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.nn = this.cluster.getNameNode(0);
        Assert.assertNotNull((Object)this.nn);
        this.dn0 = this.cluster.getDataNodes().get(0);
        Assert.assertNotNull((Object)this.dn0);
        this.blockPoolId = this.cluster.getNameNode(0).getNamesystem().getBlockPoolId();
    }

    private void shutdownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        this.fs = null;
        this.nn = null;
        this.dn0 = null;
        this.blockPoolId = null;
    }

    private void triggerHeartBeats() throws Exception {
        this.cluster.triggerHeartbeats();
        Thread.sleep(5000L);
    }

    private File getBlockForFile(Path path, boolean exists) throws IOException {
        LocatedBlocks blocks = this.nn.getRpcServer().getBlockLocations(path.toString(), 0L, Long.MAX_VALUE);
        Assert.assertEquals((String)"The test helper functions assume that each file has a single block", (long)1L, (long)blocks.getLocatedBlocks().size());
        ExtendedBlock block = ((LocatedBlock)blocks.getLocatedBlocks().get(0)).getBlock();
        BlockLocalPathInfo bInfo = this.dn0.getFSDataset().getBlockLocalPathInfo(block);
        File blockFile = new File(bInfo.getBlockPath());
        Assert.assertEquals((Object)exists, (Object)blockFile.exists());
        return blockFile;
    }

    private File getTrashFileForBlock(File blockFile, boolean exists) {
        File trashFile = new File(this.dn0.getStorage().getTrashDirectoryForBlockFile(this.blockPoolId, blockFile));
        Assert.assertEquals((Object)exists, (Object)trashFile.exists());
        return trashFile;
    }

    private void deleteAndEnsureInTrash(Path pathToDelete, File blockFile, File trashFile) throws Exception {
        Assert.assertTrue((boolean)blockFile.exists());
        Assert.assertFalse((boolean)trashFile.exists());
        LOG.info((Object)("Deleting file " + pathToDelete + " during rolling upgrade"));
        this.fs.delete(pathToDelete, false);
        Thread.sleep(5000L);
        assert (!this.fs.exists(pathToDelete));
        this.triggerHeartBeats();
        Assert.assertTrue((boolean)trashFile.exists());
        Assert.assertFalse((boolean)blockFile.exists());
    }

    private boolean isTrashRootPresent() {
        BlockPoolSliceStorage bps = this.dn0.getStorage().getBPStorage(this.blockPoolId);
        return bps.trashEnabled();
    }

    private void ensureTrashRestored(File blockFile, File trashFile) throws Exception {
        Assert.assertTrue((boolean)blockFile.exists());
        Assert.assertFalse((boolean)trashFile.exists());
        Assert.assertFalse((boolean)this.isTrashRootPresent());
    }

    private boolean isBlockFileInPrevious(File blockFile) {
        Pattern blockFilePattern = Pattern.compile(String.format("^(.*%1$scurrent%1$s.*%1$s)(current)(%1$s.*)$", Pattern.quote(File.separator)));
        java.util.regex.Matcher matcher = blockFilePattern.matcher(blockFile.toString());
        String previousFileName = matcher.replaceFirst("$1previous$3");
        return new File(previousFileName).exists();
    }

    private void startRollingUpgrade() throws Exception {
        LOG.info((Object)"Starting rolling upgrade");
        DFSAdmin dfsadmin = new DFSAdmin(this.conf);
        TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "prepare");
        this.triggerHeartBeats();
        Assert.assertTrue((boolean)this.dn0.getFSDataset().trashEnabled(this.blockPoolId));
    }

    private void finalizeRollingUpgrade() throws Exception {
        LOG.info((Object)"Finalizing rolling upgrade");
        DFSAdmin dfsadmin = new DFSAdmin(this.conf);
        TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "finalize");
        this.triggerHeartBeats();
        Assert.assertFalse((boolean)this.dn0.getFSDataset().trashEnabled(this.blockPoolId));
        BlockPoolSliceStorage bps = this.dn0.getStorage().getBPStorage(this.blockPoolId);
        Assert.assertFalse((boolean)bps.trashEnabled());
    }

    private void rollbackRollingUpgrade() throws Exception {
        LOG.info((Object)"Starting rollback of the rolling upgrade");
        MiniDFSCluster.DataNodeProperties dnprop = this.cluster.stopDataNode(0);
        dnprop.setDnArgs("-rollback");
        this.cluster.shutdownNameNodes();
        this.cluster.restartNameNode("-rollingupgrade", "rollback");
        this.cluster.restartDataNode(dnprop);
        this.cluster.waitActive();
        this.nn = this.cluster.getNameNode(0);
        this.dn0 = this.cluster.getDataNodes().get(0);
        this.triggerHeartBeats();
        LOG.info((Object)"The cluster is active after rollback");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testDatanodeRollingUpgradeWithFinalize() throws Exception {
        try {
            this.startCluster();
            Path testFile1 = new Path("/" + GenericTestUtils.getMethodName() + ".01.dat");
            Path testFile2 = new Path("/" + GenericTestUtils.getMethodName() + ".02.dat");
            DFSTestUtil.createFile((FileSystem)this.fs, testFile1, 0x100000L, (short)1, 464384013L);
            DFSTestUtil.createFile((FileSystem)this.fs, testFile2, 0x100000L, (short)1, 464384013L);
            this.startRollingUpgrade();
            File blockFile = this.getBlockForFile(testFile2, true);
            File trashFile = this.getTrashFileForBlock(blockFile, false);
            this.deleteAndEnsureInTrash(testFile2, blockFile, trashFile);
            this.finalizeRollingUpgrade();
            Assert.assertFalse((boolean)this.isTrashRootPresent());
            assert (!this.fs.exists(testFile2));
            assert (this.fs.exists(testFile1));
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test(timeout=600000L)
    public void testDatanodeRollingUpgradeWithRollback() throws Exception {
        try {
            this.startCluster();
            Path testFile1 = new Path("/" + GenericTestUtils.getMethodName() + ".01.dat");
            DFSTestUtil.createFile((FileSystem)this.fs, testFile1, 0x100000L, (short)1, 464384013L);
            String fileContents1 = DFSTestUtil.readFile((FileSystem)this.fs, testFile1);
            this.startRollingUpgrade();
            File blockFile = this.getBlockForFile(testFile1, true);
            File trashFile = this.getTrashFileForBlock(blockFile, false);
            this.deleteAndEnsureInTrash(testFile1, blockFile, trashFile);
            this.rollbackRollingUpgrade();
            this.ensureTrashRestored(blockFile, trashFile);
            assert (this.fs.exists(testFile1));
            String fileContents2 = DFSTestUtil.readFile((FileSystem)this.fs, testFile1);
            Assert.assertThat((Object)fileContents1, (Matcher)Is.is((Object)fileContents2));
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testDatanodePeersXceiver() throws Exception {
        try {
            this.startCluster();
            String testFile1 = "/" + GenericTestUtils.getMethodName() + ".01.dat";
            String testFile2 = "/" + GenericTestUtils.getMethodName() + ".02.dat";
            String testFile3 = "/" + GenericTestUtils.getMethodName() + ".03.dat";
            DFSClient client1 = new DFSClient(NameNode.getAddress((Configuration)this.conf), this.conf);
            DFSClient client2 = new DFSClient(NameNode.getAddress((Configuration)this.conf), this.conf);
            DFSClient client3 = new DFSClient(NameNode.getAddress((Configuration)this.conf), this.conf);
            DFSOutputStream s1 = (DFSOutputStream)client1.create(testFile1, true);
            DFSOutputStream s2 = (DFSOutputStream)client2.create(testFile2, true);
            DFSOutputStream s3 = (DFSOutputStream)client3.create(testFile3, true);
            byte[] toWrite = new byte[0x800000];
            Random rb = new Random(1111L);
            rb.nextBytes(toWrite);
            s1.write(toWrite, 0, 0x800000);
            s1.flush();
            s2.write(toWrite, 0, 0x800000);
            s2.flush();
            s3.write(toWrite, 0, 0x800000);
            s3.flush();
            Assert.assertTrue((this.dn0.getXferServer().getNumPeersXceiver() == this.dn0.getXferServer().getNumPeersXceiver() ? 1 : 0) != 0);
            s1.close();
            s2.close();
            s3.close();
            Assert.assertTrue((this.dn0.getXferServer().getNumPeersXceiver() == this.dn0.getXferServer().getNumPeersXceiver() ? 1 : 0) != 0);
            client1.close();
            client2.close();
            client3.close();
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testWithLayoutChangeAndFinalize() throws Exception {
        long seed = 1611526157L;
        try {
            this.startCluster();
            Path[] paths = new Path[3];
            File[] blockFiles = new File[3];
            for (int i = 0; i < 2; ++i) {
                paths[i] = new Path("/" + GenericTestUtils.getMethodName() + "." + i + ".dat");
                DFSTestUtil.createFile((FileSystem)this.fs, paths[i], 0x100000L, (short)2, 1611526157L);
            }
            this.startRollingUpgrade();
            blockFiles[0] = this.getBlockForFile(paths[0], true);
            File trashFile0 = this.getTrashFileForBlock(blockFiles[0], false);
            this.deleteAndEnsureInTrash(paths[0], blockFiles[0], trashFile0);
            LOG.info((Object)"Shutting down the Datanode");
            MiniDFSCluster.DataNodeProperties dnprop = this.cluster.stopDataNode(0);
            DFSTestUtil.addDataNodeLayoutVersion(DataNodeLayoutVersion.CURRENT_LAYOUT_VERSION - 1, "Test Layout for TestDataNodeRollingUpgrade");
            LOG.info((Object)"Restarting the DataNode");
            this.cluster.restartDataNode(dnprop, true);
            this.cluster.waitActive();
            this.dn0 = this.cluster.getDataNodes().get(0);
            LOG.info((Object)"The DN has been restarted");
            Assert.assertFalse((boolean)trashFile0.exists());
            Assert.assertFalse((boolean)this.dn0.getStorage().getBPStorage(this.blockPoolId).isTrashAllowed(blockFiles[0]));
            Assert.assertTrue((boolean)this.isBlockFileInPrevious(blockFiles[0]));
            Assert.assertFalse((boolean)this.isTrashRootPresent());
            blockFiles[1] = this.getBlockForFile(paths[1], true);
            this.fs.delete(paths[1], false);
            Assert.assertTrue((boolean)this.isBlockFileInPrevious(blockFiles[1]));
            Assert.assertFalse((boolean)this.isTrashRootPresent());
            this.finalizeRollingUpgrade();
            Assert.assertFalse((boolean)this.isTrashRootPresent());
            Assert.assertFalse((boolean)this.isBlockFileInPrevious(blockFiles[0]));
            Assert.assertFalse((boolean)this.isBlockFileInPrevious(blockFiles[1]));
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testWithLayoutChangeAndRollback() throws Exception {
        long seed = 1611526157L;
        try {
            this.startCluster();
            Path[] paths = new Path[3];
            File[] blockFiles = new File[3];
            for (int i = 0; i < 2; ++i) {
                paths[i] = new Path("/" + GenericTestUtils.getMethodName() + "." + i + ".dat");
                DFSTestUtil.createFile((FileSystem)this.fs, paths[i], 0x100000L, (short)1, 1611526157L);
            }
            this.startRollingUpgrade();
            blockFiles[0] = this.getBlockForFile(paths[0], true);
            File trashFile0 = this.getTrashFileForBlock(blockFiles[0], false);
            this.deleteAndEnsureInTrash(paths[0], blockFiles[0], trashFile0);
            LOG.info((Object)"Shutting down the Datanode");
            MiniDFSCluster.DataNodeProperties dnprop = this.cluster.stopDataNode(0);
            DFSTestUtil.addDataNodeLayoutVersion(DataNodeLayoutVersion.CURRENT_LAYOUT_VERSION - 1, "Test Layout for TestDataNodeRollingUpgrade");
            LOG.info((Object)"Restarting the DataNode");
            this.cluster.restartDataNode(dnprop, true);
            this.cluster.waitActive();
            this.dn0 = this.cluster.getDataNodes().get(0);
            LOG.info((Object)"The DN has been restarted");
            Assert.assertFalse((boolean)trashFile0.exists());
            Assert.assertFalse((boolean)this.dn0.getStorage().getBPStorage(this.blockPoolId).isTrashAllowed(blockFiles[0]));
            Assert.assertTrue((boolean)this.isBlockFileInPrevious(blockFiles[0]));
            Assert.assertFalse((boolean)this.isTrashRootPresent());
            blockFiles[1] = this.getBlockForFile(paths[1], true);
            this.fs.delete(paths[1], false);
            Assert.assertTrue((boolean)this.isBlockFileInPrevious(blockFiles[1]));
            Assert.assertFalse((boolean)this.isTrashRootPresent());
            paths[2] = new Path("/" + GenericTestUtils.getMethodName() + ".2.dat");
            DFSTestUtil.createFile((FileSystem)this.fs, paths[2], 0x100000L, (short)1, 1611526157L);
            blockFiles[2] = this.getBlockForFile(paths[2], true);
            this.fs.delete(paths[2], false);
            Assert.assertFalse((boolean)this.isBlockFileInPrevious(blockFiles[2]));
            Assert.assertFalse((boolean)this.isTrashRootPresent());
        }
        finally {
            this.shutdownCluster();
        }
    }
}

