/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.metadata.HdfsStorageFactory;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAllowFormat {
    public static final String NAME_NODE_HOST = "localhost:";
    public static final String NAME_NODE_HTTP_HOST = "0.0.0.0:";
    private static final Log LOG = LogFactory.getLog((String)TestAllowFormat.class.getName());
    private static final File DFS_BASE_DIR = new File(PathUtils.getTestDir(TestAllowFormat.class), "dfs");
    private static Configuration config;
    private static MiniDFSCluster cluster;

    @BeforeClass
    public static void setUp() throws Exception {
        config = new Configuration();
        if (DFS_BASE_DIR.exists() && !FileUtil.fullyDelete((File)DFS_BASE_DIR)) {
            throw new IOException("Could not delete hdfs directory '" + DFS_BASE_DIR + "'");
        }
        LOG.info((Object)("hdfsdir is " + DFS_BASE_DIR.getAbsolutePath()));
        config.set("dfs.datanode.data.dir", new File(DFS_BASE_DIR, "data").getPath());
        FileSystem.setDefaultUri((Configuration)config, (String)"hdfs://localhost:0");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            LOG.info((Object)"Stopping mini cluster");
        }
        if (DFS_BASE_DIR.exists() && !FileUtil.fullyDelete((File)DFS_BASE_DIR)) {
            throw new IOException("Could not delete hdfs directory in tearDown '" + DFS_BASE_DIR + "'");
        }
    }

    @Test
    public void testAllowFormat() throws IOException {
        LOG.info((Object)"--starting mini cluster");
        config.setBoolean("dfs.namenode.support.allow.format", true);
        cluster = new MiniDFSCluster.Builder(config).manageDataDfsDirs(false).manageNameDfsDirs(false).build();
        cluster.waitActive();
        Assert.assertNotNull((Object)cluster);
        NameNode nn = cluster.getNameNode();
        Assert.assertNotNull((Object)nn);
        LOG.info((Object)"Mini cluster created OK");
        LOG.info((Object)"Verifying format will fail with allowformat false");
        config.setBoolean("dfs.namenode.support.allow.format", false);
        try {
            cluster.shutdown();
            NameNode.format((Configuration)config);
            Assert.fail((String)"Format succeeded, when it should have failed");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"Exception was not about formatting Namenode", (boolean)e.getMessage().startsWith("The option dfs.namenode.support.allow.format"));
            LOG.info((Object)("Expected failure: " + StringUtils.stringifyException((Throwable)e)));
            LOG.info((Object)"Done verifying format will fail with allowformat false");
        }
        LOG.info((Object)"Verifying format will succeed with allowformat true");
        config.setBoolean("dfs.namenode.support.allow.format", true);
        HdfsStorageFactory.reset();
        NameNode.format((Configuration)config);
        LOG.info((Object)"Done verifying format will succeed with allowformat true");
    }

    static {
        cluster = null;
    }
}

