/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlocksMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestCommitBlockSynchronization {
    private static final long blockId = 100L;
    private static final long length = 200L;
    private static final long genStamp = 300L;
    private int leaseCreationLockRows;
    private MiniDFSCluster cluster;

    @Before
    public void setup() throws IOException {
        Configuration conf = new Configuration();
        int leaseCreationLockRows = conf.getInt("dfs.lease.creation.locks.count.key", 1000);
        this.cluster = new MiniDFSCluster.Builder(conf).build();
    }

    @After
    public void shutdown() {
        this.cluster.shutdown();
    }

    private FSNamesystem makeNameSystemSpy(Block block, INodeFile file) throws IOException {
        Configuration conf = new Configuration();
        DatanodeStorageInfo[] targets = new DatanodeStorageInfo[]{};
        FSNamesystem namesystem = new FSNamesystem(conf, this.cluster.getNameNode());
        namesystem.setImageLoaded(true);
        if (file.getParent() == null) {
            INodeDirectory parent = (INodeDirectory)Mockito.mock(INodeDirectory.class);
            parent.setLocalName(new byte[0]);
            file.setParent(parent);
        }
        BlocksMap bmSpy = (BlocksMap)Mockito.spy((Object)namesystem.getBlockManager().getBlocksMap());
        namesystem.getBlockManager().setBlocksMapSpy(bmSpy);
        FSNamesystem namesystemSpy = (FSNamesystem)Mockito.spy((Object)namesystem);
        ((INodeFile)Mockito.doReturn((Object)1L).when((Object)file)).getId();
        BlockInfoContiguousUnderConstruction blockInfo = this.createBlockInfoUnderConstruction(targets, block, file);
        BlockInfoContiguousUnderConstruction mockBlockInfo = (BlockInfoContiguousUnderConstruction)Mockito.mock(BlockInfoContiguousUnderConstruction.class);
        ((BlockInfoContiguousUnderConstruction)Mockito.doReturn((Object)file).when((Object)mockBlockInfo)).getBlockCollection();
        ((BlockInfoContiguousUnderConstruction)Mockito.doReturn((Object)blockInfo.getGenerationStamp()).when((Object)mockBlockInfo)).getGenerationStamp();
        ((BlockInfoContiguousUnderConstruction)Mockito.doReturn((Object)blockInfo.getBlockRecoveryId()).when((Object)mockBlockInfo)).getBlockRecoveryId();
        ((BlockInfoContiguousUnderConstruction)Mockito.doReturn((Object)blockInfo.getBlockId()).when((Object)mockBlockInfo)).getBlockId();
        ((BlockInfoContiguousUnderConstruction)Mockito.doReturn((Object)blockInfo.getInodeId()).when((Object)mockBlockInfo)).getInodeId();
        ((INodeFile)Mockito.doReturn((Object)true).when((Object)file)).removeLastBlock((Block)Matchers.any(Block.class));
        ((INodeFile)Mockito.doReturn((Object)true).when((Object)file)).isUnderConstruction();
        ((FSNamesystem)Mockito.doReturn((Object)mockBlockInfo).when((Object)namesystemSpy)).getStoredBlock((Block)Matchers.any(Block.class));
        ((BlocksMap)Mockito.doReturn((Object)mockBlockInfo).when((Object)bmSpy)).getStoredBlock((Block)Matchers.any(Block.class));
        ((INodeFile)Mockito.doReturn((Object)mockBlockInfo).when((Object)file)).getLastBlock();
        ((FSNamesystem)Mockito.doReturn((Object)"").when((Object)namesystemSpy)).closeFileCommitBlocks((INodeFile)Matchers.any(INodeFile.class), (BlockInfoContiguous)Matchers.any(BlockInfoContiguous.class));
        return namesystemSpy;
    }

    private BlockInfoContiguousUnderConstruction createBlockInfoUnderConstruction(final DatanodeStorageInfo[] targets, final Block block, final INodeFile file) throws IOException {
        return (BlockInfoContiguousUnderConstruction)new HopsTransactionalRequestHandler(HDFSOperationType.COMMIT_BLOCK_SYNCHRONIZATION){
            INodeIdentifier inodeIdentifier;
            {
                super(x0);
                this.inodeIdentifier = new INodeIdentifier(Long.valueOf(1L));
            }

            public void setUp() throws StorageException {
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true)).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, TestCommitBlockSynchronization.this.leaseCreationLockRows)).add(lf.getLeasePathLock()).add(lf.getBlockLock(10L, this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR}));
                EntityManager.snapshotMaintenance((TransactionContextMaintenanceCmds)HdfsTransactionContextMaintenanceCmds.EmptyFile, (Object[])new Object[]{this.inodeIdentifier.getInodeId()});
            }

            public Object performTask() throws IOException {
                BlockInfoContiguousUnderConstruction blockInfo = new BlockInfoContiguousUnderConstruction(block, 1L, HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, targets);
                blockInfo.setBlockCollection((BlockCollection)file);
                blockInfo.setGenerationStamp(300L);
                blockInfo.initializeBlockRecovery(300L, TestCommitBlockSynchronization.this.cluster.getNamesystem().getBlockManager().getDatanodeManager());
                return blockInfo;
            }
        }.handle();
    }

    private INodeFile mockFileUnderConstruction() {
        INodeFile file = (INodeFile)Mockito.mock(INodeFile.class);
        return file;
    }

    @Test
    public void testCommitBlockSynchronization() throws IOException {
        INodeFile file = this.mockFileUnderConstruction();
        Block block = new Block(100L, 200L, 300L);
        FSNamesystem namesystemSpy = this.makeNameSystemSpy(block, file);
        DatanodeID[] newTargets = new DatanodeID[]{};
        ExtendedBlock lastBlock = new ExtendedBlock(null, block);
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, false, false, newTargets, null);
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, false, false, newTargets, null);
        BlockInfoContiguous completedBlockInfo = new BlockInfoContiguous(block, 1L);
        this.setBlockCollectionAndGenerationStamp(completedBlockInfo, file);
        BlockInfoContiguous mockCompletedBlockInfo = (BlockInfoContiguous)Mockito.mock(BlockInfoContiguous.class);
        ((BlockInfoContiguous)Mockito.doReturn((Object)file).when((Object)mockCompletedBlockInfo)).getBlockCollection();
        ((BlockInfoContiguous)Mockito.doReturn((Object)completedBlockInfo.getGenerationStamp()).when((Object)mockCompletedBlockInfo)).getGenerationStamp();
        ((BlockInfoContiguous)Mockito.doReturn((Object)completedBlockInfo.isComplete()).when((Object)mockCompletedBlockInfo)).isComplete();
        ((FSNamesystem)Mockito.doReturn((Object)mockCompletedBlockInfo).when((Object)namesystemSpy)).getStoredBlock((Block)Matchers.any(Block.class));
        ((INodeFile)Mockito.doReturn((Object)mockCompletedBlockInfo).when((Object)file)).getLastBlock();
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, false, false, newTargets, null);
    }

    private BlockInfoContiguousUnderConstruction setBlockCollectionAndGenerationStamp(final BlockInfoContiguous completedBlockInfo, final INodeFile file) throws IOException {
        return (BlockInfoContiguousUnderConstruction)new HopsTransactionalRequestHandler(HDFSOperationType.COMMIT_BLOCK_SYNCHRONIZATION){
            INodeIdentifier inodeIdentifier;
            {
                super(x0);
                this.inodeIdentifier = new INodeIdentifier(Long.valueOf(1L));
            }

            public void setUp() throws StorageException {
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true)).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, TestCommitBlockSynchronization.this.leaseCreationLockRows)).add(lf.getLeasePathLock()).add(lf.getBlockLock(10L, this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR}));
            }

            public Object performTask() throws IOException {
                completedBlockInfo.setBlockCollection((BlockCollection)file);
                completedBlockInfo.setGenerationStamp(300L);
                return null;
            }
        }.handle();
    }

    @Test
    public void testCommitBlockSynchronization2() throws IOException {
        INodeFile file = this.mockFileUnderConstruction();
        Block block = new Block(100L, 200L, 300L);
        FSNamesystem namesystemSpy = this.makeNameSystemSpy(block, file);
        DatanodeID[] newTargets = new DatanodeID[]{};
        ExtendedBlock lastBlock = new ExtendedBlock(null, block);
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, false, false, newTargets, null);
        try {
            namesystemSpy.commitBlockSynchronization(lastBlock, 299L, 200L, false, false, newTargets, null);
            Assert.fail((String)"Failed to get expected IOException on generation stamp/recovery ID mismatch");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testCommitBlockSynchronizationWithDelete() throws IOException {
        INodeFile file = this.mockFileUnderConstruction();
        Block block = new Block(100L, 200L, 300L);
        FSNamesystem namesystemSpy = this.makeNameSystemSpy(block, file);
        DatanodeDescriptor[] targets = new DatanodeDescriptor[]{};
        DatanodeID[] newTargets = new DatanodeID[]{};
        ExtendedBlock lastBlock = new ExtendedBlock(null, block);
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, false, true, newTargets, null);
        ((INodeFile)Mockito.doReturn((Object)false).when((Object)file)).removeLastBlock((Block)Matchers.any(Block.class));
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, false, true, newTargets, null);
    }

    @Test
    public void testCommitBlockSynchronizationWithClose() throws IOException {
        INodeFile file = this.mockFileUnderConstruction();
        Block block = new Block(100L, 200L, 300L);
        FSNamesystem namesystemSpy = this.makeNameSystemSpy(block, file);
        DatanodeDescriptor[] targets = new DatanodeDescriptor[]{};
        DatanodeID[] newTargets = new DatanodeID[]{};
        ExtendedBlock lastBlock = new ExtendedBlock(null, block);
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, true, false, newTargets, null);
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, true, false, newTargets, null);
        BlockInfoContiguous completedBlockInfo = new BlockInfoContiguous(block, 1L);
        this.setBlockCollectionAndGenerationStamp(completedBlockInfo, file);
        BlockInfoContiguous mockCompletedBlockInfo = (BlockInfoContiguous)Mockito.mock(BlockInfoContiguous.class);
        ((BlockInfoContiguous)Mockito.doReturn((Object)file).when((Object)mockCompletedBlockInfo)).getBlockCollection();
        ((BlockInfoContiguous)Mockito.doReturn((Object)completedBlockInfo.getGenerationStamp()).when((Object)mockCompletedBlockInfo)).getGenerationStamp();
        ((BlockInfoContiguous)Mockito.doReturn((Object)completedBlockInfo.isComplete()).when((Object)mockCompletedBlockInfo)).isComplete();
        ((FSNamesystem)Mockito.doReturn((Object)mockCompletedBlockInfo).when((Object)namesystemSpy)).getStoredBlock((Block)Matchers.any(Block.class));
        ((INodeFile)Mockito.doReturn((Object)mockCompletedBlockInfo).when((Object)file)).getLastBlock();
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, true, false, newTargets, null);
    }

    @Test
    public void testCommitBlockSynchronizationWithCloseAndNonExistantTarget() throws IOException {
        INodeFile file = this.mockFileUnderConstruction();
        Block block = new Block(100L, 200L, 300L);
        FSNamesystem namesystemSpy = this.makeNameSystemSpy(block, file);
        DatanodeID[] newTargets = new DatanodeID[]{new DatanodeID("0.0.0.0", "nonexistantHost", "1", 0, 0, 0, 0)};
        ExtendedBlock lastBlock = new ExtendedBlock(null, block);
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, true, false, newTargets, null);
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, true, false, newTargets, null);
    }
}

