/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.OngoingSubTreeOpsDataAccess;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.MDCleaner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Test;

public class TestFailedSTOLockCleaner
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestFailedSTOLockCleaner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSTOCleanup() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        long stoCleanDelay = 1000L;
        try {
            Logger.getRootLogger().setLevel(Level.WARN);
            Logger.getLogger(TestFailedSTOLockCleaner.class).setLevel(Level.ALL);
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setLong("dfs.subtree.clean.failed.ops.locks.delay", stoCleanDelay);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(3)).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem(0);
            FSNamesystem namesystem = cluster.getNamesystem(0);
            dfs.mkdir(new Path("/A"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/B"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/C"), FsPermission.getDefault());
            namesystem.lockSubtree("/A/C", SubTreeOperation.Type.NA);
            namesystem.lockSubtree("/A/B", SubTreeOperation.Type.NA);
            TestFailedSTOLockCleaner.assertEquals((String)"On going subtree ops table", (int)2, (int)TestFailedSTOLockCleaner.countOnGoingSTOs());
            TestFailedSTOLockCleaner.assertEquals((String)"Locked Inodes", (int)2, (int)TestFailedSTOLockCleaner.countLockedINodes());
            cluster.restartNameNode(0);
            long leadercheckInterval = conf.getInt("dfs.leader.check.interval", 2000);
            int missedHeartBeatThreshold = conf.getInt("dfs.leader.missed.hb", 2);
            long delay = stoCleanDelay + leadercheckInterval * (long)(missedHeartBeatThreshold + 1) + 3000L;
            FSNamesystem.LOG.debug((Object)("Testing STO: waiting for " + delay + ". After this the locks should have been reclaimed"));
            Thread.sleep(stoCleanDelay + leadercheckInterval * (long)(missedHeartBeatThreshold + 1) + 3000L);
            TestFailedSTOLockCleaner.assertEquals((String)"On going subtree ops table", (int)0, (int)TestFailedSTOLockCleaner.countOnGoingSTOs());
            TestFailedSTOLockCleaner.assertEquals((String)"Locked Inodes", (int)0, (int)TestFailedSTOLockCleaner.countLockedINodes());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testListingDeadOps() throws IOException {
        int i;
        HdfsConfiguration conf = new HdfsConfiguration();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatHdfsStorage();
        OngoingSubTreeOpsDataAccess da = (OngoingSubTreeOpsDataAccess)HdfsStorageFactory.getDataAccess(OngoingSubTreeOpsDataAccess.class);
        ArrayList<SubTreeOperation> stos = new ArrayList<SubTreeOperation>();
        int NUM_NNs = 10;
        int OPS_PER_NN = 3;
        for (int i2 = 0; i2 < NUM_NNs; ++i2) {
            for (int j = 0; j < OPS_PER_NN; ++j) {
                SubTreeOperation sto = new SubTreeOperation("/A/" + i2 + "/" + j, 0L, (long)i2, SubTreeOperation.Type.NA, (long)i2, "user_nn_" + i2, 0L);
                stos.add(sto);
            }
        }
        da.prepare((Collection)Collections.EMPTY_LIST, stos, (Collection)Collections.EMPTY_LIST);
        int ALIVE_NNS_COUNT = 3;
        long[] aliveNNsIDs = new long[ALIVE_NNS_COUNT];
        for (i = 0; i < ALIVE_NNS_COUNT; ++i) {
            aliveNNsIDs[i] = i;
        }
        for (i = 0; i < NUM_NNs; ++i) {
            List ret = (List)da.allDeadOperations(aliveNNsIDs, (long)(i + 1));
            LOG.info((Object)(" i = " + i + " Ret = " + ret.size()));
            if (i < ALIVE_NNS_COUNT ? !$assertionsDisabled && ret.size() != 0 : !$assertionsDisabled && ret.size() != (i - ALIVE_NNS_COUNT + 1) * OPS_PER_NN) {
                throw new AssertionError();
            }
        }
        List ret = (List)da.allDeadOperations(aliveNNsIDs, 0L);
        LOG.info((Object)("Dead Operations " + ret.size()));
        assert (ret.size() == 0);
        ret = (List)da.allDeadOperations(aliveNNsIDs, (long)NUM_NNs);
        LOG.info((Object)("Dead Operations " + ret.size()));
        assert (ret.size() == NUM_NNs * OPS_PER_NN - ALIVE_NNS_COUNT * OPS_PER_NN);
        for (SubTreeOperation sto : ret) {
            TestFailedSTOLockCleaner.assertTrue((String)("Operation " + sto.getPath() + " NN ID: " + sto.getNameNodeId()), (sto.getNameNodeId() >= (long)ALIVE_NNS_COUNT ? 1 : 0) != 0);
            LOG.info((Object)("Dead Operation " + sto.getPath() + " NN ID: " + sto.getNameNodeId()));
        }
        ret = (List)da.allSlowActiveOperations(aliveNNsIDs, 0L);
        LOG.info((Object)("size --> " + ret.size()));
        assert (ret.size() == 0);
        ret = (List)da.allSlowActiveOperations(aliveNNsIDs, (long)ALIVE_NNS_COUNT);
        assert (ret.size() == ALIVE_NNS_COUNT * OPS_PER_NN);
        for (SubTreeOperation sto : ret) {
            TestFailedSTOLockCleaner.assertTrue((String)("Operation " + sto.getPath() + " NN ID: " + sto.getNameNodeId()), (sto.getNameNodeId() < (long)ALIVE_NNS_COUNT ? 1 : 0) != 0);
            LOG.info((Object)("Dead Operation " + sto.getPath() + " NN ID: " + sto.getNameNodeId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOperationRetry() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        long stoCleanDelay = 10000L;
        try {
            Logger.getRootLogger().setLevel(Level.ALL);
            Logger.getLogger(TestFailedSTOLockCleaner.class).setLevel(Level.ALL);
            Logger.getLogger(MDCleaner.class).setLevel(Level.ALL);
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setLong("dfs.subtree.clean.failed.ops.locks.delay", stoCleanDelay);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(1)).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem(0);
            FSNamesystem namesystem = cluster.getNamesystem(0);
            dfs.mkdir(new Path("/A"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/B"), FsPermission.getDefault());
            namesystem.lockSubtree("/A/B", SubTreeOperation.Type.NA);
            TestFailedSTOLockCleaner.assertEquals((String)"On going subtree ops table", (int)1, (int)TestFailedSTOLockCleaner.countOnGoingSTOs());
            TestFailedSTOLockCleaner.assertEquals((String)"Locked Inodes", (int)1, (int)TestFailedSTOLockCleaner.countLockedINodes());
            long startTime = System.currentTimeMillis();
            cluster.getNameNode(0).getLeaderElectionInstance().relinquishCurrentIdInNextRound();
            try {
                dfs.rename(new Path("/A/B"), new Path("/A/B_new"));
                assert (System.currentTimeMillis() - startTime > stoCleanDelay);
            }
            catch (Exception e) {
                TestFailedSTOLockCleaner.fail((String)"No Exception was expected");
            }
            TestFailedSTOLockCleaner.assertEquals((String)"On going subtree ops table", (int)0, (int)TestFailedSTOLockCleaner.countOnGoingSTOs());
            TestFailedSTOLockCleaner.assertEquals((String)"Locked Inodes", (int)0, (int)TestFailedSTOLockCleaner.countLockedINodes());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnlockMultipleTimes() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        long stoCleanDelay = 10000L;
        try {
            Logger.getRootLogger().setLevel(Level.WARN);
            Logger.getLogger(TestFailedSTOLockCleaner.class).setLevel(Level.ALL);
            Logger.getLogger(MDCleaner.class).setLevel(Level.ALL);
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setLong("dfs.subtree.clean.failed.ops.locks.delay", stoCleanDelay);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(1)).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem(0);
            FSNamesystem namesystem = cluster.getNamesystem(0);
            dfs.mkdir(new Path("/A"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/B"), FsPermission.getDefault());
            INodeIdentifier lockedInodeID = namesystem.lockSubtree("/A/B", SubTreeOperation.Type.NA);
            try {
                namesystem.unlockSubtree("/A/B", lockedInodeID.getInodeId().longValue());
                namesystem.unlockSubtree("/A/B", lockedInodeID.getInodeId().longValue());
                namesystem.unlockSubtree("/A/B", lockedInodeID.getInodeId().longValue());
            }
            catch (Exception e) {
                TestFailedSTOLockCleaner.fail();
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSlowOpCleanup() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        long stoCleanDelay = 10000L;
        try {
            Logger.getRootLogger().setLevel(Level.WARN);
            Logger.getLogger(TestFailedSTOLockCleaner.class).setLevel(Level.ALL);
            Logger.getLogger(MDCleaner.class).setLevel(Level.ALL);
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setLong("dfs.subtree.clean.failed.ops.locks.delay", stoCleanDelay);
            conf.setLong("dfs.subtree.clean.slow.ops.locks.delay.key", stoCleanDelay);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(1)).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem(0);
            FSNamesystem namesystem = cluster.getNamesystem(0);
            dfs.mkdir(new Path("/A"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/B"), FsPermission.getDefault());
            namesystem.lockSubtree("/A/B", SubTreeOperation.Type.NA);
            try {
                namesystem.lockSubtree("/A/B", SubTreeOperation.Type.NA);
                TestFailedSTOLockCleaner.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.sleep(stoCleanDelay * 2L);
            try {
                namesystem.lockSubtree("/A/B", SubTreeOperation.Type.NA);
            }
            catch (Exception e) {
                TestFailedSTOLockCleaner.fail((String)e.toString());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static int countOnGoingSTOs() throws IOException {
        LightWeightRequestHandler subTreeLockChecker = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                OngoingSubTreeOpsDataAccess da = (OngoingSubTreeOpsDataAccess)HdfsStorageFactory.getDataAccess(OngoingSubTreeOpsDataAccess.class);
                return da.allOps().size();
            }
        };
        return (Integer)subTreeLockChecker.handle();
    }

    public static int countLockedINodes() throws IOException {
        LightWeightRequestHandler subTreeLockChecker = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                return ida.countSubtreeLockedInodes();
            }
        };
        return (Integer)subTreeLockChecker.handle();
    }
}

