/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.XAttrStorage;
import org.apache.hadoop.hdfs.server.namenode.XAttrTestHelpers;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.Assert;
import org.junit.Test;

public class TestLargeXAttr {
    @Test
    public void testConfiguration() throws Exception {
        MiniDFSCluster cluster;
        int maxSize = XAttrStorage.getMaxXAttrSize();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 3);
        conf.setInt("dfs.namenode.fs-limits.max-xattr-size", maxSize + 1);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            Assert.fail((String)"Should throw an exception if the xattr size is larger than the hard limit.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)("The maximum size of an xattr should be <= maximum size hard limit " + maxSize + ": (dfs.namenode.fs-limits.max-xattr-size)."), (Object)ex.getMessage());
        }
        conf.setInt("dfs.namenode.fs-limits.max-xattr-size", 0);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            Assert.fail((String)"Should throw an exception if the xattr size is 0");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"The maximum size of an xattr should be > 0: (dfs.namenode.fs-limits.max-xattr-size).", (Object)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetXAttrLargerThanConfiguredSize() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 3);
        conf.setInt("dfs.namenode.fs-limits.max-xattr-size", XAttrStorage.getDefaultXAttrSize());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            dfs.mkdirs(dir);
            String name = "testXAttr";
            byte[] value = XAttrTestHelpers.generateRandomByteArray(XAttrStorage.getDefaultXAttrValueSize() + 1);
            try {
                dfs.setXAttr(dir, "user." + name, value);
                Assert.fail((String)"Should fail to setXAttr with value larger than the configured limit");
            }
            catch (RemoteException ex) {
                Assert.assertEquals((Object)HadoopIllegalArgumentException.class.getCanonicalName(), (Object)ex.getClassName());
                Assert.assertTrue((boolean)ex.getMessage().contains("The XAttr value is too big. The maximum size of the value is " + XAttrStorage.getDefaultXAttrValueSize() + ", but the value size is " + value.length));
            }
            name = XAttrTestHelpers.generateRandomXAttrName(XAttrStorage.getMaxXAttrNameSize() + 1);
            value = XAttrTestHelpers.generateRandomByteArray(100);
            try {
                dfs.setXAttr(dir, "user." + name, value);
                Assert.fail((String)"Should fail to setXAttr with name larger than the maximum limit");
            }
            catch (RemoteException ex) {
                Assert.assertEquals((Object)HadoopIllegalArgumentException.class.getCanonicalName(), (Object)ex.getClassName());
                Assert.assertTrue((boolean)ex.getMessage().contains("The XAttr name is too big. The maximum size of the name is " + XAttrStorage.getMaxXAttrNameSize() + ", but the name size is " + XAttrStorage.getXAttrByteSize((String)name)));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testXAttr135KB() throws Exception {
        this.testXAttr(10, 5);
    }

    @Test
    public void testXAttr1_35MB() throws Exception {
        this.testXAttr(100, 5);
    }

    @Test
    public void testXAttr3_44MB() throws Exception {
        this.testXAttr(255, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testXAttr(int rows, int numXAttrs) throws Exception {
        int MAX_VALUE_SIZE = rows * XAttrStorage.getDefaultXAttrValueSize();
        int MAX_SIZE = XAttrStorage.getMaxXAttrNameSize() + MAX_VALUE_SIZE;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", numXAttrs);
        conf.setInt("dfs.namenode.fs-limits.max-xattr-size", MAX_SIZE);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            dfs.mkdirs(dir);
            String nameBase = "user.test";
            HashMap<String, byte[]> testXAttrs = new HashMap<String, byte[]>();
            for (int i = 0; i < numXAttrs; ++i) {
                Iterator name = nameBase + i;
                int n = RandomUtils.nextInt((int)0, (int)101);
                byte[] value = XAttrTestHelpers.generateRandomByteArray(MAX_VALUE_SIZE - n);
                testXAttrs.put((String)((Object)name), value);
                dfs.setXAttr(dir, (String)((Object)name), value);
                byte[] returnedValue = dfs.getXAttr(dir, (String)((Object)name));
                Assert.assertArrayEquals((byte[])value, (byte[])returnedValue);
            }
            Assert.assertEquals((long)(numXAttrs * rows), (long)XAttrTestHelpers.getXAttrTableRowCount());
            Map returnedXAttrs = dfs.getXAttrs(dir);
            Assert.assertEquals((long)numXAttrs, (long)returnedXAttrs.size());
            for (Map.Entry entry : testXAttrs.entrySet()) {
                Assert.assertArrayEquals((byte[])((byte[])returnedXAttrs.get(entry.getKey())), (byte[])((byte[])entry.getValue()));
            }
            returnedXAttrs = dfs.getXAttrs(dir, new ArrayList(testXAttrs.keySet()));
            Assert.assertEquals((long)numXAttrs, (long)returnedXAttrs.size());
            for (Map.Entry entry : testXAttrs.entrySet()) {
                Assert.assertArrayEquals((byte[])((byte[])returnedXAttrs.get(entry.getKey())), (byte[])((byte[])entry.getValue()));
            }
            for (int i = 0; i < numXAttrs; ++i) {
                String string = nameBase + i;
                int k = RandomUtils.nextInt((int)0, (int)101);
                byte[] value = XAttrTestHelpers.generateRandomByteArray(MAX_VALUE_SIZE - k);
                testXAttrs.put(string, value);
                dfs.setXAttr(dir, string, value, EnumSet.of(XAttrSetFlag.REPLACE));
                byte[] returnedValue = dfs.getXAttr(dir, string);
                Assert.assertArrayEquals((byte[])value, (byte[])returnedValue);
            }
            Assert.assertEquals((long)(numXAttrs * rows), (long)XAttrTestHelpers.getXAttrTableRowCount());
            returnedXAttrs = dfs.getXAttrs(dir);
            Assert.assertEquals((long)numXAttrs, (long)returnedXAttrs.size());
            for (Map.Entry entry : testXAttrs.entrySet()) {
                Assert.assertArrayEquals((byte[])((byte[])returnedXAttrs.get(entry.getKey())), (byte[])((byte[])entry.getValue()));
            }
            for (int i = 0; i < numXAttrs; ++i) {
                String string = nameBase + i;
                dfs.removeXAttr(dir, string);
                returnedXAttrs = dfs.getXAttrs(dir);
                Assert.assertEquals((long)(numXAttrs - (i + 1)), (long)returnedXAttrs.size());
                for (Map.Entry entry : returnedXAttrs.entrySet()) {
                    Assert.assertArrayEquals((byte[])((byte[])entry.getValue()), (byte[])((byte[])testXAttrs.get(entry.getKey())));
                }
            }
            Assert.assertEquals((long)0L, (long)XAttrTestHelpers.getXAttrTableRowCount());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testReplaceLargeXAttr2() throws Exception {
        this.testReplaceLargeXAttr(2, 1);
    }

    @Test
    public void testReplaceLargeXAttr10() throws Exception {
        this.testReplaceLargeXAttr(10, 2);
    }

    @Test
    public void testReplaceLargeXAttr10ForAll() throws Exception {
        int rows = 10;
        for (int row = 1; row <= rows; ++row) {
            this.testReplaceLargeXAttr(rows, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReplaceLargeXAttr(int rows, int replaceRows) throws Exception {
        int MAX_VALUE_ROW_SIZE = XAttrStorage.getDefaultXAttrValueSize();
        int MAX_VALUE_SIZE = rows * MAX_VALUE_ROW_SIZE;
        int MAX_SIZE = XAttrStorage.getMaxXAttrNameSize() + MAX_VALUE_SIZE;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 5);
        conf.setInt("dfs.namenode.fs-limits.max-xattr-size", MAX_SIZE);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            dfs.mkdirs(dir);
            String name = "user.test";
            byte[] value = XAttrTestHelpers.generateRandomByteArray(MAX_VALUE_SIZE);
            dfs.setXAttr(dir, name, value);
            byte[] returnedValue = dfs.getXAttr(dir, name);
            Assert.assertArrayEquals((byte[])value, (byte[])returnedValue);
            Assert.assertEquals((long)rows, (long)XAttrTestHelpers.getXAttrTableRowCount());
            byte[] value2 = XAttrTestHelpers.generateRandomByteArray(MAX_VALUE_ROW_SIZE * replaceRows);
            dfs.setXAttr(dir, name, value2, EnumSet.of(XAttrSetFlag.REPLACE));
            returnedValue = dfs.getXAttr(dir, name);
            Assert.assertArrayEquals((byte[])value2, (byte[])returnedValue);
            Assert.assertEquals((long)replaceRows, (long)XAttrTestHelpers.getXAttrTableRowCount());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

