/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.Assert;
import org.junit.Test;

public class TestNameNodeOptionParsing {
    @Test(timeout=10000L)
    public void testUpgrade() {
        HdfsServerConstants.StartupOption opt = null;
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade"});
        Assert.assertEquals((Object)opt, (Object)HdfsServerConstants.StartupOption.UPGRADE);
        Assert.assertNull((Object)opt.getClusterId());
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-clusterid", "mycid"});
        Assert.assertEquals((Object)HdfsServerConstants.StartupOption.UPGRADE, (Object)opt);
        Assert.assertEquals((Object)"mycid", (Object)opt.getClusterId());
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-cid"});
        Assert.assertNull((Object)opt);
    }

    @Test(timeout=10000L)
    public void testRollingUpgrade() {
        String[] args = new String[]{"-rollingUpgrade"};
        HdfsServerConstants.StartupOption opt = NameNode.parseArguments((String[])args);
        Assert.assertNull((Object)opt);
        args = new String[]{"-rollingUpgrade", "started"};
        opt = NameNode.parseArguments((String[])args);
        Assert.assertEquals((Object)HdfsServerConstants.StartupOption.ROLLINGUPGRADE, (Object)opt);
        Assert.assertEquals((Object)HdfsServerConstants.RollingUpgradeStartupOption.STARTED, (Object)opt.getRollingUpgradeStartupOption());
        Assert.assertTrue((boolean)HdfsServerConstants.RollingUpgradeStartupOption.STARTED.matches(opt));
        args = new String[]{"-rollingUpgrade", "downgrade"};
        opt = NameNode.parseArguments((String[])args);
        Assert.assertEquals((Object)HdfsServerConstants.StartupOption.ROLLINGUPGRADE, (Object)opt);
        Assert.assertEquals((Object)HdfsServerConstants.RollingUpgradeStartupOption.DOWNGRADE, (Object)opt.getRollingUpgradeStartupOption());
        Assert.assertTrue((boolean)HdfsServerConstants.RollingUpgradeStartupOption.DOWNGRADE.matches(opt));
        args = new String[]{"-rollingUpgrade", "rollback"};
        opt = NameNode.parseArguments((String[])args);
        Assert.assertEquals((Object)HdfsServerConstants.StartupOption.ROLLINGUPGRADE, (Object)opt);
        Assert.assertEquals((Object)HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK, (Object)opt.getRollingUpgradeStartupOption());
        Assert.assertTrue((boolean)HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK.matches(opt));
        args = new String[]{"-rollingUpgrade", "foo"};
        try {
            NameNode.parseArguments((String[])args);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

