/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ClientId;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcConstants;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNamenodeRetryCache {
    private static final byte[] CLIENT_ID = ClientId.getClientId();
    private static MiniDFSCluster cluster;
    private static NamenodeProtocols nnRpc;
    private static final FsPermission perm;
    private static DistributedFileSystem filesystem;
    private static int callId;
    private static Configuration conf;
    private static final int BlockSize = 512;
    private static final int expirityTime = 30000;

    @Before
    public void setup() throws Exception {
        conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 512L);
        conf.setBoolean("dfs.namenode.enable.retrycache", true);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setLong("dfs.namenode.retrycache.expirytime.millis", 60000L);
        cluster = new MiniDFSCluster.Builder(conf).build();
        cluster.waitActive();
        nnRpc = cluster.getNameNode().getRpcServer();
        filesystem = cluster.getFileSystem();
    }

    @After
    public void cleanup() throws IOException {
        cluster.shutdown();
    }

    public static void incrementCallId() {
        ++callId;
    }

    public static void newCall() {
        Server.Call call = new Server.Call(++callId, 1, null, null, RPC.RpcKind.RPC_PROTOCOL_BUFFER, CLIENT_ID, Client.getRpcEpochSec());
        Server.getCurCall().set(call);
    }

    public static void resetCall() {
        Server.Call call = new Server.Call(-2, 1, null, null, RPC.RpcKind.RPC_PROTOCOL_BUFFER, RpcConstants.DUMMY_CLIENT_ID, 0L);
        Server.getCurCall().set(call);
    }

    private void concatSetup(String file1, String file2) throws Exception {
        DFSTestUtil.createFile((FileSystem)filesystem, new Path(file1), 512L, (short)1, 0L);
        DFSTestUtil.createFile((FileSystem)filesystem, new Path(file2), 512L, (short)1, 0L);
    }

    @Test
    public void testConcat() throws Exception {
        TestNamenodeRetryCache.resetCall();
        String file1 = "/testNamenodeRetryCache/testConcat/file1";
        String file2 = "/testNamenodeRetryCache/testConcat/file2";
        this.concatSetup(file1, file2);
        TestNamenodeRetryCache.newCall();
        nnRpc.concat(file1, new String[]{file2});
        nnRpc.concat(file1, new String[]{file2});
        nnRpc.concat(file1, new String[]{file2});
        TestNamenodeRetryCache.newCall();
        try {
            nnRpc.concat(file1, new String[]{file2});
            Assert.fail((String)"testConcat - expected exception is not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testDelete() throws Exception {
        String dir = "/testNamenodeRetryCache/testDelete";
        TestNamenodeRetryCache.newCall();
        nnRpc.mkdirs(dir, perm, true);
        TestNamenodeRetryCache.newCall();
        Assert.assertTrue((boolean)nnRpc.delete(dir, false));
        Assert.assertTrue((boolean)nnRpc.delete(dir, false));
        Assert.assertTrue((boolean)nnRpc.delete(dir, false));
        TestNamenodeRetryCache.newCall();
        Assert.assertFalse((boolean)nnRpc.delete(dir, false));
    }

    @Test
    public void testCreateSymlink() throws Exception {
        String target = "/testNamenodeRetryCache/testCreateSymlink/target";
        TestNamenodeRetryCache.newCall();
        nnRpc.createSymlink(target, "/a/b", perm, true);
        nnRpc.createSymlink(target, "/a/b", perm, true);
        nnRpc.createSymlink(target, "/a/b", perm, true);
        TestNamenodeRetryCache.newCall();
        try {
            nnRpc.createSymlink(target, "/a/b", perm, true);
            Assert.fail((String)"testCreateSymlink - expected exception is not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testCreate() throws Exception {
        String src = "/testNamenodeRetryCache/testCreate/file";
        TestNamenodeRetryCache.newCall();
        HdfsFileStatus status = nnRpc.create(src, perm, "holder", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)1, 512L, null, null);
        Assert.assertEquals((long)status.getFileId(), (long)nnRpc.create(src, perm, "holder", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)1, 512L, null, null).getFileId());
        Assert.assertEquals((long)status.getFileId(), (long)nnRpc.create(src, perm, "holder", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)1, 512L, null, null).getFileId());
        TestNamenodeRetryCache.newCall();
        try {
            nnRpc.create(src, perm, "holder", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)1, 512L, null, null);
            Assert.fail((String)"testCreate - expected exception is not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testAppend() throws Exception {
        String src = "/testNamenodeRetryCache/testAppend/src";
        TestNamenodeRetryCache.resetCall();
        DFSTestUtil.createFile((FileSystem)filesystem, new Path(src), 128L, (short)1, 0L);
        TestNamenodeRetryCache.newCall();
        LastBlockWithStatus b = nnRpc.append(src, "holder", new EnumSetWritable(EnumSet.of(CreateFlag.APPEND)));
        Assert.assertEquals((long)b.getLastBlock().getBlock().getBlockId(), (long)nnRpc.append(src, "holder", new EnumSetWritable(EnumSet.of(CreateFlag.APPEND))).getLastBlock().getBlock().getBlockId());
        Assert.assertEquals((long)b.getLastBlock().getBlock().getBlockId(), (long)nnRpc.append(src, "holder", new EnumSetWritable(EnumSet.of(CreateFlag.APPEND))).getLastBlock().getBlock().getBlockId());
        TestNamenodeRetryCache.newCall();
        try {
            nnRpc.append(src, "holder", new EnumSetWritable(EnumSet.of(CreateFlag.APPEND)));
            Assert.fail((String)"testAppend - expected exception is not thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRename1() throws Exception {
        String src = "/testNamenodeRetryCache/testRename1/src";
        String target = "/testNamenodeRetryCache/testRename1/target";
        TestNamenodeRetryCache.resetCall();
        nnRpc.mkdirs(src, perm, true);
        TestNamenodeRetryCache.newCall();
        Assert.assertTrue((boolean)nnRpc.rename(src, target));
        Assert.assertTrue((boolean)nnRpc.rename(src, target));
        Assert.assertTrue((boolean)nnRpc.rename(src, target));
        TestNamenodeRetryCache.newCall();
        Assert.assertFalse((boolean)nnRpc.rename(src, target));
    }

    @Test
    public void testRename2() throws Exception {
        String src = "/testNamenodeRetryCache/testRename2/src";
        String target = "/testNamenodeRetryCache/testRename2/target";
        TestNamenodeRetryCache.resetCall();
        nnRpc.mkdirs(src, perm, true);
        TestNamenodeRetryCache.newCall();
        nnRpc.rename2(src, target, new Options.Rename[]{Options.Rename.NONE});
        nnRpc.rename2(src, target, new Options.Rename[]{Options.Rename.NONE});
        nnRpc.rename2(src, target, new Options.Rename[]{Options.Rename.NONE});
        TestNamenodeRetryCache.newCall();
        try {
            nnRpc.rename2(src, target, new Options.Rename[]{Options.Rename.NONE});
            Assert.fail((String)"testRename 2 expected exception is not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testUpdatePipelineWithFailOver() throws Exception {
        cluster.shutdown();
        nnRpc = null;
        filesystem = null;
        cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).numDataNodes(1).build();
        cluster.waitActive();
        NamenodeProtocols ns0 = cluster.getNameNodeRpc(0);
        ExtendedBlock oldBlock = new ExtendedBlock();
        ExtendedBlock newBlock = new ExtendedBlock();
        DatanodeID[] newNodes = new DatanodeID[2];
        String[] newStorages = new String[2];
        cluster.shutdownNameNode(0);
        cluster.shutdownNameNode(1);
        TestNamenodeRetryCache.newCall();
        try {
            ns0.updatePipeline("testClient", oldBlock, newBlock, newNodes, newStorages);
            Assert.fail((String)"Expect StandbyException from the updatePipeline call");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"does not exist or is not under Construction", (Throwable)e);
        }
        cluster.restartNameNodes();
        try {
            ns0.updatePipeline("testClient", oldBlock, newBlock, newNodes, newStorages);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRetryCacheRebuild() throws Exception {
        DFSTestUtil.runOperations(cluster, filesystem, conf, 512L, 0);
        FSNamesystem namesystem = cluster.getNamesystem();
        List cacheSet = namesystem.getCacheSet();
        Assert.assertEquals((long)22L, (long)cacheSet.size());
        HashMap<RetryCacheEntry, RetryCacheEntry> oldEntries = new HashMap<RetryCacheEntry, RetryCacheEntry>();
        for (RetryCacheEntry entry : cacheSet) {
            oldEntries.put(entry, entry);
        }
        cluster.restartNameNode(new String[0]);
        cluster.waitActive();
        namesystem = cluster.getNamesystem();
        Assert.assertTrue((boolean)namesystem.hasRetryCache());
        cacheSet = namesystem.getCacheSet();
        Assert.assertEquals((long)22L, (long)cacheSet.size());
        Iterator iter = cacheSet.iterator();
        FSNamesystem.LOG.info((Object)("Checking: " + Arrays.toString(oldEntries.keySet().toArray())));
        while (iter.hasNext()) {
            RetryCacheEntry entry;
            entry = (RetryCacheEntry)iter.next();
            FSNamesystem.LOG.info((Object)("Checking " + entry));
            Assert.assertTrue((boolean)oldEntries.containsKey(entry));
        }
    }

    @Test
    public void testRetryCacheCleaning() throws Exception {
        DFSTestUtil.runOperations(cluster, filesystem, conf, 512L, 0);
        FSNamesystem namesystem = cluster.getNamesystem();
        List cacheSet = namesystem.getCacheSet();
        Assert.assertEquals((long)22L, (long)cacheSet.size());
        HashMap<RetryCacheEntry, RetryCacheEntry> oldEntries = new HashMap<RetryCacheEntry, RetryCacheEntry>();
        for (RetryCacheEntry entry : cacheSet) {
            oldEntries.put(entry, entry);
        }
        cluster.restartNameNode(new String[0]);
        cluster.waitActive();
        namesystem = cluster.getNamesystem();
        Thread.sleep(90000L);
        Assert.assertTrue((boolean)namesystem.hasRetryCache());
        cacheSet = namesystem.getCacheSet();
        Assert.assertEquals((long)0L, (long)cacheSet.size());
    }

    @Test
    public void testSetXAttr() throws Exception {
        TestNamenodeRetryCache.resetCall();
        String src = "/testNamenodeRetryCache/testSetXAttr/src";
        DFSTestUtil.createFile((FileSystem)filesystem, new Path(src), 128L, (short)1, 0L);
        XAttr xAttr = XAttrHelper.buildXAttr((String)"user.test", (byte[])"test".getBytes());
        TestNamenodeRetryCache.newCall();
        nnRpc.setXAttr(src, xAttr, EnumSet.of(XAttrSetFlag.CREATE));
        nnRpc.setXAttr(src, xAttr, EnumSet.of(XAttrSetFlag.CREATE));
        nnRpc.setXAttr(src, xAttr, EnumSet.of(XAttrSetFlag.CREATE));
        TestNamenodeRetryCache.newCall();
        try {
            nnRpc.setXAttr(src, xAttr, EnumSet.of(XAttrSetFlag.CREATE));
            Assert.fail((String)"testSetXAttr - expected exception is not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveXAttr() throws Exception {
        TestNamenodeRetryCache.resetCall();
        String src = "/testNamenodeRetryCache/testRemoveXAttr/src";
        DFSTestUtil.createFile((FileSystem)filesystem, new Path(src), 128L, (short)1, 0L);
        XAttr xAttr = XAttrHelper.buildXAttr((String)"user.test", (byte[])"test".getBytes());
        filesystem.setXAttr(new Path(src), XAttrHelper.getPrefixName((XAttr)xAttr), xAttr.getValue());
        TestNamenodeRetryCache.newCall();
        nnRpc.removeXAttr(src, xAttr);
        nnRpc.removeXAttr(src, xAttr);
        nnRpc.removeXAttr(src, xAttr);
        TestNamenodeRetryCache.newCall();
        try {
            nnRpc.removeXAttr(src, xAttr);
            Assert.fail((String)"testRemoveXAttr - expected exception is not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        perm = FsPermission.getDefault();
        callId = 100;
    }
}

