/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.TestUtil;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaByStorageTypeExceededException;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.TestLeaseManager;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSmallFilesDiskspaceQuotaUpdate {
    private short REPLICATION = (short)2;
    private int BLOCKSIZE = 4096;
    private int MAX_SMALL_FILES_SIZE = 65536;
    private long BLOCK_SIZE_CONF = 10 * this.MAX_SMALL_FILES_SIZE;
    final int DEFAULT_BLOCK_REPLICATION = 3;
    static final long seed = 0L;
    private static final Path dir = new Path("/TestQuotaUpdate");
    private Configuration conf;
    private MiniDFSCluster cluster;
    private FSDirectory fsdir;
    private DistributedFileSystem dfs;
    private int leaseCreationLockRows;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", this.BLOCK_SIZE_CONF);
        this.conf.setInt("dfs.db.replication", (int)this.REPLICATION);
        this.conf.setInt("dfs.replication", 3);
        this.conf.setInt("dfs.db.file.max.size", this.MAX_SMALL_FILES_SIZE);
        this.leaseCreationLockRows = this.conf.getInt("dfs.lease.creation.locks.count.key", 1000);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).format(true).build();
        this.cluster.waitActive();
        this.fsdir = this.cluster.getNamesystem().getFSDirectory();
        this.dfs = this.cluster.getFileSystem();
        this.dfs.setStoragePolicy(new Path("/"), "DB");
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testQuotaUpdateWithFileCreate() throws Exception {
        Path foo = new Path(dir, "foo");
        Path createdFile = new Path(foo, "created_file.data");
        this.dfs.mkdirs(foo);
        this.dfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        long fileLen = this.BLOCKSIZE * 2 + this.BLOCKSIZE / 2;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile, this.BLOCKSIZE / 16, fileLen, this.BLOCKSIZE, this.REPLICATION, 0L);
        DFSTestUtil.waitForQuotaUpdatesToBeApplied();
        QuotaCounts cnt = this.getSpaceConsumed(foo);
        Assert.assertEquals((long)2L, (long)cnt.getNameSpace());
        Assert.assertEquals((long)(fileLen * (long)this.REPLICATION), (long)cnt.getStorageSpace());
        Assert.assertEquals((long)cnt.getStorageSpace(), (long)cnt.getTypeSpace(StorageType.DB));
    }

    @Test
    public void testUpdateQuotaForAppend() throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(foo, "bar");
        long currentFileLen = this.BLOCKSIZE;
        DFSTestUtil.createFile((FileSystem)this.dfs, bar, currentFileLen, this.REPLICATION, 0L);
        this.dfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        DFSTestUtil.appendFile((FileSystem)this.dfs, bar, this.BLOCKSIZE / 2);
        currentFileLen += (long)(this.BLOCKSIZE / 2);
        DFSTestUtil.waitForQuotaUpdatesToBeApplied();
        QuotaCounts quota = this.getSpaceConsumed(foo);
        long ns = quota.getNameSpace();
        long ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)(currentFileLen * (long)this.REPLICATION), (long)ds);
        ContentSummary c = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)ds);
        Assert.assertEquals((long)c.getTypeConsumed(StorageType.DB), (long)ds);
        DFSTestUtil.appendFile((FileSystem)this.dfs, bar, this.BLOCKSIZE);
        currentFileLen += (long)this.BLOCKSIZE;
        DFSTestUtil.waitForQuotaUpdatesToBeApplied();
        quota = this.getSpaceConsumed(foo);
        ns = quota.getNameSpace();
        ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)(currentFileLen * (long)this.REPLICATION), (long)ds);
        c = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)ds);
        Assert.assertEquals((long)c.getTypeConsumed(StorageType.DB), (long)ds);
        DFSTestUtil.appendFile((FileSystem)this.dfs, bar, this.BLOCKSIZE * 3 + this.BLOCKSIZE / 8);
        currentFileLen += (long)(this.BLOCKSIZE * 3 + this.BLOCKSIZE / 8);
        DFSTestUtil.waitForQuotaUpdatesToBeApplied();
        quota = this.getSpaceConsumed(foo);
        ns = quota.getNameSpace();
        ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)(currentFileLen * (long)this.REPLICATION), (long)ds);
        c = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)ds);
        Assert.assertEquals((long)c.getTypeConsumed(StorageType.DB), (long)ds);
    }

    @Test(timeout=60000L)
    public void testUpdateQuotaForFSync() throws Exception {
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)this.dfs, bar, this.BLOCKSIZE, this.REPLICATION, 0L);
        this.dfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        QuotaCounts quota = this.getSpaceConsumed(foo);
        long ns = quota.getNameSpace();
        long ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)(this.BLOCKSIZE * this.REPLICATION), (long)ds);
        Assert.assertEquals((long)ds, (long)quota.getTypeSpace(StorageType.DB));
        Assert.assertEquals((long)0L, (long)quota.getTypeSpace(StorageType.DISK));
        Assert.assertEquals((long)this.REPLICATION, (long)this.dfs.getFileStatus(bar).getReplication());
        FSDataOutputStream out = this.dfs.append(bar);
        out.write(new byte[this.BLOCKSIZE / 4]);
        ((DFSOutputStream)out.getWrappedStream()).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        DFSTestUtil.waitForQuotaUpdatesToBeApplied();
        quota = this.getSpaceConsumed(foo, false);
        ns = quota.getNameSpace();
        ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)((this.BLOCKSIZE + this.BLOCKSIZE / 4) * 3), (long)ds);
        Assert.assertEquals((long)(this.BLOCK_SIZE_CONF * 3L), (long)this.dfs.getLastUpdatedContentSummary(foo).getSpaceConsumed());
        Assert.assertEquals((long)ds, (long)quota.getTypeSpace(StorageType.DISK));
        Assert.assertEquals((long)0L, (long)quota.getTypeSpace(StorageType.DB));
        Assert.assertEquals((long)3L, (long)this.dfs.getFileStatus(bar).getReplication());
        out.write(new byte[this.BLOCKSIZE / 4]);
        out.close();
        DFSTestUtil.waitForQuotaUpdatesToBeApplied();
        quota = this.getSpaceConsumed(foo);
        ns = quota.getNameSpace();
        ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)((this.BLOCKSIZE + this.BLOCKSIZE / 2) * 3), (long)ds);
        Assert.assertEquals((long)ds, (long)quota.getTypeSpace(StorageType.DISK));
        Assert.assertEquals((long)0L, (long)quota.getTypeSpace(StorageType.DB));
        DFSTestUtil.appendFile((FileSystem)this.dfs, bar, this.BLOCKSIZE);
        DFSTestUtil.waitForQuotaUpdatesToBeApplied();
        quota = this.getSpaceConsumed(foo);
        ns = quota.getNameSpace();
        ds = quota.getStorageSpace();
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)((this.BLOCKSIZE * 2 + this.BLOCKSIZE / 2) * 3), (long)ds);
        Assert.assertEquals((long)ds, (long)quota.getTypeSpace(StorageType.DISK));
        Assert.assertEquals((long)0L, (long)quota.getTypeSpace(StorageType.DB));
    }

    @Test
    public void testAppendOverStorageQuota() throws Exception {
        Path dir = new Path("/TestAppendOverQuota");
        Path file = new Path(dir, "file");
        this.dfs.mkdirs(dir);
        DFSTestUtil.createFile((FileSystem)this.dfs, file, this.BLOCKSIZE / 2, this.REPLICATION, 0L);
        this.dfs.setQuota(dir, 0x7FFFFFFFFFFFFFFEL, 1L);
        long spaceUsed = this.getSpaceConsumed(dir).getStorageSpace();
        try {
            DFSTestUtil.appendFile((FileSystem)this.dfs, file, this.BLOCKSIZE);
            Assert.fail((String)"append didn't fail");
        }
        catch (DSQuotaExceededException dSQuotaExceededException) {
            // empty catch block
        }
        INodeFile inode = this.getINodeFile(file);
        Assert.assertNotNull((Object)inode);
        Assert.assertFalse((String)"should not be UC", (boolean)inode.isUnderConstruction());
        Assert.assertNull((String)"should not have a lease", (Object)TestLeaseManager.getLeaseByPath(this.cluster.getNamesystem().getLeaseManager(), file.toString()));
        long newSpaceUsed = this.getSpaceConsumed(dir).getStorageSpace();
        Assert.assertEquals((long)spaceUsed, (long)newSpaceUsed);
        Assert.assertEquals((long)spaceUsed, (long)this.getSpaceConsumed(dir).getTypeSpace(StorageType.DB));
        this.dfs.recoverLease(file);
        this.cluster.restartNameNodes();
    }

    @Test(timeout=60000L)
    public void testAppendOverTypeQuota() throws Exception {
        Path dir = new Path("/TestAppendOverTypeQuota");
        Path file = new Path(dir, "file");
        this.dfs.mkdirs(dir);
        this.dfs.setStoragePolicy(dir, "DB");
        DFSTestUtil.createFile((FileSystem)this.dfs, file, this.BLOCKSIZE / 2, this.REPLICATION, 0L);
        Assert.assertTrue((boolean)this.getINodeFile(file).isFileStoredInDB());
        this.dfs.setQuotaByStorageType(dir, StorageType.DB, 1L);
        long spaceUsed = this.getSpaceConsumed(dir).getStorageSpace();
        Assert.assertEquals((long)spaceUsed, (long)this.getSpaceConsumed(dir).getTypeSpace(StorageType.DB));
        try {
            DFSTestUtil.appendFile((FileSystem)this.dfs, file, this.BLOCKSIZE);
            Assert.fail((String)"append didn't fail");
        }
        catch (QuotaByStorageTypeExceededException quotaByStorageTypeExceededException) {
            // empty catch block
        }
        INodeFile inode = this.getINodeFile(file);
        Assert.assertNotNull((Object)inode);
        Assert.assertFalse((String)"should not be UC", (boolean)inode.isUnderConstruction());
        Assert.assertNull((String)"should not have a lease", (Object)TestLeaseManager.getLeaseByPath(this.cluster.getNamesystem().getLeaseManager(), file.toString()));
        long newSpaceUsed = this.getSpaceConsumed(dir).getStorageSpace();
        Assert.assertEquals((long)spaceUsed, (long)newSpaceUsed);
        Assert.assertEquals((long)spaceUsed, (long)this.getSpaceConsumed(dir).getTypeSpace(StorageType.DB));
        this.dfs.recoverLease(file);
        this.cluster.restartNameNodes();
    }

    @Test(timeout=60000L)
    public void testTruncateOverQuota() throws Exception {
        Path dir = new Path("/TestTruncateOverquota");
        Path file = new Path(dir, "file");
        this.dfs.mkdirs(dir);
        DFSTestUtil.createFile((FileSystem)this.dfs, file, this.BLOCKSIZE / 2, this.REPLICATION, 0L);
        this.dfs.setQuota(dir, 0x7FFFFFFFFFFFFFFEL, 1L);
        long spaceUsed = this.getSpaceConsumed(dir).getStorageSpace();
        Assert.assertEquals((long)spaceUsed, (long)this.getSpaceConsumed(dir).getTypeSpace(StorageType.DB));
        try {
            this.dfs.truncate(file, (long)(this.BLOCKSIZE / 2 - 1));
            Assert.fail((String)"truncate didn't fail");
        }
        catch (RemoteException e) {
            Assert.assertTrue((boolean)e.getClassName().contains("DSQuotaExceededException"));
        }
        INodeFile inode = this.getINodeFile(file);
        Assert.assertNotNull((Object)inode);
        Assert.assertFalse((String)"should not be UC", (boolean)inode.isUnderConstruction());
        Assert.assertNull((String)"should not have a lease", (Object)TestLeaseManager.getLeaseByPath(this.cluster.getNamesystem().getLeaseManager(), file.toString()));
        long newSpaceUsed = this.getSpaceConsumed(dir).getStorageSpace();
        Assert.assertEquals((long)spaceUsed, (long)newSpaceUsed);
        Assert.assertEquals((long)spaceUsed, (long)this.getSpaceConsumed(dir).getTypeSpace(StorageType.DB));
        this.dfs.recoverLease(file);
        this.cluster.restartNameNodes();
    }

    private QuotaCounts getSpaceConsumed(Path foo) throws IOException, InterruptedException {
        return this.getSpaceConsumed(foo, true);
    }

    private QuotaCounts getSpaceConsumed(Path foo, boolean checkLastUpdated) throws IOException, InterruptedException {
        DFSTestUtil.waitForQuotaUpdatesToBeApplied();
        ContentSummary c = DFSTestUtil.getContentSummary(this.dfs, foo, checkLastUpdated);
        EnumCounters typeSpaceDeltas = new EnumCounters(StorageType.class);
        for (StorageType type : StorageType.asList()) {
            typeSpaceDeltas.add((Enum)type, c.getTypeConsumed(type));
        }
        return new QuotaCounts.Builder().nameSpace(c.getFileAndDirectoryCount()).storageSpace(c.getSpaceConsumed()).typeSpaces(typeSpaceDeltas).build();
    }

    private INodeFile getINodeFile(Path foo) throws IOException {
        return (INodeFile)TestUtil.getINode(this.cluster.getNameNode(), foo);
    }
}

