/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.TestFileTruncate;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestTruncateQuotaUpdate {
    private static final int BLOCKSIZE = 1024;
    private static final short REPLICATION = 4;
    private static final long DISKQUOTA = 20480L;
    static final long seed = 0L;
    private static final Path dir = new Path("/TestTruncateQuotaUpdate");
    private static final Path file = new Path(dir, "file");
    private MiniDFSCluster cluster;
    private FSDirectory fsdir;
    private DistributedFileSystem dfs;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
        this.cluster.waitActive();
        this.fsdir = this.cluster.getNamesystem().getFSDirectory();
        this.dfs = this.cluster.getFileSystem();
        this.dfs.mkdirs(dir);
        this.dfs.setQuota(dir, 0x7FFFFFFFFFFFFFFEL, 20480L);
        this.dfs.setQuotaByStorageType(dir, StorageType.DISK, 20480L);
        this.dfs.setStoragePolicy(dir, "HOT");
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testTruncateQuotaUpdate() throws Exception {
    }

    private void testTruncate(long newLength, long expectedDiff, long expectedUsage) throws Exception {
        INodesInPath iip = this.fsdir.getINodesInPath4Write(file.toString());
        INodeFile fileNode = iip.getLastINode().asFile();
        long diff = fileNode.computeQuotaDeltaForTruncate(newLength);
        Assert.assertEquals((long)expectedDiff, (long)diff);
        this.dfs.truncate(file, newLength);
        TestFileTruncate.checkBlockRecovery(file, this.dfs);
        INodeDirectory dirNode = this.fsdir.getINode4Write(dir.toString()).asDirectory();
        long spaceUsed = dirNode.getDirectoryWithQuotaFeature().getSpaceConsumed().getStorageSpace();
        long diskUsed = dirNode.getDirectoryWithQuotaFeature().getSpaceConsumed().getTypeSpaces().get((Enum)StorageType.DISK);
        Assert.assertEquals((long)expectedUsage, (long)spaceUsed);
        Assert.assertEquals((long)expectedUsage, (long)diskUsed);
    }

    private void testTruncateQuotaUpdate(TruncateCase t) throws Exception {
        t.prepare();
        t.run();
    }

    @Ignore
    @Test
    public void testQuotaNoSnapshot() throws Exception {
        this.testTruncateQuotaUpdate(new TruncateWithoutSnapshot());
    }

    @Ignore
    @Test
    public void testQuotaWithSnapshot() throws Exception {
        this.testTruncateQuotaUpdate(new TruncateWithSnapshot());
    }

    @Ignore
    @Test
    public void testQuotaWithSnapshot2() throws Exception {
        this.testTruncateQuotaUpdate(new TruncateWithSnapshot2());
    }

    private class TruncateWithSnapshot2
    implements TruncateCase {
        private TruncateWithSnapshot2() {
        }

        @Override
        public void prepare() throws Exception {
            DFSTestUtil.createFile((FileSystem)TestTruncateQuotaUpdate.this.dfs, file, 2560L, (short)4, 0L);
            TestTruncateQuotaUpdate.this.dfs.truncate(file, 1536L);
            TestFileTruncate.checkBlockRecovery(file, TestTruncateQuotaUpdate.this.dfs);
            DFSTestUtil.appendFile((FileSystem)TestTruncateQuotaUpdate.this.dfs, file, 1024);
        }

        @Override
        public void run() throws Exception {
            long newLength = 2048L;
            long diff = -512L;
            long usage = 14336L;
            TestTruncateQuotaUpdate.this.testTruncate(newLength, diff, usage);
            newLength = 1536L;
            diff = 0L;
            usage = 12288L;
            TestTruncateQuotaUpdate.this.testTruncate(newLength, diff, usage);
            TestTruncateQuotaUpdate.this.testTruncate(0L, -512L, 10240L);
        }
    }

    private class TruncateWithSnapshot
    implements TruncateCase {
        private TruncateWithSnapshot() {
        }

        @Override
        public void prepare() throws Exception {
            DFSTestUtil.createFile((FileSystem)TestTruncateQuotaUpdate.this.dfs, file, 2560L, (short)4, 0L);
        }

        @Override
        public void run() throws Exception {
            long newLength = 1536L;
            long diff = 1024L;
            long usage = 12288L;
            TestTruncateQuotaUpdate.this.testTruncate(newLength, diff, usage);
            newLength = 1024L;
            diff = -512L;
            usage = 10240L;
            TestTruncateQuotaUpdate.this.testTruncate(newLength, diff, usage);
            TestTruncateQuotaUpdate.this.testTruncate(0L, 0L, usage);
        }
    }

    private class TruncateWithoutSnapshot
    implements TruncateCase {
        private TruncateWithoutSnapshot() {
        }

        @Override
        public void prepare() throws Exception {
            DFSTestUtil.createFile((FileSystem)TestTruncateQuotaUpdate.this.dfs, file, 2560L, (short)4, 0L);
        }

        @Override
        public void run() throws Exception {
            long newLength = 1536L;
            long diff = -512L;
            long usage = 6144L;
            TestTruncateQuotaUpdate.this.testTruncate(newLength, diff, usage);
            newLength = 1024L;
            diff = -512L;
            usage = 4096L;
            TestTruncateQuotaUpdate.this.testTruncate(newLength, diff, usage);
            TestTruncateQuotaUpdate.this.testTruncate(0L, -1024L, 0L);
        }
    }

    public static interface TruncateCase {
        public void prepare() throws Exception;

        public void run() throws Exception;
    }
}

