/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.ha.HopsRandomStickyFailoverProxyProvider;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestHopsDFSClientFailover {
    public static final Log LOG = LogFactory.getLog(TestHopsDFSClientFailover.class);

    private static void initLoggers() {
        ((Log4JLogger)HopsRandomStickyFailoverProxyProvider.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LOG).getLogger().setLevel(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHopsRandomStickyFailoverProxyProvider() throws Exception {
        TestHopsDFSClientFailover.initLoggers();
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("ipc.client.connect.max.retries.on.timeouts", 0);
        conf.setInt("ipc.client.connect.max.retries", 0);
        conf.set("dfs.client.retry.policy.spec", "1000,2");
        long leadercheckInterval = conf.getInt("dfs.leader.check.interval", 2000);
        int missedHeartBeatThreshold = conf.getInt("dfs.leader.missed.hb", 2);
        long delay = leadercheckInterval * (long)(missedHeartBeatThreshold + 1) + 3000L;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem(0);
            fs.mkdirs(new Path("/test"));
            LOG.debug((Object)("Killing namenode " + cluster.getNameNode(0).getNameNodeAddress()));
            cluster.shutdownNameNode(0);
            fs.mkdirs(new Path("/test2"));
            cluster.restartNameNode(0, true);
            LOG.debug((Object)("Restarting namenode " + cluster.getNameNode(0).getNameNodeAddress()));
            LOG.debug((Object)("Killing namenode " + cluster.getNameNode(1).getNameNodeAddress()));
            cluster.shutdownNameNode(1);
            fs.mkdirs(new Path("/test3"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("No exception expected " + e));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHopsLeaderFailoverProxyProvider() throws Exception {
        MiniDFSCluster cluster = null;
        int numNN = 4;
        HdfsConfiguration conf = new HdfsConfiguration();
        long leadercheckInterval = conf.getInt("dfs.leader.check.interval", 2000);
        int missedHeartBeatThreshold = conf.getInt("dfs.leader.missed.hb", 2);
        long delay = leadercheckInterval * (long)(missedHeartBeatThreshold + 1) + 3000L;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(4)).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem(0);
            fs.mkdirs(new Path("/test/test1"));
            fs.mkdirs(new Path("/test/test2"));
            fs.mkdirs(new Path("/test/test3"));
            fs.mkdirs(new Path("/test/test4"));
            fs.delete(new Path("/test/test1"), true);
            for (int i = 0; i < 4; ++i) {
                if (!cluster.getNameNode(i).isLeader()) continue;
                cluster.getNameNode(i).getLeaderElectionInstance().relinquishCurrentIdInNextRound();
            }
            Thread.sleep(delay);
            fs.delete(new Path("/test/test2"), true);
        }
        catch (Exception e) {
            Assert.fail((String)("No exception expected " + e));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

