/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.ha.HopsLeaderFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HopsRandomStickyFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.DefaultFailoverProxyProvider;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.LossyRetryInvocationHandler;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RefreshCallQueueProtocol;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolClientSideTranslatorPB;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolPB;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolClientSideTranslatorPB;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolClientSideTranslatorPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolPB;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolClientSideTranslatorPB;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolPB;

@InterfaceAudience.Private
public class NameNodeProxies {
    private static final Log LOG = LogFactory.getLog(NameNodeProxies.class);

    public static <T> ProxyAndInfo<T> createProxy(Configuration conf, URI nameNodeUri, Class<T> xface) throws IOException {
        return NameNodeProxies.createProxy(conf, nameNodeUri, xface, null);
    }

    public static <T> ProxyAndInfo<T> createProxy(Configuration conf, URI nameNodeUri, Class<T> xface, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        Class<FailoverProxyProvider<T>> failoverProxyProviderClass = NameNodeProxies.getFailoverProxyProviderClass(conf, nameNodeUri, xface);
        if (failoverProxyProviderClass == null) {
            return NameNodeProxies.createNonHAProxy(conf, NameNode.getAddress(nameNodeUri), xface, UserGroupInformation.getCurrentUser(), true, fallbackToSimpleAuth);
        }
        FailoverProxyProvider<T> failoverProxyProvider = NameNodeProxies.createFailoverProxyProvider(conf, failoverProxyProviderClass, xface, nameNodeUri, fallbackToSimpleAuth);
        DfsClientConf config = new DfsClientConf(conf);
        Object proxy = RetryProxy.create(xface, failoverProxyProvider, (RetryPolicy)RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)config.getMaxFailoverAttempts(), (int)config.getMaxRetryAttempts(), (long)config.getFailoverSleepBaseMillis(), (long)config.getFailoverSleepMaxMillis()));
        Text dtService = HAUtilClient.buildTokenServiceForLogicalUri((URI)nameNodeUri, (String)"hdfs");
        return new ProxyAndInfo<Object>(proxy, dtService);
    }

    public static <T> ProxyAndInfo<T> createProxyWithLossyRetryHandler(Configuration config, URI nameNodeUri, Class<T> xface, int numResponseToDrop, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        Preconditions.checkArgument((numResponseToDrop > 0 ? 1 : 0) != 0);
        Class<FailoverProxyProvider<T>> failoverProxyProviderClass = NameNodeProxies.getFailoverProxyProviderClass(config, nameNodeUri, xface);
        if (failoverProxyProviderClass != null) {
            FailoverProxyProvider<T> failoverProxyProvider = NameNodeProxies.createFailoverProxyProvider(config, failoverProxyProviderClass, xface, nameNodeUri, fallbackToSimpleAuth);
            int delay = config.getInt("dfs.client.failover.sleep.base.millis", 500);
            int maxCap = config.getInt("dfs.client.failover.sleep.max.millis", 15000);
            int maxFailoverAttempts = config.getInt("dfs.client.failover.max.attempts", 15);
            int maxRetryAttempts = config.getInt("dfs.client.retry.max.attempts", 10);
            LossyRetryInvocationHandler dummyHandler = new LossyRetryInvocationHandler(numResponseToDrop, failoverProxyProvider, RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)maxFailoverAttempts, (int)Math.max(numResponseToDrop + 1, maxRetryAttempts), (long)delay, (long)maxCap));
            Object proxy = Proxy.newProxyInstance(failoverProxyProvider.getInterface().getClassLoader(), new Class[]{xface}, (InvocationHandler)dummyHandler);
            Text dtService = HAUtilClient.buildTokenServiceForLogicalUri((URI)nameNodeUri, (String)"hdfs");
            return new ProxyAndInfo<Object>(proxy, dtService);
        }
        LOG.warn((Object)"Currently creating proxy using LossyRetryInvocationHandler requires NN HA setup");
        return null;
    }

    public static <T> ProxyAndInfo<T> createNonHAProxy(Configuration conf, InetSocketAddress nnAddr, Class<T> xface, UserGroupInformation ugi, boolean withRetries) throws IOException {
        return NameNodeProxies.createNonHAProxy(conf, nnAddr, xface, ugi, withRetries, null);
    }

    public static <T> ProxyAndInfo<T> createNonHAProxy(Configuration conf, InetSocketAddress nnAddr, Class<T> xface, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        Object proxy;
        Text dtService = SecurityUtil.buildTokenService((InetSocketAddress)nnAddr);
        if (xface == ClientProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithClientProtocol(nnAddr, conf, ugi, withRetries, fallbackToSimpleAuth);
        } else if (xface == NamenodeProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithNamenodeProtocol(nnAddr, conf, ugi, withRetries);
        } else if (xface == GetUserMappingsProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithGetUserMappingsProtocol(nnAddr, conf, ugi);
        } else if (xface == RefreshUserMappingsProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithRefreshUserMappingsProtocol(nnAddr, conf, ugi);
        } else if (xface == RefreshAuthorizationPolicyProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithRefreshAuthorizationPolicyProtocol(nnAddr, conf, ugi);
        } else if (xface == RefreshCallQueueProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithRefreshCallQueueProtocol(nnAddr, conf, ugi);
        } else {
            String message = "Unsupported protocol found when creating the proxy connection to NameNode: " + (xface != null ? xface.getClass().getName() : "null");
            LOG.error((Object)message);
            throw new IllegalStateException(message);
        }
        return new ProxyAndInfo<Object>(proxy, dtService);
    }

    private static RefreshAuthorizationPolicyProtocol createNNProxyWithRefreshAuthorizationPolicyProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi) throws IOException {
        RefreshAuthorizationPolicyProtocolPB proxy = (RefreshAuthorizationPolicyProtocolPB)NameNodeProxies.createNameNodeProxy(address, conf, ugi, RefreshAuthorizationPolicyProtocolPB.class);
        return new RefreshAuthorizationPolicyProtocolClientSideTranslatorPB(proxy);
    }

    private static RefreshUserMappingsProtocol createNNProxyWithRefreshUserMappingsProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi) throws IOException {
        RefreshUserMappingsProtocolPB proxy = (RefreshUserMappingsProtocolPB)NameNodeProxies.createNameNodeProxy(address, conf, ugi, RefreshUserMappingsProtocolPB.class);
        return new RefreshUserMappingsProtocolClientSideTranslatorPB(proxy);
    }

    private static RefreshCallQueueProtocol createNNProxyWithRefreshCallQueueProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi) throws IOException {
        RefreshCallQueueProtocolPB proxy = (RefreshCallQueueProtocolPB)NameNodeProxies.createNameNodeProxy(address, conf, ugi, RefreshCallQueueProtocolPB.class);
        return new RefreshCallQueueProtocolClientSideTranslatorPB(proxy);
    }

    private static GetUserMappingsProtocol createNNProxyWithGetUserMappingsProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi) throws IOException {
        GetUserMappingsProtocolPB proxy = (GetUserMappingsProtocolPB)NameNodeProxies.createNameNodeProxy(address, conf, ugi, GetUserMappingsProtocolPB.class);
        return new GetUserMappingsProtocolClientSideTranslatorPB(proxy);
    }

    private static NamenodeProtocol createNNProxyWithNamenodeProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, boolean withRetries) throws IOException {
        NamenodeProtocolPB proxy = (NamenodeProtocolPB)NameNodeProxies.createNameNodeProxy(address, conf, ugi, NamenodeProtocolPB.class);
        if (withRetries) {
            RetryPolicy timeoutPolicy = RetryPolicies.exponentialBackoffRetry((int)5, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
            HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
            methodNameToPolicyMap.put("getBlocks", timeoutPolicy);
            methodNameToPolicyMap.put("getAccessKeys", timeoutPolicy);
            NamenodeProtocolTranslatorPB translatorProxy = new NamenodeProtocolTranslatorPB(proxy);
            return (NamenodeProtocol)RetryProxy.create(NamenodeProtocol.class, (Object)translatorProxy, methodNameToPolicyMap);
        }
        return new NamenodeProtocolTranslatorPB(proxy);
    }

    private static ClientProtocol createNNProxyWithClientProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine.class);
        RetryPolicy defaultPolicy = RetryUtils.getDefaultRetryPolicy((Configuration)conf, (String)"dfs.client.retry.policy.enabled", (boolean)false, (String)"dfs.client.retry.policy.spec", (String)"10000,6,60000,10", (String)SafeModeException.class.getName());
        long version = RPC.getProtocolVersion(ClientNamenodeProtocolPB.class);
        ClientNamenodeProtocolPB proxy = (ClientNamenodeProtocolPB)RPC.getProtocolProxy(ClientNamenodeProtocolPB.class, (long)version, (InetSocketAddress)address, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getTimeout((Configuration)conf), (RetryPolicy)defaultPolicy, (AtomicBoolean)fallbackToSimpleAuth).getProxy();
        if (withRetries) {
            RetryPolicy createPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)5, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
            HashMap<Class<AlreadyBeingCreatedException>, RetryPolicy> remoteExceptionToPolicyMap = new HashMap<Class<AlreadyBeingCreatedException>, RetryPolicy>();
            remoteExceptionToPolicyMap.put(AlreadyBeingCreatedException.class, createPolicy);
            RetryPolicy methodPolicy = RetryPolicies.retryByRemoteException((RetryPolicy)defaultPolicy, remoteExceptionToPolicyMap);
            HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
            methodNameToPolicyMap.put("create", methodPolicy);
            ClientNamenodeProtocolTranslatorPB translatorProxy = new ClientNamenodeProtocolTranslatorPB(proxy);
            return (ClientProtocol)RetryProxy.create(ClientProtocol.class, (FailoverProxyProvider)new DefaultFailoverProxyProvider(ClientProtocol.class, (Object)translatorProxy), methodNameToPolicyMap, (RetryPolicy)defaultPolicy);
        }
        return new ClientNamenodeProtocolTranslatorPB(proxy);
    }

    private static Object createNameNodeProxy(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, Class<?> xface) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, xface, ProtobufRpcEngine.class);
        Object proxy = RPC.getProxy(xface, (long)RPC.getProtocolVersion(xface), (InetSocketAddress)address, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf));
        return proxy;
    }

    @VisibleForTesting
    public static <T> Class<FailoverProxyProvider<T>> getFailoverProxyProviderClass(Configuration conf, URI nameNodeUri, Class<T> xface) throws IOException {
        if (nameNodeUri == null) {
            return null;
        }
        String host = nameNodeUri.getHost();
        String configKey = "dfs.client.failover.proxy.provider." + host;
        try {
            int port;
            Class ret = conf.getClass(configKey, null, FailoverProxyProvider.class);
            if (ret != null && (port = nameNodeUri.getPort()) > 0 && port != 8020) {
                throw new IOException("Port " + port + " specified in URI " + nameNodeUri + " but host '" + host + "' is a logical (HA) namenode and does not use port information.");
            }
            return ret;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw new IOException("Could not load failover proxy provider class " + conf.get(configKey) + " which is configured for authority " + nameNodeUri, e);
            }
            throw e;
        }
    }

    @VisibleForTesting
    public static <T> FailoverProxyProvider<T> createFailoverProxyProvider(Configuration conf, Class<FailoverProxyProvider<T>> failoverProxyProviderClass, Class<T> xface, URI nameNodeUri, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        Preconditions.checkArgument((boolean)xface.isAssignableFrom(NamenodeProtocols.class), (String)"Interface %s is not a NameNode protocol", xface);
        try {
            Constructor<FailoverProxyProvider<T>> ctor = failoverProxyProviderClass.getConstructor(Configuration.class, URI.class, Class.class);
            FailoverProxyProvider<T> provider = ctor.newInstance(conf, nameNodeUri, xface);
            return provider;
        }
        catch (Exception e) {
            String message = "Couldn't create proxy provider " + failoverProxyProviderClass;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message, (Throwable)e);
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException && e.getCause().getCause() instanceof IOException) {
                throw (IOException)e.getCause().getCause();
            }
            throw new IOException(message, e);
        }
    }

    public static <T> ProxyAndInfo<T> createHopsRandomStickyProxy(Configuration conf, URI nameNodeUri, Class<T> xface, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        String failoverProxyProviderClassStr = "org.apache.hadoop.hdfs.server.namenode.ha.HopsRandomStickyFailoverProxyProvider";
        Class failoverProxyProviderClass = conf.getClass(failoverProxyProviderClassStr, HopsRandomStickyFailoverProxyProvider.class, FailoverProxyProvider.class);
        FailoverProxyProvider<T> failoverProxyProvider = NameNodeProxies.createFailoverProxyProvider(conf, failoverProxyProviderClass, xface, nameNodeUri, fallbackToSimpleAuth);
        DfsClientConf config = new DfsClientConf(conf);
        RetryPolicy defaultPolicy = RetryUtils.getDefaultRetryPolicy((Configuration)conf, (String)"dfs.client.retry.policy.enabled", (boolean)false, (String)"dfs.client.retry.policy.spec", (String)"10000,6,60000,10", (String)"org.apache.hadoop.hdfs.server.namenode.SafeModeException");
        HashMap<Class<SafeModeException>, RetryPolicy> remoteExceptionToPolicyMap = new HashMap<Class<SafeModeException>, RetryPolicy>();
        remoteExceptionToPolicyMap.put(SafeModeException.class, defaultPolicy);
        Object proxy = RetryProxy.create(xface, failoverProxyProvider, (RetryPolicy)RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)config.getMaxFailoverAttempts(), (int)config.getMaxRetryAttempts(), (long)config.getFailoverSleepBaseMillis(), (long)config.getFailoverSleepMaxMillis(), remoteExceptionToPolicyMap));
        Text dtService = HAUtilClient.buildTokenServiceForLogicalUri((URI)nameNodeUri, (String)"hdfs");
        return new ProxyAndInfo<Object>(proxy, dtService);
    }

    public static <T> ProxyAndInfo<T> createHopsLeaderProxy(Configuration conf, URI nameNodeUri, Class<T> xface, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        String failoverProxyProviderClassStr = "org.apache.hadoop.hdfs.server.namenode.ha.HopsLeaderFailoverProxyProvider";
        Class failoverProxyProviderClass = conf.getClass(failoverProxyProviderClassStr, HopsLeaderFailoverProxyProvider.class, FailoverProxyProvider.class);
        FailoverProxyProvider<T> failoverProxyProvider = NameNodeProxies.createFailoverProxyProvider(conf, failoverProxyProviderClass, xface, nameNodeUri, fallbackToSimpleAuth);
        DfsClientConf config = new DfsClientConf(conf);
        RetryPolicy defaultPolicy = RetryUtils.getDefaultRetryPolicy((Configuration)conf, (String)"dfs.client.retry.policy.enabled", (boolean)false, (String)"dfs.client.retry.policy.spec", (String)"10000,6,60000,10", (String)"org.apache.hadoop.hdfs.server.namenode.SafeModeException");
        HashMap<Class<SafeModeException>, RetryPolicy> remoteExceptionToPolicyMap = new HashMap<Class<SafeModeException>, RetryPolicy>();
        remoteExceptionToPolicyMap.put(SafeModeException.class, defaultPolicy);
        Object proxy = RetryProxy.create(xface, failoverProxyProvider, (RetryPolicy)RetryPolicies.failoverOnLeaderChange((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)config.getMaxFailoverAttempts(), (int)config.getMaxRetryAttempts(), (long)config.getFailoverSleepBaseMillis(), (long)config.getFailoverSleepMaxMillis(), remoteExceptionToPolicyMap));
        Text dtService = HAUtilClient.buildTokenServiceForLogicalUri((URI)nameNodeUri, (String)"hdfs");
        return new ProxyAndInfo<Object>(proxy, dtService);
    }

    public static class ProxyAndInfo<PROXYTYPE> {
        private final PROXYTYPE proxy;
        private final Text dtService;

        public ProxyAndInfo(PROXYTYPE proxy, Text dtService) {
            this.proxy = proxy;
            this.dtService = dtService;
        }

        public PROXYTYPE getProxy() {
            return this.proxy;
        }

        public Text getDelegationTokenService() {
            return this.dtService;
        }
    }
}

