/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressView;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class StartupProgressServlet
extends DfsServlet {
    private static final String COUNT = "count";
    private static final String ELAPSED_TIME = "elapsedTime";
    private static final String FILE = "file";
    private static final String NAME = "name";
    private static final String DESC = "desc";
    private static final String PERCENT_COMPLETE = "percentComplete";
    private static final String PHASES = "phases";
    private static final String SIZE = "size";
    private static final String STATUS = "status";
    private static final String STEPS = "steps";
    private static final String TOTAL = "total";
    public static final String PATH_SPEC = "/startupProgress";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json; charset=UTF-8");
        StartupProgress prog = NameNodeHttpServer.getStartupProgressFromContext(this.getServletContext());
        StartupProgressView view = prog.createView();
        JsonGenerator json = new JsonFactory().createJsonGenerator((Writer)resp.getWriter());
        try {
            json.writeStartObject();
            json.writeNumberField(ELAPSED_TIME, view.getElapsedTime());
            json.writeNumberField(PERCENT_COMPLETE, view.getPercentComplete());
            json.writeArrayFieldStart(PHASES);
            for (Phase phase : view.getPhases()) {
                json.writeStartObject();
                json.writeStringField(NAME, phase.getName());
                json.writeStringField(DESC, phase.getDescription());
                json.writeStringField(STATUS, view.getStatus(phase).toString());
                json.writeNumberField(PERCENT_COMPLETE, view.getPercentComplete(phase));
                json.writeNumberField(ELAPSED_TIME, view.getElapsedTime(phase));
                StartupProgressServlet.writeStringFieldIfNotNull(json, FILE, view.getFile(phase));
                StartupProgressServlet.writeNumberFieldIfDefined(json, SIZE, view.getSize(phase));
                json.writeArrayFieldStart(STEPS);
                for (Step step : view.getSteps(phase)) {
                    json.writeStartObject();
                    StepType type = step.getType();
                    if (type != null) {
                        json.writeStringField(NAME, type.getName());
                        json.writeStringField(DESC, type.getDescription());
                    }
                    json.writeNumberField(COUNT, view.getCount(phase, step));
                    StartupProgressServlet.writeStringFieldIfNotNull(json, FILE, step.getFile());
                    StartupProgressServlet.writeNumberFieldIfDefined(json, SIZE, step.getSize());
                    json.writeNumberField(TOTAL, view.getTotal(phase, step));
                    json.writeNumberField(PERCENT_COMPLETE, view.getPercentComplete(phase, step));
                    json.writeNumberField(ELAPSED_TIME, view.getElapsedTime(phase, step));
                    json.writeEndObject();
                }
                json.writeEndArray();
                json.writeEndObject();
            }
            json.writeEndArray();
            json.writeEndObject();
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{json});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{json});
    }

    private static void writeNumberFieldIfDefined(JsonGenerator json, String key, long value) throws IOException {
        if (value != Long.MIN_VALUE) {
            json.writeNumberField(key, value);
        }
    }

    private static void writeStringFieldIfNotNull(JsonGenerator json, String key, String value) throws IOException {
        if (value != null) {
            json.writeStringField(key, value);
        }
    }
}

