/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;

public class DFSClientAdapter {
    public static DFSClient getDFSClient(DistributedFileSystem dfs) {
        return dfs.dfs;
    }

    public static void setDFSClient(DistributedFileSystem dfs, DFSClient client) {
        dfs.dfs = client;
    }

    public static void stopLeaseRenewer(DistributedFileSystem dfs) throws IOException {
        try {
            dfs.dfs.getLeaseRenewer().interruptAndJoin();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static LocatedBlocks callGetBlockLocations(ClientProtocol namenode, String src, long start, long length) throws IOException {
        return DFSClient.callGetBlockLocations((ClientProtocol)namenode, (String)src, (long)start, (long)length);
    }

    public static ClientProtocol getNamenode(DFSClient client) throws IOException {
        return client.getNamenode();
    }

    public static DFSClient getClient(DistributedFileSystem dfs) throws IOException {
        return dfs.dfs;
    }

    public static ExtendedBlock getPreviousBlock(DFSClient client, long file) {
        return client.getPreviousBlock(file);
    }

    public static long getFileId(DFSOutputStream out) {
        return out.getFileId();
    }

    public static DistributedFileSystem newDistributedFileSystem(Configuration conf, ClientProtocol namenode, Collection<ClientProtocol> allNamenodes) throws IOException {
        DistributedFileSystem dfs = new DistributedFileSystem();
        dfs.dfs = new DFSClient(null, namenode, conf, null);
        dfs.dfs.setNamenodes(allNamenodes);
        return dfs;
    }
}

