/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.hops.exception.StorageException;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DecommissionManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDecommission {
    public static final Logger LOG = LoggerFactory.getLogger(TestDecommission.class);
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int fileSize = 16384;
    static final int HEARTBEAT_INTERVAL = 1;
    static final int BLOCKREPORT_INTERVAL_MSEC = 1000;
    static final int NAMENODE_REPLICATION_INTERVAL = 1;
    final Random myrand = new Random();
    Path dir;
    Path hostsFile;
    Path excludeFile;
    FileSystem localFileSys;
    Configuration conf;
    MiniDFSCluster cluster = null;

    @Before
    public void setup() throws IOException {
        this.conf = new HdfsConfiguration();
        this.localFileSys = FileSystem.getLocal((Configuration)this.conf);
        Path workingDir = this.localFileSys.getWorkingDirectory();
        this.dir = new Path(workingDir, PathUtils.getTestDirName(this.getClass()) + "/work-dir/decommission");
        this.hostsFile = new Path(this.dir, "hosts");
        this.excludeFile = new Path(this.dir, "exclude");
        this.conf.setBoolean("dfs.namenode.replication.considerLoad", false);
        this.conf.set("dfs.hosts", this.hostsFile.toUri().getPath());
        this.conf.set("dfs.hosts.exclude", this.excludeFile.toUri().getPath());
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 2000);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.namenode.replication.interval", 1);
        this.conf.setInt("dfs.blockreport.intervalMsec", 1000);
        this.conf.setInt("dfs.namenode.replication.pending.timeout-sec", 4);
        this.conf.setInt("dfs.namenode.replication.interval", 1);
        this.conf.setInt("dfs.block.fetcher.buckets.per.thread", 1000);
        this.writeConfigFile(this.hostsFile, null);
        this.writeConfigFile(this.excludeFile, null);
    }

    @After
    public void teardown() throws IOException {
        this.cleanupFile(this.localFileSys, this.dir);
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private void writeConfigFile(Path name, List<String> nodes) throws IOException {
        if (this.localFileSys.exists(name)) {
            this.localFileSys.delete(name, true);
        }
        FSDataOutputStream stm = this.localFileSys.create(name);
        if (nodes != null) {
            for (String node : nodes) {
                stm.writeBytes(node);
                stm.writeBytes("\n");
            }
        }
        stm.close();
    }

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L);
        byte[] buffer = new byte[16384];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        LOG.info("Created file " + name + " with " + repl + " replicas.");
    }

    private static String checkFile(FileSystem fileSys, Path name, int repl, String downnode, int numDatanodes) throws IOException {
        boolean isNodeDown = downnode != null;
        Assert.assertTrue((String)("Not HDFS:" + fileSys.getUri()), (boolean)(fileSys instanceof DistributedFileSystem));
        HdfsDataInputStream dis = (HdfsDataInputStream)fileSys.open(name);
        List dinfo = dis.getAllBlocks();
        for (LocatedBlock blk : dinfo) {
            int hasdown = 0;
            DatanodeInfo[] nodes = blk.getLocations();
            for (int j = 0; j < nodes.length; ++j) {
                if (isNodeDown && nodes[j].getXferAddr().equals(downnode)) {
                    ++hasdown;
                    if (!nodes[j].isDecommissioned()) {
                        return "For block " + blk.getBlock() + " replica on " + nodes[j] + " is given as downnode, but is not decommissioned";
                    }
                    if (j != nodes.length - 1) {
                        return "For block " + blk.getBlock() + " decommissioned node " + nodes[j] + " was not last node in list: " + (j + 1) + " of " + nodes.length;
                    }
                    LOG.info("Block " + blk.getBlock() + " replica on " + nodes[j] + " is decommissioned.");
                    continue;
                }
                if (!nodes[j].isDecommissioned()) continue;
                return "For block " + blk.getBlock() + " replica on " + nodes[j] + " is unexpectedly decommissioned";
            }
            LOG.info("Block " + blk.getBlock() + " has " + hasdown + " decommissioned replica.");
            if (Math.min(numDatanodes, repl + hasdown) == nodes.length) continue;
            return "Wrong number of replicas for block " + blk.getBlock() + ": " + nodes.length + ", expected " + Math.min(numDatanodes, repl + hasdown);
        }
        return null;
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assert.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    private DatanodeInfo decommissionNode(int nnIndex, String datanodeUuid, ArrayList<DatanodeInfo> decommissionedNodes, DatanodeInfo.AdminStates waitForState) throws IOException {
        int index;
        DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(nnIndex), this.conf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        if (datanodeUuid == null) {
            boolean found = false;
            while (!found) {
                index = this.myrand.nextInt(info.length);
                if (info[index].isDecommissioned()) continue;
                found = true;
            }
        } else {
            for (index = 0; index < info.length && !info[index].getDatanodeUuid().equals(datanodeUuid); ++index) {
            }
            if (index == info.length) {
                throw new IOException("invalid datanodeUuid " + datanodeUuid);
            }
        }
        String nodename = info[index].getXferAddr();
        LOG.info("Decommissioning node: " + nodename);
        ArrayList<String> nodes = new ArrayList<String>();
        if (decommissionedNodes != null) {
            for (DatanodeInfo dn : decommissionedNodes) {
                nodes.add(dn.getName());
            }
        }
        nodes.add(nodename);
        this.writeConfigFile(this.excludeFile, nodes);
        TestDecommission.refreshNodes(this.cluster.getNamesystem(nnIndex), this.conf);
        DatanodeDescriptor ret = NameNodeAdapter.getDatanode(this.cluster.getNamesystem(nnIndex), (DatanodeID)info[index]);
        this.waitNodeState((DatanodeInfo)ret, waitForState);
        return ret;
    }

    private void recommissionNode(int nnIndex, DatanodeInfo decommissionedNode) throws IOException {
        LOG.info("Recommissioning node: " + decommissionedNode);
        this.writeConfigFile(this.excludeFile, null);
        TestDecommission.refreshNodes(this.cluster.getNamesystem(nnIndex), this.conf);
        this.waitNodeState(decommissionedNode, DatanodeInfo.AdminStates.NORMAL);
    }

    private void waitNodeState(DatanodeInfo node, DatanodeInfo.AdminStates state) {
        boolean done;
        boolean bl = done = state == node.getAdminState();
        while (!done) {
            LOG.info("Waiting for node " + node + " to change state to " + state + " current state: " + node.getAdminState());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            done = state == node.getAdminState();
        }
        LOG.info("node " + node + " reached the state " + state);
    }

    private static DFSClient getDfsClient(NameNode nn, Configuration conf) throws IOException {
        return new DFSClient(nn.getNameNodeAddress(), conf);
    }

    private static void validateCluster(DFSClient client, int numDNs) throws IOException {
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        Assert.assertEquals((String)"Number of Datanodes ", (long)numDNs, (long)info.length);
    }

    private void startCluster(int numNameNodes, int numDatanodes, Configuration conf) throws IOException {
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(numNameNodes)).numDataNodes(numDatanodes).build();
        this.cluster.waitActive();
        for (int i = 0; i < numNameNodes; ++i) {
            DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(i), conf);
            TestDecommission.validateCluster(client, numDatanodes);
        }
        DFSTestUtil.createRootFolder();
    }

    static void refreshNodes(FSNamesystem ns, Configuration conf) throws IOException {
        ns.getBlockManager().getDatanodeManager().refreshNodes(conf);
    }

    private void verifyStats(NameNode namenode, FSNamesystem fsn, DatanodeInfo info, DataNode node, boolean decommissioning) throws InterruptedException, IOException {
        for (int i = 0; i < 10; ++i) {
            long[] newStats = namenode.getRpcServer().getStats();
            Assert.assertEquals((long)newStats[0], (long)(decommissioning ? info.getDfsUsed() : info.getCapacity()));
            Assert.assertEquals((long)newStats[1], (long)info.getDfsUsed());
            Assert.assertEquals((long)newStats[2], (long)(decommissioning ? 0L : info.getRemaining()));
            Assert.assertEquals((long)fsn.getTotalLoad(), (long)info.getXceiverCount());
            DataNodeTestUtils.triggerHeartbeat(node);
        }
    }

    @Test(timeout=360000L)
    public void testDecommission() throws IOException {
        this.testDecommission(1, 6);
    }

    @Test(timeout=360000L)
    public void testDecommission2() throws IOException {
        LOG.info("Starting test testDecommission");
        int numNamenodes = 1;
        int numDatanodes = 4;
        this.conf.setInt("dfs.replication", 3);
        this.startCluster(numNamenodes, numDatanodes, this.conf);
        ArrayList namenodeDecomList = new ArrayList(numNamenodes);
        namenodeDecomList.add(0, new ArrayList(numDatanodes));
        Path file1 = new Path("testDecommission2.dat");
        int replicas = 4;
        ArrayList decommissionedNodes = (ArrayList)namenodeDecomList.get(0);
        DistributedFileSystem fileSys = this.cluster.getFileSystem(0);
        FSNamesystem ns = this.cluster.getNamesystem(0);
        this.writeFile((FileSystem)fileSys, file1, replicas);
        int deadDecomissioned = ns.getNumDecomDeadDataNodes();
        int liveDecomissioned = ns.getNumDecomLiveDataNodes();
        DatanodeInfo decomNode = this.decommissionNode(0, null, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
        decommissionedNodes.add(decomNode);
        Assert.assertEquals((long)deadDecomissioned, (long)ns.getNumDecomDeadDataNodes());
        Assert.assertEquals((long)(liveDecomissioned + 1), (long)ns.getNumDecomLiveDataNodes());
        DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(0), this.conf);
        Assert.assertEquals((String)"All datanodes must be alive", (long)numDatanodes, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        Assert.assertNull((Object)TestDecommission.checkFile((FileSystem)fileSys, file1, replicas, decomNode.getXferAddr(), numDatanodes));
        this.cleanupFile((FileSystem)fileSys, file1);
        this.cluster.shutdown();
        this.startCluster(1, 4, this.conf);
        this.cluster.shutdown();
    }

    @Ignore
    public void testDecommissionFederation() throws IOException {
        this.testDecommission(2, 2);
    }

    private void testDecommission(int numNamenodes, int numDatanodes) throws IOException {
        LOG.info("Starting test testDecommission");
        this.startCluster(numNamenodes, numDatanodes, this.conf);
        DFSTestUtil.createRootFolder();
        ArrayList namenodeDecomList = new ArrayList(numNamenodes);
        for (int i = 0; i < numNamenodes; ++i) {
            namenodeDecomList.add(i, new ArrayList(numDatanodes));
        }
        Path file1 = new Path("testDecommission.dat");
        for (int iteration = 0; iteration < numDatanodes - 1; ++iteration) {
            int replicas = numDatanodes - iteration - 1;
            for (int i = 0; i < numNamenodes; ++i) {
                ArrayList decommissionedNodes = (ArrayList)namenodeDecomList.get(i);
                DistributedFileSystem fileSys = this.cluster.getFileSystem(i);
                FSNamesystem ns = this.cluster.getNamesystem(i);
                this.writeFile((FileSystem)fileSys, file1, replicas);
                int deadDecomissioned = ns.getNumDecomDeadDataNodes();
                int liveDecomissioned = ns.getNumDecomLiveDataNodes();
                DatanodeInfo decomNode = this.decommissionNode(i, null, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
                decommissionedNodes.add(decomNode);
                Assert.assertEquals((long)deadDecomissioned, (long)ns.getNumDecomDeadDataNodes());
                Assert.assertEquals((long)(liveDecomissioned + 1), (long)ns.getNumDecomLiveDataNodes());
                DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(i), this.conf);
                Assert.assertEquals((String)"All datanodes must be alive", (long)numDatanodes, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
                int tries = 0;
                while (tries++ < 20) {
                    try {
                        Thread.sleep(1000L);
                        if (TestDecommission.checkFile((FileSystem)fileSys, file1, replicas, decomNode.getXferAddr(), numDatanodes) != null) continue;
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                Assert.assertTrue((String)("Checked if block was replicated after decommission, tried " + tries + " times."), (tries < 20 ? 1 : 0) != 0);
                this.cleanupFile((FileSystem)fileSys, file1);
            }
        }
        this.cluster.shutdown();
        this.startCluster(numNamenodes, numDatanodes, this.conf);
        this.cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testRecommission() throws Exception {
        int numDatanodes = 6;
        try {
            LOG.info("Starting test testRecommission");
            this.startCluster(1, 6, this.conf);
            Path file1 = new Path("testDecommission.dat");
            int replicas = 5;
            ArrayList decommissionedNodes = Lists.newArrayList();
            DistributedFileSystem fileSys = this.cluster.getFileSystem();
            this.writeFile((FileSystem)fileSys, file1, 5);
            BlockLocation loc = fileSys.getFileBlockLocations(file1, 0L, 1L)[0];
            Assert.assertEquals((String)"Unexpected number of replicas from getFileBlockLocations", (long)5L, (long)loc.getHosts().length);
            String toDecomHost = loc.getNames()[0];
            String toDecomUuid = null;
            for (DataNode d : this.cluster.getDataNodes()) {
                if (!d.getDatanodeId().getXferAddr().equals(toDecomHost)) continue;
                toDecomUuid = d.getDatanodeId().getDatanodeUuid();
                break;
            }
            Assert.assertNotNull((String)"Could not find a dn with the block!", toDecomUuid);
            DatanodeInfo decomNode = this.decommissionNode(0, toDecomUuid, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
            decommissionedNodes.add(decomNode);
            final BlockManager blockManager = this.cluster.getNamesystem().getBlockManager();
            final DatanodeManager datanodeManager = blockManager.getDatanodeManager();
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(), this.conf);
            Assert.assertEquals((String)"All datanodes must be alive", (long)6L, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
            final FileStatus fileStatus = fileSys.getFileStatus(file1);
            final ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fileSys, file1);
            final String uuid = toDecomUuid;
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    try {
                        HopsTransactionalRequestHandler verifyFileBlocksHandler = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

                            public void acquireLock(TransactionLocks locks) throws IOException {
                                LockFactory lf = LockFactory.getInstance();
                                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, new String[]{fileStatus.getPath().toUri().getPath()}).setNameNodeID(TestDecommission.this.cluster.getNameNode().getId()).setActiveNameNodes((Collection)TestDecommission.this.cluster.getNameNode().getActiveNameNodes().getActiveNodes());
                                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UR}));
                            }

                            public Object performTask() throws StorageException, IOException {
                                BlockInfoContiguous info = blockManager.getStoredBlock(b.getLocalBlock());
                                int count = 0;
                                StringBuilder sb = new StringBuilder("Replica locations: ");
                                for (int i = 0; i < info.numNodes(datanodeManager); ++i) {
                                    DatanodeDescriptor dn = info.getDatanode(datanodeManager, i);
                                    sb.append(dn + ", ");
                                    if (dn.getDatanodeUuid().equals(uuid)) continue;
                                    ++count;
                                }
                                LOG.info(sb.toString());
                                LOG.info("Count: " + count);
                                return count == 5;
                            }
                        };
                        return (boolean)((Boolean)verifyFileBlocksHandler.handle());
                    }
                    catch (IOException ex) {
                        java.util.logging.Logger.getLogger(TestDecommission.class.getName()).log(Level.SEVERE, null, ex);
                        return false;
                    }
                }
            }, (int)500, (int)30000);
            this.recommissionNode(0, decomNode);
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
            DFSTestUtil.waitForReplication(this.cluster, b, 1, 5, 0);
            this.cleanupFile((FileSystem)fileSys, file1);
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    @Test(timeout=360000L)
    public void testClusterStats() throws Exception {
        this.testClusterStats(1);
    }

    @Ignore
    public void testClusterStatsFederation() throws Exception {
        this.testClusterStats(3);
    }

    public void testClusterStats(int numNameNodes) throws IOException, InterruptedException {
        LOG.info("Starting test testClusterStats");
        int numDatanodes = 1;
        this.startCluster(numNameNodes, numDatanodes, this.conf);
        for (int i = 0; i < numNameNodes; ++i) {
            DistributedFileSystem fileSys = this.cluster.getFileSystem(i);
            Path file = new Path("testClusterStats.dat");
            this.writeFile((FileSystem)fileSys, file, 1);
            FSNamesystem fsn = this.cluster.getNamesystem(i);
            NameNode namenode = this.cluster.getNameNode(i);
            DatanodeInfo decomInfo = this.decommissionNode(i, null, null, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            DataNode decomNode = this.getDataNode(decomInfo);
            this.verifyStats(namenode, fsn, decomInfo, decomNode, true);
            this.writeConfigFile(this.excludeFile, null);
            TestDecommission.refreshNodes(fsn, this.conf);
            DatanodeDescriptor retInfo = NameNodeAdapter.getDatanode(fsn, (DatanodeID)decomInfo);
            DataNode retNode = this.getDataNode(decomInfo);
            this.waitNodeState((DatanodeInfo)retInfo, DatanodeInfo.AdminStates.NORMAL);
            this.verifyStats(namenode, fsn, (DatanodeInfo)retInfo, retNode, false);
        }
    }

    private DataNode getDataNode(DatanodeInfo decomInfo) {
        DataNode decomNode = null;
        for (DataNode dn : this.cluster.getDataNodes()) {
            if (!decomInfo.equals((Object)dn.getDatanodeId())) continue;
            decomNode = dn;
            break;
        }
        Assert.assertNotNull((String)"Could not find decomNode in cluster!", decomNode);
        return decomNode;
    }

    @Test(timeout=360000L)
    public void testHostsFile() throws IOException, InterruptedException {
        this.testHostsFile(1);
    }

    @Ignore
    public void testHostsFileFederation() throws IOException, InterruptedException {
        this.testHostsFile(3);
    }

    public void testHostsFile(int numNameNodes) throws IOException, InterruptedException {
        int numDatanodes = 1;
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(numNameNodes)).numDataNodes(numDatanodes).setupHostsFile(true).build();
        this.cluster.waitActive();
        ArrayList<String> list = new ArrayList<String>();
        String bogusIp = "127.0.30.1";
        list.add("127.0.30.1");
        this.writeConfigFile(this.hostsFile, list);
        for (int j = 0; j < numNameNodes; ++j) {
            TestDecommission.refreshNodes(this.cluster.getNamesystem(j), this.conf);
            DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(j), this.conf);
            DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            for (int i = 0; i < 5 && info.length != 0; ++i) {
                LOG.info("Waiting for datanode to be marked dead");
                Thread.sleep(1000L);
                info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            }
            Assert.assertEquals((String)"Number of live nodes should be 0", (long)0L, (long)info.length);
            info = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
            Assert.assertEquals((String)"There should be 2 dead nodes", (long)2L, (long)info.length);
            DatanodeID id = this.cluster.getDataNodes().get(0).getDatanodeId();
            Assert.assertEquals((Object)id.getHostName(), (Object)info[0].getHostName());
            Assert.assertEquals((Object)"127.0.30.1", (Object)info[1].getHostName());
        }
    }

    @Test(timeout=120000L)
    public void testDecommissionWithOpenfile() throws IOException, InterruptedException {
        LOG.info("Starting test testDecommissionWithOpenfile");
        this.startCluster(1, 7, this.conf);
        DistributedFileSystem fileSys = this.cluster.getFileSystem(0);
        FSNamesystem ns = this.cluster.getNamesystem(0);
        String openFile = "/testDecommissionWithOpenfile.dat";
        this.writeFile((FileSystem)fileSys, new Path(openFile), 3);
        FSDataOutputStream fdos = fileSys.append(new Path(openFile));
        LocatedBlocks lbs = NameNodeAdapter.getBlockLocations(this.cluster.getNameNode(0), openFile, 0L, 16384L);
        DatanodeInfo[] dnInfos4LastBlock = lbs.getLastLocatedBlock().getLocations();
        DatanodeInfo[] dnInfos4FirstBlock = lbs.get(0).getLocations();
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<DatanodeDescriptor> dnInfos = new ArrayList<DatanodeDescriptor>();
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        DatanodeInfo[] datanodeInfoArray = dnInfos4FirstBlock;
        int n = datanodeInfoArray.length;
        for (int i = 0; i < n; ++i) {
            DatanodeInfo datanodeInfo;
            DatanodeInfo found = datanodeInfo = datanodeInfoArray[i];
            for (DatanodeInfo dif : dnInfos4LastBlock) {
                if (!datanodeInfo.equals((Object)dif)) continue;
                found = null;
            }
            if (found == null) continue;
            nodes.add(found.getXferAddr());
            dnInfos.add(dm.getDatanode((DatanodeID)found));
        }
        nodes.add(dnInfos4LastBlock[0].getXferAddr());
        dnInfos.add(dm.getDatanode((DatanodeID)dnInfos4LastBlock[0]));
        this.writeConfigFile(this.excludeFile, nodes);
        TestDecommission.refreshNodes(ns, this.conf);
        for (DatanodeInfo datanodeInfo : dnInfos) {
            this.waitNodeState(datanodeInfo, DatanodeInfo.AdminStates.DECOMMISSIONED);
        }
        fdos.close();
    }

    @Test(timeout=360000L)
    public void testDecommissionWithNamenodeRestart() throws IOException, InterruptedException {
        LOG.info("Starting test testDecommissionWithNamenodeRestart");
        int numNamenodes = 1;
        int numDatanodes = 1;
        int replicas = 1;
        this.conf.setLong("dfs.blockreport.intervalMsec", 3600000L);
        this.conf.setLong("dfs.blockreport.initialDelay", 5L);
        this.startCluster(numNamenodes, numDatanodes, this.conf);
        Path file1 = new Path("testDecommissionWithNamenodeRestart.dat");
        DistributedFileSystem fileSys = this.cluster.getFileSystem();
        this.writeFile((FileSystem)fileSys, file1, replicas);
        DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(), this.conf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        DatanodeInfo excludedDatanodeID = info[0];
        String excludedDatanodeName = info[0].getXferAddr();
        this.writeConfigFile(this.excludeFile, new ArrayList<String>(Arrays.asList(excludedDatanodeName)));
        this.cluster.startDataNodes(this.conf, 1, true, null, null, null, null);
        Assert.assertEquals((String)"Number of datanodes should be 2 ", (long)2L, (long)this.cluster.getDataNodes().size());
        this.cluster.restartNameNode(new String[0]);
        DatanodeDescriptor datanodeInfo = NameNodeAdapter.getDatanode(this.cluster.getNamesystem(), (DatanodeID)excludedDatanodeID);
        this.waitNodeState((DatanodeInfo)datanodeInfo, DatanodeInfo.AdminStates.DECOMMISSIONED);
        Assert.assertEquals((String)"All datanodes must be alive", (long)(++numDatanodes), (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        Assert.assertTrue((String)"Checked if block was replicated after decommission.", (TestDecommission.checkFile((FileSystem)fileSys, file1, replicas, datanodeInfo.getXferAddr(), numDatanodes) == null ? 1 : 0) != 0);
        this.cleanupFile((FileSystem)fileSys, file1);
        this.cluster.shutdown();
        this.startCluster(numNamenodes, numDatanodes, this.conf);
        this.cluster.shutdown();
    }

    @Ignore
    @Test(timeout=360000L)
    public void testIncludeByRegistrationName() throws Exception {
        Configuration hdfsConf = new Configuration(this.conf);
        String registrationName = "127.0.0.100";
        String nonExistentDn = "127.0.0.10";
        hdfsConf.set("dfs.datanode.hostname", "127.0.0.100");
        this.cluster = new MiniDFSCluster.Builder(hdfsConf).numDataNodes(1).checkDataNodeHostConfig(true).setupHostsFile(true).build();
        this.cluster.waitActive();
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add("127.0.0.10");
        this.writeConfigFile(this.hostsFile, nodes);
        TestDecommission.refreshNodes(this.cluster.getNamesystem(0), hdfsConf);
        LOG.info("Waiting for DN to be marked as dead.");
        final DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(0), hdfsConf);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    BlockManagerTestUtil.checkHeartbeat(TestDecommission.this.cluster.getNamesystem().getBlockManager());
                    DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
                    return info.length == 1;
                }
                catch (IOException e) {
                    LOG.warn("Failed to check dead DNs", (Throwable)e);
                    return false;
                }
            }
        }, (int)500, (int)5000);
        int dnPort = this.cluster.getDataNodes().get(0).getXferPort();
        nodes = new ArrayList();
        nodes.add("127.0.0.100:" + dnPort);
        this.writeConfigFile(this.hostsFile, nodes);
        TestDecommission.refreshNodes(this.cluster.getNamesystem(0), hdfsConf);
        this.cluster.restartDataNode(0);
        this.cluster.triggerHeartbeats();
        LOG.info("Waiting for DN to come back.");
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    BlockManagerTestUtil.checkHeartbeat(TestDecommission.this.cluster.getNamesystem().getBlockManager());
                    DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
                    if (info.length == 1) {
                        Assert.assertFalse((boolean)info[0].isDecommissioned());
                        Assert.assertFalse((boolean)info[0].isDecommissionInProgress());
                        Assert.assertEquals((Object)"127.0.0.100", (Object)info[0].getHostName());
                        return true;
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to check dead DNs", (Throwable)e);
                }
                return false;
            }
        }, (int)500, (int)5000);
    }

    @Test(timeout=120000L)
    public void testBlocksPerInterval() throws Exception {
        Configuration newConf = new Configuration(this.conf);
        org.apache.log4j.Logger.getLogger(DecommissionManager.class).setLevel(org.apache.log4j.Level.TRACE);
        newConf.setInt("dfs.namenode.decommission.blocks.per.interval", 3);
        newConf.setInt("dfs.namenode.decommission.interval", Integer.MAX_VALUE);
        this.startCluster(1, 3, newConf);
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DatanodeManager datanodeManager = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        DecommissionManager decomManager = datanodeManager.getDecomManager();
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file1"), 64L, (short)3, 195894762L);
        this.doDecomCheck(datanodeManager, decomManager, 3);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file2"), 64L, (short)3, 195894762L);
        this.doDecomCheck(datanodeManager, decomManager, 2);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file3"), 64L, (short)3, 195894762L);
        this.doDecomCheck(datanodeManager, decomManager, 1);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file4"), 64L, (short)3, 195894762L);
        this.doDecomCheck(datanodeManager, decomManager, 1);
    }

    @Deprecated
    @Test(timeout=120000L)
    public void testNodesPerInterval() throws Exception {
        Configuration newConf = new Configuration(this.conf);
        org.apache.log4j.Logger.getLogger(DecommissionManager.class).setLevel(org.apache.log4j.Level.TRACE);
        newConf.setInt("dfs.namenode.decommission.nodes.per.interval", 1);
        newConf.setInt("dfs.namenode.decommission.interval", Integer.MAX_VALUE);
        this.startCluster(1, 3, newConf);
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DatanodeManager datanodeManager = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        DecommissionManager decomManager = datanodeManager.getDecomManager();
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file1"), 64L, (short)3, 195894762L);
        for (int i = 0; i < 3; ++i) {
            this.doDecomCheck(datanodeManager, decomManager, 1);
        }
    }

    private void doDecomCheck(DatanodeManager datanodeManager, DecommissionManager decomManager, int expectedNumCheckedNodes) throws IOException, ExecutionException, InterruptedException {
        ArrayList decommissionedNodes = Lists.newArrayList();
        for (DataNode d : this.cluster.getDataNodes()) {
            DatanodeInfo dn = this.decommissionNode(0, d.getDatanodeUuid(), decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            decommissionedNodes.add(dn);
        }
        BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
        Assert.assertEquals((String)"Unexpected # of nodes checked", (long)expectedNumCheckedNodes, (long)decomManager.getNumNodesChecked());
        for (DatanodeInfo dn : decommissionedNodes) {
            this.recommissionNode(0, dn);
        }
    }

    @Test(timeout=120000L)
    public void testPendingNodes() throws Exception {
        int i;
        Configuration newConf = new Configuration(this.conf);
        org.apache.log4j.Logger.getLogger(DecommissionManager.class).setLevel(org.apache.log4j.Level.TRACE);
        newConf.setInt("dfs.namenode.decommission.max.concurrent.tracked.nodes", 1);
        newConf.setInt("dfs.namenode.decommission.interval", Integer.MAX_VALUE);
        this.startCluster(1, 3, newConf);
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DatanodeManager datanodeManager = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        DecommissionManager decomManager = datanodeManager.getDecomManager();
        HdfsDataOutputStream open1 = (HdfsDataOutputStream)fs.create(new Path("/openFile1"), (short)3);
        open1.write(123);
        open1.hflush();
        for (DataNode d : this.cluster.getDataNodes()) {
            DataNodeTestUtils.triggerBlockReport(d);
        }
        ArrayList decommissionedNodes = Lists.newArrayList();
        for (i = 0; i < 2; ++i) {
            DataNode d = this.cluster.getDataNodes().get(i);
            DatanodeInfo dn = this.decommissionNode(0, d.getDatanodeUuid(), decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            decommissionedNodes.add(dn);
        }
        for (i = 2; i >= 0; --i) {
            this.assertTrackedAndPending(decomManager, 0, i);
            BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
        }
        open1.close();
        DataNode d = this.cluster.getDataNodes().get(2);
        DatanodeInfo dn = this.decommissionNode(0, d.getDatanodeUuid(), decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
        decommissionedNodes.add(dn);
        BlockManagerTestUtil.recheckDecommissionState(datanodeManager);
        this.assertTrackedAndPending(decomManager, 1, 0);
    }

    private void assertTrackedAndPending(DecommissionManager decomManager, int tracked, int pending) {
        Assert.assertEquals((String)"Unexpected number of tracked nodes", (long)tracked, (long)decomManager.getNumTrackedNodes());
        Assert.assertEquals((String)"Unexpected number of pending nodes", (long)pending, (long)decomManager.getNumPendingNodes());
    }

    @Test
    public void testRefreshNodeNotLeaderError() throws Exception {
        LOG.info("Starting test testDecommission");
        int numNamenodes = 2;
        int numDatanodes = 0;
        this.conf.setInt("dfs.replication", 3);
        File ef = new File(this.excludeFile.toUri());
        if (ef.exists()) {
            ef.delete();
        }
        ef.getParentFile().mkdirs();
        ef.createNewFile();
        this.startCluster(numNamenodes, numDatanodes, this.conf);
        for (int i = 0; i < 100; ++i) {
            DistributedFileSystem dfs = (DistributedFileSystem)this.cluster.getNewFileSystemInstance(0);
            dfs.refreshNodes();
            Thread.sleep(20L);
        }
        this.cluster.shutdown();
    }
}

