/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.FileNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.TestSubtreeLock;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestSmallFilesQuota {
    public static final Log LOG = LogFactory.getLog(TestSmallFilesQuota.class);

    private void runCommand(DFSAdmin admin, boolean expectError, String ... args) throws Exception {
        this.runCommand(admin, args, expectError);
    }

    private void runCommand(DFSAdmin admin, String[] args, boolean expectEror) throws Exception {
        int val = admin.run(args);
        if (expectEror) {
            Assert.assertEquals((long)val, (long)-1L);
        } else {
            Assert.assertTrue((val >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDSQuotaExceededExceptionIsHumanReadable() throws Exception {
        Integer bytes = 1024;
        try {
            throw new DSQuotaExceededException((long)bytes.intValue(), (long)bytes.intValue());
        }
        catch (DSQuotaExceededException e) {
            Assert.assertEquals((Object)"The DiskSpace quota is exceeded: quota = 1024 B = 1 KB but diskspace consumed = 1024 B = 1 KB", (Object)e.getMessage());
            return;
        }
    }

    @Test
    public void testQuotaCommands1() throws Exception {
        this.testQuotaCommands((short)1);
    }

    @Test
    public void testQuotaCommands2() throws Exception {
        this.testQuotaCommands((short)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testQuotaCommands(short replication) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.quota.update.interval", 1000);
        conf.setInt("dfs.db.replication", (int)replication);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = fs;
        dfs.setStoragePolicy(new Path("/"), "DB");
        DFSAdmin admin = new DFSAdmin((Configuration)conf);
        try {
            FSDataOutputStream fout;
            int fileLen = 1024;
            long spaceQuota = 1024 * replication * 15 / 8;
            Path parent = new Path("/test");
            Assert.assertTrue((boolean)dfs.mkdirs(parent));
            String[] args = new String[]{"-setQuota", "3", parent.toString()};
            this.runCommand(admin, args, false);
            this.runCommand(admin, false, "-setSpaceQuota", "2t", parent.toString());
            Assert.assertEquals((long)0x20000000000L, (long)DFSTestUtil.getContentSummary(dfs, parent).getSpaceQuota());
            this.runCommand(admin, false, "-setSpaceQuota", Long.toString(spaceQuota), parent.toString());
            Path childDir0 = new Path(parent, "data0");
            Assert.assertTrue((boolean)dfs.mkdirs(childDir0));
            Path childFile0 = new Path(parent, "datafile0");
            DFSTestUtil.createFile((FileSystem)fs, childFile0, 1024L, replication, 0L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            ContentSummary c = DFSTestUtil.getContentSummary(dfs, parent);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)3L);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(1024 * replication));
            Assert.assertEquals((long)c.getSpaceQuota(), (long)spaceQuota);
            c = DFSTestUtil.getContentSummary(dfs, childDir0);
            Assert.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)1L);
            Assert.assertEquals((long)c.getQuota(), (long)-1L);
            c = DFSTestUtil.getContentSummary(dfs, parent);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(1024 * replication));
            Path childDir1 = new Path(parent, "data1");
            boolean hasException = false;
            try {
                DFSTestUtil.waitForQuotaUpdatesToBeApplied();
                Assert.assertFalse((boolean)dfs.mkdirs(childDir1));
            }
            catch (QuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            Path childFile1 = new Path(parent, "datafile1");
            hasException = false;
            try {
                fout = dfs.create(childFile1);
            }
            catch (QuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            this.runCommand(admin, new String[]{"-clrQuota", parent.toString()}, false);
            c = DFSTestUtil.getContentSummary(dfs, parent);
            Assert.assertEquals((long)c.getQuota(), (long)-1L);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)spaceQuota);
            this.runCommand(admin, new String[]{"-clrQuota", childDir0.toString()}, false);
            c = DFSTestUtil.getContentSummary(dfs, childDir0);
            Assert.assertEquals((long)c.getQuota(), (long)-1L);
            fout = dfs.create(childFile1, replication);
            hasException = false;
            try {
                fout.write(new byte[512]);
                DFSTestUtil.waitForQuotaUpdatesToBeApplied();
                fout.write(new byte[512]);
                fout.close();
            }
            catch (QuotaExceededException e) {
                hasException = true;
                IOUtils.closeStream((Closeable)fout);
            }
            Assert.assertTrue((boolean)hasException);
            dfs.delete(childFile1, false);
            this.runCommand(admin, false, "-clrSpaceQuota", parent.toString());
            c = DFSTestUtil.getContentSummary(dfs, parent);
            Assert.assertEquals((long)c.getQuota(), (long)-1L);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)-1L);
            DFSTestUtil.createFile((FileSystem)dfs, childFile1, 1024L, replication, 0L);
            args = new String[]{"-setQuota", "1", parent.toString()};
            this.runCommand(admin, args, false);
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(1024), args[2]);
            return;
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamespaceCommands() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.quota.update.interval", 1000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = fs;
        dfs.setStoragePolicy(new Path("/"), "DB");
        try {
            Assert.assertTrue((boolean)dfs.mkdirs(new Path("/nqdir0/qdir1/qdir20/nqdir30")));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Path quotaDir1 = new Path("/nqdir0/qdir1");
            dfs.setQuota(quotaDir1, 6L, Long.MAX_VALUE);
            ContentSummary c = DFSTestUtil.getContentSummary(dfs, quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Path quotaDir2 = new Path("/nqdir0/qdir1/qdir20");
            dfs.setQuota(quotaDir2, 7L, Long.MAX_VALUE);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Path quotaDir3 = new Path("/nqdir0/qdir1/qdir21");
            Assert.assertTrue((boolean)dfs.mkdirs(quotaDir3));
            dfs.setQuota(quotaDir3, 2L, Long.MAX_VALUE);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir3);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)1L);
            Assert.assertEquals((long)c.getQuota(), (long)2L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Path tempPath = new Path(quotaDir3, "nqdir32");
            Assert.assertTrue((boolean)dfs.mkdirs(tempPath));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir3);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
            Assert.assertEquals((long)c.getQuota(), (long)2L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            tempPath = new Path(quotaDir3, "nqdir33");
            boolean hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.mkdirs(tempPath));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir3);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
            Assert.assertEquals((long)c.getQuota(), (long)2L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            tempPath = new Path(quotaDir2, "nqdir31");
            Assert.assertTrue((boolean)dfs.mkdirs(tempPath));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)6L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            tempPath = new Path(quotaDir2, "nqdir33");
            hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.mkdirs(tempPath));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            tempPath = new Path(quotaDir2, "nqdir30");
            dfs.rename(new Path(quotaDir3, "nqdir32"), tempPath);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertFalse((String)"Not all sub Tree locks cleared", (boolean)TestSubtreeLock.subTreeLocksExists());
            c = DFSTestUtil.getContentSummary(dfs, quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)4L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)6L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.rename(tempPath, quotaDir3));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            Assert.assertTrue((boolean)dfs.exists(tempPath));
            Assert.assertFalse((boolean)dfs.exists(new Path(quotaDir3, "nqdir30")));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.rename(tempPath, new Path(quotaDir3, "nqdir32")));
            }
            catch (QuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            Assert.assertTrue((boolean)dfs.exists(tempPath));
            Assert.assertFalse((boolean)dfs.exists(new Path(quotaDir3, "nqdir32")));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertTrue((boolean)dfs.rename(tempPath, new Path("/nqdir0")));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)4L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertTrue((boolean)dfs.mkdirs(new Path("/nqdir0/nqdir30/nqdir33")));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.rename(new Path("/nqdir0/nqdir30"), tempPath));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertTrue((boolean)dfs.rename(quotaDir3, quotaDir2));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)4L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            tempPath = new Path(quotaDir2, "qdir21");
            c = DFSTestUtil.getContentSummary(dfs, tempPath);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)1L);
            Assert.assertEquals((long)c.getQuota(), (long)2L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            dfs.delete(tempPath, true);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertTrue((boolean)dfs.rename(new Path("/nqdir0/nqdir30"), quotaDir2));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)5L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)6L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testSpaceCommands1() throws Exception {
        this.testSpaceCommands((short)1);
    }

    @Test
    public void testSpaceCommands2() throws Exception {
        this.testSpaceCommands((short)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSpaceCommands(short replication) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int BLOCK_SIZE = 512;
        int MAX_SMALL_FILE_LENGTH = 32768;
        int DISK_BLOCK_SIZE = 65536;
        conf.setInt("dfs.namenode.quota.update.interval", 1000);
        conf.setInt("dfs.db.replication", (int)replication);
        conf.setLong("dfs.blocksize", 65536L);
        conf.setInt("dfs.db.file.max.size", 32768);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(5).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = fs;
        dfs.setStoragePolicy(new Path("/"), "DB");
        try {
            FSDataOutputStream out;
            int fileLen = 1024;
            int fileSpace = fileLen * replication;
            Assert.assertTrue((boolean)dfs.mkdirs(new Path("/nqdir0/qdir1/qdir20/nqdir30")));
            Path quotaDir1 = new Path("/nqdir0/qdir1");
            dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(4 * fileSpace));
            ContentSummary c = DFSTestUtil.getContentSummary(dfs, quotaDir1);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)(4 * fileSpace));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Path quotaDir20 = new Path("/nqdir0/qdir1/qdir20");
            dfs.setQuota(quotaDir20, Long.MAX_VALUE, (long)(6 * fileSpace));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir20);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)(6 * fileSpace));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Path quotaDir21 = new Path("/nqdir0/qdir1/qdir21");
            Assert.assertTrue((boolean)dfs.mkdirs(quotaDir21));
            dfs.setQuota(quotaDir21, Long.MAX_VALUE, (long)(2 * fileSpace));
            c = DFSTestUtil.getContentSummary(dfs, quotaDir21);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)(2 * fileSpace));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Path tempPath = new Path(quotaDir21, "nqdir32");
            Assert.assertTrue((boolean)dfs.mkdirs(tempPath));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            DFSTestUtil.createFile((FileSystem)dfs, new Path(tempPath, "fileDir/file1"), fileLen, replication, 0L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir21);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            FSDataOutputStream fout = dfs.create(new Path(quotaDir21, "nqdir33/file2"), replication);
            boolean hasException = false;
            try {
                for (int i = 0; i < 2 * fileLen; i += 512) {
                    fout.write(new byte[512]);
                    DFSTestUtil.waitForQuotaUpdatesToBeApplied();
                }
                fout.close();
            }
            catch (QuotaExceededException e) {
                hasException = true;
                IOUtils.closeStream((Closeable)fout);
            }
            Assert.assertTrue((boolean)hasException);
            Assert.assertTrue((boolean)dfs.delete(new Path(quotaDir21, "nqdir33"), true));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir21);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)(2 * fileSpace));
            c = DFSTestUtil.getContentSummary(dfs, quotaDir20);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)0L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Path dstPath = new Path(quotaDir20, "nqdir30");
            Path srcPath = new Path(quotaDir21, "nqdir32");
            Assert.assertTrue((boolean)dfs.rename(srcPath, dstPath));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir20);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir1);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir21);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)0L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Path file2 = new Path(dstPath, "fileDir/file2");
            int file2Len = 2 * fileLen;
            DFSTestUtil.createFile((FileSystem)dfs, file2, file2Len, replication, 0L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir20);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
            c = DFSTestUtil.getContentSummary(dfs, quotaDir21);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)0L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.rename(dstPath, srcPath));
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertFalse((boolean)dfs.exists(srcPath));
            Assert.assertTrue((boolean)dfs.exists(dstPath));
            c = DFSTestUtil.getContentSummary(dfs, quotaDir20);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
            c = DFSTestUtil.getContentSummary(dfs, quotaDir21);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)0L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = DFSTestUtil.getContentSummary(dfs, quotaDir1);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)(4 * fileSpace));
            c = DFSTestUtil.getContentSummary(dfs, dstPath);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
            c = DFSTestUtil.getContentSummary(dfs, quotaDir20);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)(6 * fileSpace));
            c = DFSTestUtil.getContentSummary(dfs, quotaDir20);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
            hasException = false;
            try {
                out = dfs.append(file2);
                out.close();
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            long adjustFileSpace = (long)(65536 * replication) - c.getSpaceConsumed();
            dfs.setQuota(quotaDir20, Long.MAX_VALUE, (long)(6 * fileSpace) + adjustFileSpace);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir20);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)((long)(6 * fileSpace) + adjustFileSpace));
            dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(4 * fileSpace) + adjustFileSpace);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir1);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)((long)(4 * fileSpace) + adjustFileSpace));
            out = dfs.append(file2);
            out.write(new byte[fileLen]);
            out.close();
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            file2Len += fileLen;
            c = DFSTestUtil.getContentSummary(dfs, dstPath);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(4 * fileSpace));
            adjustFileSpace = (long)(65536 * replication) - c.getSpaceConsumed();
            dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(5 * fileSpace) + adjustFileSpace);
            out = dfs.append(file2);
            hasException = false;
            try {
                for (int i = 0; i < 2; ++i) {
                    out.write(new byte[512]);
                    DFSTestUtil.waitForQuotaUpdatesToBeApplied();
                }
                out.close();
                c = DFSTestUtil.getContentSummary(dfs, dstPath);
                adjustFileSpace = (long)(65536 * replication) - c.getSpaceConsumed();
                dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(5 * fileSpace) + adjustFileSpace);
                out = dfs.append(file2);
                out.write(new byte[512]);
                DFSTestUtil.waitForQuotaUpdatesToBeApplied();
                out.close();
            }
            catch (QuotaExceededException e) {
                hasException = true;
                IOUtils.closeStream((Closeable)out);
            }
            Assert.assertTrue((boolean)hasException);
            file2Len += fileLen;
            c = DFSTestUtil.getContentSummary(dfs, dstPath);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace));
            dfs.setReplication(file2, (short)(replication + 1));
            Assert.assertEquals((long)replication, (long)dfs.getFileStatus(file2).getReplication());
            c = DFSTestUtil.getContentSummary(dfs, dstPath);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace));
            Path quotaDir2053 = new Path("/hdfs-2053");
            Assert.assertTrue((boolean)dfs.mkdirs(quotaDir2053));
            Path quotaDir2053_A = new Path(quotaDir2053, "A");
            Assert.assertTrue((boolean)dfs.mkdirs(quotaDir2053_A));
            Path quotaDir2053_B = new Path(quotaDir2053, "B");
            Assert.assertTrue((boolean)dfs.mkdirs(quotaDir2053_B));
            Path quotaDir2053_C = new Path(quotaDir2053, "C");
            Assert.assertTrue((boolean)dfs.mkdirs(quotaDir2053_C));
            int sizeFactorA = 1;
            int sizeFactorB = 2;
            int sizeFactorC = 4;
            dfs.setQuota(quotaDir2053_C, Long.MAX_VALUE, (long)((sizeFactorC + 1) * fileSpace));
            c = DFSTestUtil.getContentSummary(dfs, quotaDir2053_C);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)((sizeFactorC + 1) * fileSpace));
            DFSTestUtil.createFile((FileSystem)dfs, new Path(quotaDir2053_A, "fileA"), sizeFactorA * fileLen, replication, 0L);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir2053_A);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(sizeFactorA * fileSpace));
            DFSTestUtil.createFile((FileSystem)dfs, new Path(quotaDir2053_B, "fileB"), sizeFactorB * fileLen, replication, 0L);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir2053_B);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(sizeFactorB * fileSpace));
            DFSTestUtil.createFile((FileSystem)dfs, new Path(quotaDir2053_C, "fileC"), sizeFactorC * fileLen, replication, 0L);
            c = DFSTestUtil.getContentSummary(dfs, quotaDir2053_C);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(sizeFactorC * fileSpace));
            c = DFSTestUtil.getContentSummary(dfs, quotaDir2053);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)((sizeFactorA + sizeFactorB + sizeFactorC) * fileSpace));
        }
        finally {
            cluster.shutdown();
        }
    }

    private static void checkContentSummary(ContentSummary expected, ContentSummary computed) {
        Assert.assertEquals((Object)expected.toString(), (Object)computed.toString());
    }

    private void testBlockAllocationAdjustsUsageConservatively1() throws Exception {
        this.testBlockAllocationAdjustsUsageConservatively((short)1);
    }

    private void testBlockAllocationAdjustsUsageConservatively2() throws Exception {
        this.testBlockAllocationAdjustsUsageConservatively((short)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBlockAllocationAdjustsUsageConservatively(short dbReplication) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_SMALL_FILE_SIZE = 6144;
        int BLOCK_SIZE = 24576;
        conf.setInt("dfs.db.replication", (int)dbReplication);
        conf.setInt("dfs.db.file.max.size", 6144);
        conf.setInt("dfs.blocksize", 24576);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        fs.setStoragePolicy(new Path("/"), "DB");
        DFSAdmin admin = new DFSAdmin((Configuration)conf);
        String nnAddr = conf.get("dfs.namenode.http-address");
        String webhdfsuri = "webhdfs://" + nnAddr;
        System.out.println("webhdfsuri=" + webhdfsuri);
        FileSystem webhdfs = new Path(webhdfsuri).getFileSystem((Configuration)conf);
        try {
            Path dir = new Path("/folder1/folder2/folder3/folder4/folder5/folder6/folder7/folder8/folder9/folder10");
            Path file1 = new Path(dir, "test1");
            Path file2 = new Path(dir, "test2");
            Path file3 = new Path(dir, "test3");
            Path file4 = new Path(dir, "test4");
            boolean exceededQuota = false;
            int QUOTA_SIZE = dbReplication * 6144;
            int FILE_SIZE = 3072;
            Assert.assertTrue((boolean)fs.mkdirs(dir));
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE), dir.toString());
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE), "/folder1/folder2");
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE), "/folder1/folder2/folder3/folder4/folder5");
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE), "/folder1/folder2/folder3/folder4/folder5/folder6/folder7/folder8");
            DFSTestUtil.createFile((FileSystem)fs, file1, 3072L, (short)3, 1L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertEquals((long)dbReplication, (long)webhdfs.getFileLinkStatus(file1).getReplication());
            ContentSummary c = fs.getContentSummary(dir);
            TestSmallFilesQuota.checkContentSummary(c, webhdfs.getContentSummary(dir));
            Assert.assertEquals((String)"Quota is half consumed", (long)(QUOTA_SIZE / 2), (long)c.getSpaceConsumed());
            FSDataOutputStream out = fs.create(file2, (short)3);
            try {
                out.write(new byte[3072]);
                out.close();
            }
            catch (QuotaExceededException e) {
                exceededQuota = true;
                IOUtils.closeStream((Closeable)out);
            }
            Assert.assertFalse((String)"Quota exceeded", (boolean)exceededQuota);
            int QUOTA_SIZE_UPDATE = QUOTA_SIZE + 73728;
            int FILE_SIZE_UPDATE = 12288;
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE_UPDATE), dir.toString());
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE_UPDATE), "/folder1/folder2");
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE_UPDATE), "/folder1/folder2/folder3/folder4/folder5");
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE_UPDATE), "/folder1/folder2/folder3/folder4/folder5/folder6/folder7/folder8");
            DFSTestUtil.createFile((FileSystem)fs, file3, 12288L, (short)3, 1L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            c = fs.getContentSummary(dir);
            TestSmallFilesQuota.checkContentSummary(c, webhdfs.getContentSummary(dir));
            Assert.assertEquals((String)"Quota is partially consumed", (long)(QUOTA_SIZE + 36864), (long)c.getSpaceConsumed());
            exceededQuota = false;
            out = fs.create(file4, (short)3);
            try {
                out.write(new byte[12288]);
                DFSTestUtil.waitForQuotaUpdatesToBeApplied();
                out.close();
            }
            catch (QuotaExceededException e) {
                exceededQuota = true;
                IOUtils.closeStream((Closeable)out);
            }
            Assert.assertTrue((String)"Quota not exceeded", (boolean)exceededQuota);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testMultipleFilesSmallerThanOneBlock1() throws Exception {
        this.testMultipleFilesSmallerThanOneBlock((short)1);
    }

    @Test
    public void testMultipleFilesSmallerThanOneBlock2() throws Exception {
        this.testMultipleFilesSmallerThanOneBlock((short)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMultipleFilesSmallerThanOneBlock(short dbReplication) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_SMALL_FILE_SIZE = 5120;
        int BLOCK_SIZE = 6144;
        conf.setInt("dfs.db.replication", (int)dbReplication);
        conf.setInt("dfs.blocksize", 6144);
        conf.setInt("dfs.db.file.max.size", 5120);
        conf.setInt("dfs.namenode.quota.update.interval", 1000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        fs.setStoragePolicy(new Path("/"), "DB");
        DFSAdmin admin = new DFSAdmin((Configuration)conf);
        String nnAddr = conf.get("dfs.namenode.http-address");
        String webhdfsuri = "webhdfs://" + nnAddr;
        System.out.println("webhdfsuri=" + webhdfsuri);
        FileSystem webhdfs = new Path(webhdfsuri).getFileSystem((Configuration)conf);
        try {
            Path dir = new Path("/test");
            boolean exceededQuota = false;
            int FILE_SIZE = 1024;
            int NO_FILES = 60;
            int QUOTA_SIZE = 61440 * dbReplication;
            Assert.assertTrue((boolean)fs.mkdirs(dir));
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE), dir.toString());
            for (int i = 0; i < 59; ++i) {
                Path file = new Path("/test/test" + i);
                DFSTestUtil.createFile((FileSystem)fs, file, 1024L, (short)3, 1L);
                Thread.sleep(1000L);
            }
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            ContentSummary c = fs.getContentSummary(dir);
            TestSmallFilesQuota.checkContentSummary(c, webhdfs.getContentSummary(dir));
            Assert.assertEquals((String)"Invalid space consumed", (long)(QUOTA_SIZE - dbReplication * 1024), (long)c.getSpaceConsumed());
            Path file = new Path("/test/test60");
            FSDataOutputStream out = fs.create(file, (short)3);
            try {
                out.write(new byte[5121]);
                out.close();
                DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            }
            catch (QuotaExceededException e) {
                exceededQuota = true;
                IOUtils.closeStream((Closeable)out);
            }
            Assert.assertTrue((String)"Quota not exceeded", (boolean)exceededQuota);
            exceededQuota = false;
            out = fs.create(file, (short)3);
            try {
                out.write(new byte[1024]);
                out.close();
                DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            }
            catch (QuotaExceededException e) {
                exceededQuota = true;
                IOUtils.closeStream((Closeable)out);
            }
            Assert.assertFalse((String)"Quota exceeded", (boolean)exceededQuota);
            c = fs.getContentSummary(dir);
            TestSmallFilesQuota.checkContentSummary(c, webhdfs.getContentSummary(dir));
            Assert.assertEquals((String)"Invalid space consumed", (long)QUOTA_SIZE, (long)c.getSpaceConsumed());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsynchronousQuota() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int BLOCK_SIZE = 512;
        conf.setInt("dfs.namenode.quota.update.interval", 5000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem fs;
            DistributedFileSystem dfs = fs = cluster.getFileSystem();
            dfs.setStoragePolicy(new Path("/"), "DB");
            Path testFolder = new Path("/test");
            dfs.mkdirs(testFolder);
            dfs.setQuota(testFolder, 2L, 1024L);
            Path testFile1 = new Path(testFolder, "test1");
            Path testFile2 = new Path(testFolder, "test2");
            Path testFile3 = new Path(testFolder, "test3");
            dfs.create(testFile1).close();
            dfs.create(testFile2).close();
            dfs.create(testFile3).close();
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Path testFile4 = new Path(testFolder, "test4");
            try {
                dfs.create(testFile4).close();
                Assert.fail();
            }
            catch (NSQuotaExceededException nSQuotaExceededException) {
                // empty catch block
            }
            dfs.delete(testFile1, true);
            dfs.delete(testFile2, true);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            try {
                dfs.create(testFile4).close();
                Assert.fail();
            }
            catch (NSQuotaExceededException nSQuotaExceededException) {
                // empty catch block
            }
            dfs.delete(testFile3, true);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            FSDataOutputStream out = dfs.create(testFile4);
            for (int i = 0; i < 3; ++i) {
                out.write(new byte[512]);
            }
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            try {
                out.write(new byte[512]);
                out.close();
                Assert.fail();
            }
            catch (DSQuotaExceededException i) {
                // empty catch block
            }
            IOUtils.closeStream((Closeable)out);
            dfs.delete(testFile4, true);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            out = dfs.create(testFile4);
            for (int i = 0; i < 2; ++i) {
                out.write(new byte[512]);
            }
            out.close();
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetQuotaLate() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.quota.update.interval", 5000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem fs;
            DistributedFileSystem dfs = fs = cluster.getFileSystem();
            dfs.setStoragePolicy(new Path("/"), "DB");
            Path testFolder = new Path("/test");
            dfs.mkdirs(testFolder);
            Path testFile1 = new Path(testFolder, "test1");
            dfs.create(testFile1).close();
            dfs.setQuota(testFolder, 2L, 1024L);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetQuotaOnNonExistingDirectory() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.quota.update.interval", 5000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem fs;
            DistributedFileSystem dfs = fs = cluster.getFileSystem();
            dfs.setStoragePolicy(new Path("/"), "DB");
            Path testFolder = new Path("/test");
            dfs.setQuota(testFolder, 2L, 1024L);
            Assert.fail((String)"SetQuota on non-existing directory succeeded");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testDiskspaceForSmallFilesWhenMovedToBlocks1() throws Exception {
        this.testDiskspaceForSmallFilesWhenMovedToBlocks((short)1);
    }

    @Test
    public void testDiskspaceForSmallFilesWhenMovedToBlocks2() throws Exception {
        this.testDiskspaceForSmallFilesWhenMovedToBlocks((short)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDiskspaceForSmallFilesWhenMovedToBlocks(short dbReplication) throws Exception {
        int replication = 3;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.db.replication", (int)dbReplication);
        conf.setInt("dfs.replication", 3);
        conf.setInt("dfs.namenode.quota.update.interval", 1000);
        int MAX_SMALL_FILE_SIZE = 65536;
        int BLOCK_SIZE = 131072;
        conf.setInt("dfs.db.file.max.size", 65536);
        conf.setInt("dfs.blocksize", 131072);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = fs;
        dfs.setStoragePolicy(new Path("/"), "DB");
        DFSAdmin admin = new DFSAdmin((Configuration)conf);
        try {
            int smallfileLen = 1024;
            long spaceQuota = 786432L;
            Path parent = new Path("/test");
            Assert.assertTrue((boolean)dfs.mkdirs(parent));
            String[] args = new String[]{"-setQuota", "5", parent.toString()};
            this.runCommand(admin, args, false);
            this.runCommand(admin, false, "-setSpaceQuota", Long.toString(786432L), parent.toString());
            Path childDir0 = new Path(parent, "data0");
            dfs.mkdirs(childDir0);
            Path datafile0 = new Path(childDir0, "datafile0");
            DFSTestUtil.createFile((FileSystem)fs, datafile0, 1024L, (short)3, 0L);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertEquals((long)dbReplication, (long)dfs.getFileStatus(datafile0).getReplication());
            ContentSummary c = DFSTestUtil.getContentSummary(dfs, parent);
            Assert.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)5L);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(1024 * dbReplication));
            Assert.assertEquals((long)c.getSpaceQuota(), (long)786432L);
            boolean exceededQuota = false;
            FSDataOutputStream out = fs.append(datafile0);
            try {
                out.write(new byte[1024]);
                out.close();
            }
            catch (QuotaExceededException e) {
                exceededQuota = true;
                IOUtils.closeStream((Closeable)out);
            }
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertFalse((String)"Quota exceeded", (boolean)exceededQuota);
            Assert.assertEquals((long)dbReplication, (long)dfs.getFileStatus(datafile0).getReplication());
            c = DFSTestUtil.getContentSummary(dfs, parent);
            Assert.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)5L);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(2048 * dbReplication));
            Assert.assertEquals((long)c.getSpaceQuota(), (long)786432L);
            out = fs.append(datafile0);
            try {
                out.write(new byte[131072]);
                out.close();
            }
            catch (QuotaExceededException e) {
                exceededQuota = true;
                IOUtils.closeStream((Closeable)out);
            }
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertFalse((String)"Quota exceeded", (boolean)exceededQuota);
            Assert.assertEquals((long)3L, (long)dfs.getFileStatus(datafile0).getReplication());
            c = DFSTestUtil.getContentSummary(dfs, parent);
            Assert.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)5L);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)399360L);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)c.getTypeConsumed(StorageType.DISK));
            Assert.assertEquals((long)0L, (long)c.getTypeConsumed(StorageType.DB));
            Assert.assertEquals((long)c.getSpaceQuota(), (long)786432L);
            out = fs.append(datafile0);
            try {
                out.write(new byte[129024]);
                out.close();
            }
            catch (QuotaExceededException e) {
                exceededQuota = true;
                IOUtils.closeStream((Closeable)out);
            }
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertFalse((String)"Quota exceeded", (boolean)exceededQuota);
            c = DFSTestUtil.getContentSummary(dfs, parent);
            Assert.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)5L);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)786432L);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)786432L);
            out = fs.append(datafile0);
            try {
                out.write(new byte[1]);
                out.close();
            }
            catch (QuotaExceededException e) {
                exceededQuota = true;
                IOUtils.closeStream((Closeable)out);
            }
            Assert.assertTrue((String)"Quota exceeded", (boolean)exceededQuota);
            try {
                dfs.setReplication(datafile0, (short)4);
                exceededQuota = false;
            }
            catch (QuotaExceededException e) {
                exceededQuota = true;
            }
            Assert.assertTrue((String)"Quota exceeded", (boolean)exceededQuota);
            long increasedSpaceQuota = 0x100000L;
            this.runCommand(admin, false, "-setSpaceQuota", Long.toString(0x100000L), parent.toString());
            dfs.setReplication(datafile0, (short)4);
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            Assert.assertEquals((long)4L, (long)dfs.getFileStatus(datafile0).getReplication());
            c = DFSTestUtil.getContentSummary(dfs, parent);
            Assert.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)5L);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)0x100000L);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)0x100000L);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)c.getTypeConsumed(StorageType.DISK));
            Assert.assertEquals((long)0L, (long)c.getTypeConsumed(StorageType.DB));
        }
        finally {
            cluster.shutdown();
        }
    }
}

