/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.metadata.HdfsStorageFactory;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.util.Shell;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDatanodeManager {
    public static final Logger LOG = LoggerFactory.getLogger(TestDatanodeManager.class);
    final int NUM_ITERATIONS = 500;

    @Test
    public void testNumVersionsReportedCorrect() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        DatanodeManager dm = new DatanodeManager((BlockManager)Mockito.mock(BlockManager.class), (Namesystem)fsn, new Configuration());
        Random rng = new Random();
        int seed = rng.nextInt();
        rng = new Random(seed);
        LOG.info("Using seed " + seed + " for testing");
        HashMap<String, DatanodeRegistration> sIdToDnReg = new HashMap<String, DatanodeRegistration>();
        for (int i = 0; i < 500; ++i) {
            if (rng.nextBoolean() && i % 3 == 0 && sIdToDnReg.size() != 0) {
                int randomIndex = rng.nextInt() % sIdToDnReg.size();
                Iterator it = sIdToDnReg.entrySet().iterator();
                for (int j = 0; j < randomIndex - 1; ++j) {
                    it.next();
                }
                DatanodeRegistration toRemove = (DatanodeRegistration)it.next().getValue();
                LOG.info("Removing node " + toRemove.getDatanodeUuid() + " ip " + toRemove.getXferAddr() + " version : " + toRemove.getSoftwareVersion());
                dm.removeDatanode((DatanodeID)toRemove, false);
                it.remove();
            } else {
                String storageID = "someStorageID" + rng.nextInt(5000);
                DatanodeRegistration dr = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
                Mockito.when((Object)dr.getDatanodeUuid()).thenReturn((Object)storageID);
                if (sIdToDnReg.containsKey(storageID)) {
                    dr = (DatanodeRegistration)sIdToDnReg.get(storageID);
                    if (rng.nextBoolean()) {
                        dr.setIpAddr(dr.getIpAddr() + "newIP");
                    }
                } else {
                    String ip = "someIP" + storageID;
                    Mockito.when((Object)dr.getIpAddr()).thenReturn((Object)ip);
                    Mockito.when((Object)dr.getXferAddr()).thenReturn((Object)(ip + ":9000"));
                    Mockito.when((Object)dr.getXferPort()).thenReturn((Object)9000);
                }
                Mockito.when((Object)dr.getSoftwareVersion()).thenReturn((Object)("version" + rng.nextInt(5)));
                LOG.info("Registering node storageID: " + dr.getDatanodeUuid() + ", version: " + dr.getSoftwareVersion() + ", IP address: " + dr.getXferAddr());
                dm.registerDatanode(dr);
                sIdToDnReg.put(storageID, dr);
            }
            HashMap mapToCheck = dm.getDatanodesSoftwareVersions();
            for (Map.Entry it : sIdToDnReg.entrySet()) {
                String ver = ((DatanodeRegistration)it.getValue()).getSoftwareVersion();
                if (!mapToCheck.containsKey(ver)) {
                    throw new AssertionError((Object)("The correct number of datanodes of a version was not found on iteration " + i));
                }
                mapToCheck.put(ver, (Integer)mapToCheck.get(ver) - 1);
                if ((Integer)mapToCheck.get(ver) != 0) continue;
                mapToCheck.remove(ver);
            }
            for (Map.Entry entry : mapToCheck.entrySet()) {
                LOG.info("Still in map: " + (String)entry.getKey() + " has " + entry.getValue());
            }
            Assert.assertEquals((String)("The map of version counts returned by DatanodeManager was not what it was expected to be on iteration " + i), (long)0L, (long)mapToCheck.size());
        }
    }

    @Test
    public void testSortLocatedBlocks() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        this.HelperFunction(null);
    }

    @Test
    public void testgoodScript() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        this.HelperFunction("/" + Shell.appendScriptExtension((String)"topology-script"));
    }

    @Test
    public void testBadScript() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        this.HelperFunction("/" + Shell.appendScriptExtension((String)"topology-broken-script"));
    }

    public void HelperFunction(String scriptFileName) throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        if (scriptFileName != null && !scriptFileName.isEmpty()) {
            URL shellScript = this.getClass().getResource(scriptFileName);
            Path resourcePath = Paths.get(shellScript.toURI());
            FileUtil.setExecutable((File)resourcePath.toFile(), (boolean)true);
            conf.set("net.topology.script.file.name", resourcePath.toString());
        }
        DatanodeManager dm = new DatanodeManager((BlockManager)Mockito.mock(BlockManager.class), (Namesystem)fsn, conf);
        DatanodeInfo[] locs = new DatanodeInfo[4];
        String[] storageIDs = new String[4];
        StorageType[] storageTypes = new StorageType[]{StorageType.ARCHIVE, StorageType.DEFAULT, StorageType.DISK, StorageType.SSD};
        for (int i = 0; i < 4; ++i) {
            String uuid = "UUID-" + i;
            String ip = "IP-" + i;
            DatanodeRegistration dr = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
            Mockito.when((Object)dr.getDatanodeUuid()).thenReturn((Object)uuid);
            Mockito.when((Object)dr.getIpAddr()).thenReturn((Object)ip);
            Mockito.when((Object)dr.getXferAddr()).thenReturn((Object)(ip + ":9000"));
            Mockito.when((Object)dr.getXferPort()).thenReturn((Object)9000);
            Mockito.when((Object)dr.getSoftwareVersion()).thenReturn((Object)"version1");
            dm.registerDatanode(dr);
            locs[i] = dm.getDatanode(new DatanodeID(ip, ip, uuid, 9000, 9000, 9000, 9000));
            storageIDs[i] = "storageID-" + i;
        }
        locs[0].setDecommissioned();
        locs[1].setDecommissioned();
        ExtendedBlock b = new ExtendedBlock("somePoolID", 1234L);
        LocatedBlock block = new LocatedBlock(b, locs, storageIDs, storageTypes);
        ArrayList<LocatedBlock> blocks = new ArrayList<LocatedBlock>();
        blocks.add(block);
        String targetIp = locs[3].getIpAddr();
        dm.sortLocatedBlocks(targetIp, blocks);
        DatanodeInfo[] sortedLocs = block.getLocations();
        storageIDs = block.getStorageIDs();
        storageTypes = block.getStorageTypes();
        Assert.assertThat((Object)sortedLocs.length, (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)storageIDs.length, (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)storageTypes.length, (Matcher)Is.is((Object)4));
        for (int i = 0; i < sortedLocs.length; ++i) {
            Assert.assertThat((Object)((DatanodeInfoWithStorage)sortedLocs[i]).getStorageID(), (Matcher)Is.is((Object)storageIDs[i]));
            Assert.assertThat((Object)((DatanodeInfoWithStorage)sortedLocs[i]).getStorageType(), (Matcher)Is.is((Object)storageTypes[i]));
        }
        Assert.assertThat((Object)sortedLocs[0].getIpAddr(), (Matcher)Is.is((Object)targetIp));
        Assert.assertThat((Object)sortedLocs[sortedLocs.length - 1].getAdminState(), (Matcher)Is.is((Object)DatanodeInfo.AdminStates.DECOMMISSIONED));
        Assert.assertThat((Object)sortedLocs[sortedLocs.length - 2].getAdminState(), (Matcher)Is.is((Object)DatanodeInfo.AdminStates.DECOMMISSIONED));
    }
}

