/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.TestLease;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSDirStatAndListingOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.Lease;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.AccessControlException;

public class NameNodeAdapter {
    public static FSNamesystem getNamesystem(NameNode namenode) {
        return namenode.getNamesystem();
    }

    public static LocatedBlocks getBlockLocations(NameNode namenode, String src, long offset, long length) throws IOException {
        return namenode.getNamesystem().getBlockLocations("foo", src, offset, length);
    }

    public static HdfsFileStatus getFileInfo(NameNode namenode, String src, boolean resolveLink, boolean needLocation, boolean needBlockToken) throws AccessControlException, UnresolvedLinkException, StandbyException, IOException {
        return FSDirStatAndListingOp.getFileInfo((FSDirectory)namenode.getNamesystem().getFSDirectory(), (String)src, (boolean)resolveLink, (boolean)needLocation, (boolean)needBlockToken);
    }

    public static boolean mkdirs(NameNode namenode, String src, PermissionStatus permissions, boolean createParent) throws UnresolvedLinkException, IOException {
        return namenode.getNamesystem().mkdirs(src, permissions, createParent);
    }

    public static void enterSafeMode(NameNode namenode, boolean resourcesLow) throws IOException {
        namenode.getNamesystem().enterSafeMode(resourcesLow);
    }

    public static void leaveSafeMode(NameNode namenode) throws IOException {
        namenode.getNamesystem().leaveSafeMode();
    }

    public static Server getRpcServer(NameNode namenode) {
        return ((NameNodeRpcServer)namenode.getRpcServer()).clientRpcServer;
    }

    public static DelegationTokenSecretManager getDtSecretManager(FSNamesystem ns) {
        return ns.getDelegationTokenSecretManager();
    }

    public static HeartbeatResponse sendHeartBeat(DatanodeRegistration nodeReg, DatanodeDescriptor dd, FSNamesystem namesystem) throws IOException, StorageException {
        return namesystem.handleHeartbeat(nodeReg, BlockManagerTestUtil.getStorageReportsForDatanode(dd), dd.getCacheCapacity(), dd.getCacheRemaining(), 0, 0, 0, null);
    }

    public static boolean setReplication(FSNamesystem ns, String src, short replication) throws IOException {
        return ns.setReplication(src, replication);
    }

    public static LeaseManager getLeaseManager(FSNamesystem ns) {
        return ns.leaseManager;
    }

    public static void setLeasePeriod(FSNamesystem namesystem, long soft, long hard) {
        NameNodeAdapter.getLeaseManager(namesystem).setLeasePeriod(soft, hard);
        namesystem.leaseManager.triggerMonitorCheckNow();
    }

    public static String getLeaseHolderForPath(final NameNode namenode, final String path) throws IOException {
        return (String)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                locks.add((Lock)new TestLease.TestLeaseLock(TransactionLockTypes.LockType.READ, TransactionLockTypes.LockType.READ, path));
            }

            public Object performTask() throws StorageException, IOException {
                Lease l = namenode.getNamesystem().leaseManager.getLeaseByPath(path);
                return l == null ? null : l.getHolder();
            }
        }.handle();
    }

    public static long getLeaseRenewalTime(final NameNode nn, final String path) throws IOException {
        HopsTransactionalRequestHandler leaseRenewalTimeHandler = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                locks.add((Lock)new TestLease.TestLeaseLock(TransactionLockTypes.LockType.READ, TransactionLockTypes.LockType.READ, path));
            }

            public Object performTask() throws StorageException, IOException {
                LeaseManager lm = nn.getNamesystem().leaseManager;
                Lease l = lm.getLeaseByPath(path);
                if (l == null) {
                    return -1;
                }
                return l.getLastUpdate();
            }
        };
        return (Long)leaseRenewalTimeHandler.handle();
    }

    public static DatanodeDescriptor getDatanode(FSNamesystem ns, DatanodeID id) throws IOException {
        return ns.getBlockManager().getDatanodeManager().getDatanode(id);
    }

    public static long[] getStats(FSNamesystem fsn) throws IOException {
        return fsn.getStats();
    }

    public static int getSafeModeSafeBlocks(NameNode nn) throws IOException {
        FSNamesystem.SafeModeInfo smi = nn.getNamesystem().getSafeModeInfoForTests();
        if (smi == null) {
            return -1;
        }
        return smi.blockSafe();
    }

    public static boolean safeModeInitializedReplQueues(NameNode nn) throws IOException {
        return nn.getNamesystem().isPopulatingReplQueues();
    }
}

