/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.tools.DebugAdmin;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDebugAdmin {
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private DebugAdmin admin;
    private DataNode datanode;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.admin = new DebugAdmin(conf);
        this.datanode = this.cluster.getDataNodes().get(0);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runCmd(String[] cmd) throws Exception {
        int ret;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldErr = System.err;
        PrintStream oldOut = System.out;
        System.setErr(out);
        System.setOut(out);
        try {
            ret = this.admin.run(cmd);
        }
        finally {
            System.setErr(oldErr);
            System.setOut(oldOut);
            IOUtils.closeStream((Closeable)out);
        }
        return "ret: " + ret + ", " + bytes.toString().replaceAll(System.getProperty("line.separator"), "");
    }

    @Test(timeout=60000L)
    public void testRecoverLease() throws Exception {
        Assert.assertEquals((Object)"ret: 1, You must supply a -path argument to recoverLease.", (Object)this.runCmd(new String[]{"recoverLease", "-retries", "1"}));
        FSDataOutputStream out = this.fs.create(new Path("/foo"));
        out.write(123);
        out.close();
        Assert.assertEquals((Object)"ret: 0, recoverLease SUCCEEDED on /foo", (Object)this.runCmd(new String[]{"recoverLease", "-path", "/foo"}));
    }

    @Test(timeout=60000L)
    public void testVerifyBlockChecksumCommand() throws Exception {
        DFSTestUtil.createFile((FileSystem)this.fs, new Path("/bar"), 1234L, (short)1, -559038737L);
        FsDatasetSpi fsd = this.datanode.getFSDataset();
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)this.fs, new Path("/bar"));
        File blockFile = FsDatasetTestUtil.getBlockFile(fsd, block.getBlockPoolId(), block.getLocalBlock());
        Assert.assertEquals((Object)"ret: 1, You must specify a meta file with -meta", (Object)this.runCmd(new String[]{"verify", "-block", blockFile.getAbsolutePath()}));
        File metaFile = FsDatasetTestUtil.getMetaFile(fsd, block.getBlockPoolId(), block.getLocalBlock());
        Assert.assertEquals((Object)"ret: 0, Checksum type: DataChecksum(type=CRC32C, chunkSize=512)", (Object)this.runCmd(new String[]{"verify", "-meta", metaFile.getAbsolutePath()}));
        Assert.assertEquals((Object)("ret: 0, Checksum type: DataChecksum(type=CRC32C, chunkSize=512)Checksum verification succeeded on block file " + blockFile.getAbsolutePath()), (Object)this.runCmd(new String[]{"verify", "-meta", metaFile.getAbsolutePath(), "-block", blockFile.getAbsolutePath()}));
    }
}

