/*
 * Decompiled with CFR 0.152.
 */
package io.hops.common;

import io.hops.common.CountersQueue;
import io.hops.exception.StorageException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class IDsGenerator {
    private static final Log LOG = LogFactory.getLog(IDsGenerator.class);
    private int batchSize;
    private int threshold;
    private CountersQueue cQ;

    IDsGenerator(int batchSize, float threshold) {
        this.batchSize = batchSize;
        this.threshold = (int)(threshold * (float)batchSize);
        this.cQ = new CountersQueue();
    }

    public synchronized long getUniqueID() throws StorageException {
        if (!this.cQ.has(1)) {
            LOG.warn((Object)"ID Generator has run out of cached IDs. Fetching new set of IDs from DB");
            this.getMoreIdsIfNeeded();
        }
        return this.cQ.next();
    }

    protected synchronized boolean getMoreIdsIfNeeded() throws StorageException {
        try {
            if (!this.cQ.has(this.threshold)) {
                this.cQ.addCounter(this.incrementCounter(this.batchSize));
                return true;
            }
            return false;
        }
        catch (IOException e) {
            if (e instanceof StorageException) {
                throw (StorageException)e;
            }
            throw new StorageException((Throwable)e);
        }
    }

    protected CountersQueue getCQ() {
        return this.cQ;
    }

    abstract CountersQueue.Counter incrementCounter(int var1) throws IOException;
}

