/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.transaction.EntityManager;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.ipc.RetryCache;

public class RetryCacheEntryLock
extends Lock {
    private final List<byte[]> clientId = new ArrayList<byte[]>();
    private final List<Integer> callId = new ArrayList<Integer>();
    private final List<Long> epochs = new ArrayList<Long>();

    RetryCacheEntryLock(byte[] clientId, int callId, long epoch) {
        this.clientId.add(clientId);
        this.callId.add(callId);
        this.epochs.add(epoch);
    }

    RetryCacheEntryLock(List<RetryCache.CacheEntry> entries) {
        for (RetryCache.CacheEntry entry : entries) {
            this.clientId.add(entry.getClientId());
            this.callId.add(entry.getCallId());
            this.epochs.add(entry.getEpoch());
        }
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        RetryCacheEntryLock.setLockMode((TransactionLockTypes.LockType)TransactionLockTypes.LockType.WRITE);
        for (int i = 0; i < this.clientId.size(); ++i) {
            byte[] cid = this.clientId.get(i);
            int clid = this.callId.get(i);
            long epoch = this.epochs.get(i);
            EntityManager.find((FinderType)RetryCacheEntry.Finder.ByPK, (Object[])new Object[]{cid, clid, epoch});
        }
    }

    protected Lock.Type getType() {
        return Lock.Type.retryCachEntry;
    }
}

