/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.MetadataLogDataAccess;
import io.hops.metadata.hdfs.entity.MetaStatus;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Test;

public class TestMetaStatus {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Logger.getRootLogger().setLevel(Level.WARN);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.slicer.batchsize", 2);
        conf.setInt("dfs.replication", 3);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            String basePath = "/Projects/some_proj/Resources";
            fs.mkdirs(new Path(basePath));
            int files = 10;
            for (int i = 0; i < files; ++i) {
                fs.create(new Path(basePath + "/file_" + i), (short)3).close();
            }
            dfs.setMetaStatus(new Path(basePath), MetaStatus.META_ENABLED);
            long count = (Long)new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

                public Object performTask() throws IOException {
                    MetadataLogDataAccess dataAccess = (MetadataLogDataAccess)HdfsStorageFactory.getDataAccess(MetadataLogDataAccess.class);
                    return new Long(dataAccess.countAll());
                }
            }.handle();
            assert (count == (long)(files + 1));
        }
        finally {
            cluster.shutdown();
        }
    }
}

