/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestPutCLIWithMultiNN {
    private static final Log LOG = LogFactory.getLog(TestPutCLIWithMultiNN.class);
    private final int SUCCESS = 0;
    private final int ERROR = 1;
    static final String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');

    static Path writeFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream out = fs.create(f);
        out.writeBytes("dhruba: " + f);
        out.close();
        Assert.assertTrue((boolean)fs.exists(f));
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutMultiNN() throws Exception {
        int NN_COUNT = 3;
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(3)).numDataNodes(1).format(true).build();
        FsShell shell = null;
        DistributedFileSystem fs = null;
        File localDir = new File(TEST_ROOT_DIR, "localDir");
        File copiedDir = new File(TEST_ROOT_DIR, "copiedDir");
        if (copiedDir.exists()) {
            FileUtils.deleteDirectory((File)copiedDir);
        }
        if (localDir.exists()) {
            FileUtils.deleteDirectory((File)localDir);
        }
        String hdfsTestDirStr = TEST_ROOT_DIR;
        Path hdfsTestDir = new Path(hdfsTestDirStr);
        Random rand = new Random(System.currentTimeMillis());
        try {
            fs = cluster.getFileSystem(rand.nextInt(3));
            this.createLocalDir(localDir);
            fs.mkdirs(hdfsTestDir);
            shell = new FsShell(conf);
            long startTime = System.currentTimeMillis();
            String[] argv = new String[]{"-put", "-t", "10", localDir.getAbsolutePath(), hdfsTestDirStr + "/copiedDir"};
            int res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"-put command should have succeeded", (long)0L, (long)res);
            LOG.info((Object)("Time taken by put " + (System.currentTimeMillis() - startTime) / 1000L + " sec"));
            startTime = System.currentTimeMillis();
            argv = new String[]{"-copyToLocal", "-t", "10", hdfsTestDirStr + "/copiedDir", TEST_ROOT_DIR};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"copyToLocal command should have succeeded", (long)0L, (long)res);
            LOG.info((Object)("Time taken by copyToLocal " + (System.currentTimeMillis() - startTime) / 1000L + " sec"));
        }
        finally {
            if (null != shell) {
                shell.close();
            }
            cluster.shutdown();
        }
    }

    private void createLocalDir(File base) throws IOException {
        int filesPerLevel = 100;
        base.mkdir();
        for (int i = 0; i < filesPerLevel; ++i) {
            File localFile = new File(base, "localFile" + i);
            BufferedWriter writer = new BufferedWriter(new FileWriter(localFile));
            writer.write(i + "");
            writer.close();
        }
        File localDir2 = new File(base, "localDirInternal");
        localDir2.mkdir();
        for (int i = 0; i < filesPerLevel; ++i) {
            File localFile = new File(localDir2, "localFile" + i);
            BufferedWriter writer = new BufferedWriter(new FileWriter(localFile));
            writer.write(i + "");
            writer.close();
        }
    }
}

