/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;

public class TestBpServiceActorScheduler {
    protected static final Log LOG = LogFactory.getLog(TestBpServiceActorScheduler.class);
    @Rule
    public Timeout timeout = new Timeout(300000);
    private static final long HEARTBEAT_INTERVAL_MS = 5000L;
    private final Random random = new Random(System.nanoTime());

    @Test
    public void testInit() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            Assert.assertTrue((boolean)scheduler.isHeartbeatDue(now));
        }
    }

    @Test
    public void testScheduleHeartbeat() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.scheduleNextHeartbeat();
            Assert.assertFalse((boolean)scheduler.isHeartbeatDue(now));
            scheduler.scheduleHeartbeat();
            Assert.assertTrue((boolean)scheduler.isHeartbeatDue(now));
        }
    }

    private BPServiceActor.Scheduler makeMockScheduler(long now) {
        LOG.info((Object)("Using now = " + now));
        BPServiceActor.Scheduler mockScheduler = (BPServiceActor.Scheduler)Mockito.spy((Object)new BPServiceActor.Scheduler(5000L));
        ((BPServiceActor.Scheduler)Mockito.doReturn((Object)now).when((Object)mockScheduler)).monotonicNow();
        mockScheduler.nextHeartbeatTime = now;
        return mockScheduler;
    }

    List<Long> getTimestamps() {
        return Arrays.asList(0L, Long.MIN_VALUE, Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL, Math.abs(this.random.nextLong()), -Math.abs(this.random.nextLong()));
    }
}

