/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSPermissionChecker {
    private static final long PREFERRED_BLOCK_SIZE = 0x8000000L;
    private static final short REPLICATION = 3;
    private static final String SUPERGROUP = "supergroup";
    private static final String SUPERUSER = "superuser";
    private static final UserGroupInformation BRUCE = UserGroupInformation.createUserForTesting((String)"bruce", (String[])new String[0]);
    private static final UserGroupInformation DIANA = UserGroupInformation.createUserForTesting((String)"diana", (String[])new String[]{"sales"});
    private static final UserGroupInformation CLARK = UserGroupInformation.createUserForTesting((String)"clark", (String[])new String[]{"execs"});
    private Configuration conf;
    private MiniDFSCluster cluster;

    @Before
    public void setUp() throws IOException {
        this.conf = new HdfsConfiguration();
        this.conf.setBoolean("dfs.namenode.acls.enabled", true);
        SimulatedFSDataset.setFactory(this.conf);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() throws IOException {
        this.cluster.getFileSystem().close();
        this.cluster.shutdown();
    }

    @Test
    public void testAclOwner() throws IOException {
        Path file1 = new Path("/file1");
        this.createINodeFile(file1, "bruce", "execs", (short)416);
        this.addAcl(file1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ);
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.WRITE);
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(BRUCE, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.EXECUTE);
    }

    @Test
    public void testAclNamedUser() throws IOException {
        Path file1 = new Path("/file1");
        this.createINodeFile(file1, "bruce", "execs", (short)416);
        this.addAcl(file1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.assertPermissionGranted(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclNamedUserDeny() throws IOException {
        Path file1 = new Path("/file1");
        this.createINodeFile(file1, "bruce", "execs", (short)420);
        this.addAcl(file1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ);
    }

    @Test
    public void testAclNamedUserTraverseDeny() throws IOException {
        Path dir1 = new Path("/dir1");
        this.createINodeDirectory(dir1, "bruce", "execs", (short)493);
        Path file1 = new Path(dir1, "file1");
        this.createINodeFile(file1, "bruce", "execs", (short)420);
        this.addAcl(dir1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ_EXECUTE));
        this.assertPermissionGranted(BRUCE, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.ALL);
    }

    @Test
    public void testAclNamedUserMask() throws IOException {
        Path file1 = new Path("/file1");
        this.createINodeFile(file1, "bruce", "execs", (short)400);
        this.addAcl(file1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclGroup() throws IOException {
        Path file1 = new Path("/file1");
        this.createINodeFile(file1, "bruce", "execs", (short)416);
        this.addAcl(file1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclGroupDeny() throws IOException {
        Path file1 = new Path("/file1");
        this.createINodeFile(file1, "bruce", "sales", (short)388);
        this.addAcl(file1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclGroupTraverseDeny() throws IOException {
        Path dir1 = new Path("/dir1");
        this.createINodeDirectory(dir1, "bruce", "execs", (short)493);
        Path file1 = new Path(dir1, "file1");
        this.createINodeFile(file1, "bruce", "execs", (short)420);
        this.addAcl(dir1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ_EXECUTE));
        this.assertPermissionGranted(BRUCE, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(DIANA, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.WRITE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.ALL);
    }

    @Test
    public void testAclGroupTraverseDenyOnlyDefaultEntries() throws IOException {
        Path dir1 = new Path("/dir1");
        this.createINodeDirectory(dir1, "bruce", "execs", (short)493);
        Path file1 = new Path(dir1, "file1");
        this.createINodeFile(file1, "bruce", "execs", (short)420);
        this.addAcl(dir1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "sales", FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.NONE));
        this.assertPermissionGranted(BRUCE, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.WRITE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.ALL);
    }

    @Test
    public void testAclGroupMask() throws IOException {
        Path file1 = new Path("/file1");
        this.createINodeFile(file1, "bruce", "execs", (short)420);
        this.addAcl(file1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclNamedGroup() throws IOException {
        Path file1 = new Path("/file1");
        this.createINodeFile(file1, "bruce", "execs", (short)416);
        this.addAcl(file1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionGranted(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclNamedGroupDeny() throws IOException {
        Path file1 = new Path("/file1");
        this.createINodeFile(file1, "bruce", "sales", (short)420);
        this.addAcl(file1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "execs", FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclNamedGroupTraverseDeny() throws IOException {
        Path dir1 = new Path("/dir1");
        this.createINodeDirectory(dir1, "bruce", "execs", (short)493);
        Path file1 = new Path(dir1, "file1");
        this.createINodeFile(file1, "bruce", "execs", (short)420);
        this.addAcl(dir1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ_EXECUTE));
        this.assertPermissionGranted(BRUCE, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.ALL);
    }

    @Test
    public void testAclNamedGroupMask() throws IOException {
        Path file1 = new Path("/file1");
        this.createINodeFile(file1, "bruce", "execs", (short)420);
        this.addAcl(file1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionGranted(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclOther() throws IOException {
        Path file1 = new Path("/file1");
        this.createINodeFile(file1, "bruce", "sales", (short)508);
        this.addAcl(file1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.ALL);
        this.assertPermissionGranted(DIANA, "/file1", FsAction.ALL);
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.ALL);
    }

    @Test
    public void testInheritDefault() throws IOException {
        Path dir1 = new Path("/dir1");
        this.createINodeDirectory(dir1, "bruce", "sales", (short)504);
        Path file1 = new Path(dir1, "file1");
        this.createINodeFile(file1, "bruce", "sales", (short)504);
        this.addAcl(dir1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "clark", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "execs", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "execs", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.NONE));
        this.assertPermissionGranted(CLARK, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.WRITE);
    }

    @Test
    public void testInheritDefaultDeep() throws IOException {
        Path dir1 = new Path("/dir1");
        this.createINodeDirectory(dir1, "bruce", "sales", (short)504);
        Path dir2 = new Path(dir1, "dir2");
        this.createINodeDirectory(dir2, "bruce", "sales", (short)504);
        Path file1 = new Path(dir2, "file1");
        this.createINodeFile(file1, "bruce", "sales", (short)504);
        this.addAcl(dir1, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "clark", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "execs", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "execs", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.NONE));
        this.addAcl(dir2, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "clark", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "execs", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "execs", FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.READ));
        this.assertPermissionDenied(CLARK, "/dir1/dir2/file1", FsAction.READ);
        this.assertPermissionGranted(DIANA, "/dir1/dir2/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/dir1/dir2/file1", FsAction.WRITE);
    }

    @Test
    public void testInheritedBlockedByIntermediateDefault() throws IOException {
    }

    private void addAcl(final Path src, final AclEntry ... acl) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.SET_ACL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, new String[]{src.toString()}).setNameNodeID(TestFSPermissionChecker.this.cluster.getNameNode().getId()).setActiveNameNodes((Collection)TestFSPermissionChecker.this.cluster.getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                INode inode = TestFSPermissionChecker.this.cluster.getNamesystem().getINode(src.toString());
                AclStorage.updateINodeAcl((INode)inode, Arrays.asList(acl));
                return null;
            }
        }.handle();
    }

    private void assertPermissionGranted(final UserGroupInformation user, final String path, final FsAction access) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.CHECK_ACCESS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, new String[]{path}).setNameNodeID(TestFSPermissionChecker.this.cluster.getNameNode().getId()).setActiveNameNodes((Collection)TestFSPermissionChecker.this.cluster.getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSDirectory dir = TestFSPermissionChecker.this.cluster.getNamesystem().getFSDirectory();
                INodesInPath iip = dir.getINodesInPath(path, true);
                new FSPermissionChecker(TestFSPermissionChecker.SUPERUSER, TestFSPermissionChecker.SUPERGROUP, user).checkPermission(iip, false, null, null, access, null, false);
                return null;
            }
        }.handle();
    }

    private void assertPermissionDenied(final UserGroupInformation user, final String path, final FsAction access) throws IOException {
        try {
            new HopsTransactionalRequestHandler(HDFSOperationType.CHECK_ACCESS){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, new String[]{path}).setNameNodeID(TestFSPermissionChecker.this.cluster.getNameNode().getId()).setActiveNameNodes((Collection)TestFSPermissionChecker.this.cluster.getNameNode().getActiveNameNodes().getActiveNodes());
                    locks.add((Lock)il);
                    locks.add(lf.getAcesLock());
                }

                public Object performTask() throws IOException {
                    FSDirectory dir = TestFSPermissionChecker.this.cluster.getNamesystem().getFSDirectory();
                    INodesInPath iip = dir.getINodesInPath(path, true);
                    new FSPermissionChecker(TestFSPermissionChecker.SUPERUSER, TestFSPermissionChecker.SUPERGROUP, user).checkPermission(iip, false, null, null, access, null, false);
                    return null;
                }
            }.handle();
            Assert.fail((String)("expected AccessControlException for user + " + user + ", path = " + path + ", access = " + access));
        }
        catch (AccessControlException e) {
            Assert.assertTrue((String)"Permission denied messages must carry the username", (boolean)e.getMessage().contains(user.getUserName().toString()));
        }
    }

    private void createINodeDirectory(Path src, String owner, String group, short perm) throws IOException {
        PermissionStatus permStatus = PermissionStatus.createImmutable((String)owner, (String)group, (FsPermission)FsPermission.createImmutable((short)perm));
        this.cluster.getNamesystem().mkdirs(src.toString(), permStatus, false);
        this.cluster.getNamesystem().setOwner(src.toString(), owner, group);
        this.cluster.getNamesystem().setPermission(src.toString(), FsPermission.createImmutable((short)perm));
    }

    private void createINodeFile(Path src, String owner, String group, short perm) throws IOException {
        DFSTestUtil.createFile((FileSystem)this.cluster.getFileSystem(), src, 0L, (short)1, 0L);
        this.cluster.getNamesystem().setOwner(src.toString(), owner, group);
        this.cluster.getNamesystem().setPermission(src.toString(), FsPermission.createImmutable((short)perm));
    }
}

