/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQuotaByStorageType {
    private static final int BLOCKSIZE = 1024;
    private static final short REPLICATION = 3;
    private static final long seed = 0L;
    private static final Path dir = new Path("/TestQuotaByStorageType");
    private Configuration conf;
    private MiniDFSCluster cluster;
    private FSDirectory fsdir;
    private DistributedFileSystem dfs;
    private FSNamesystem fsn;
    private int leaseCreationLockRows;
    protected static final Log LOG = LogFactory.getLog(TestQuotaByStorageType.class);

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        this.leaseCreationLockRows = this.conf.getInt("dfs.lease.creation.locks.count.key", 1000);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).storageTypes(new StorageType[]{StorageType.SSD, StorageType.DEFAULT}).build();
        this.cluster.waitActive();
        this.fsdir = this.cluster.getNamesystem().getFSDirectory();
        this.dfs = this.cluster.getFileSystem();
        this.fsn = this.cluster.getNamesystem();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeWithFileCreateOneSSD() throws Exception {
        this.testQuotaByStorageTypeWithFileCreateCase("ONE_SSD", StorageType.SSD, (short)1);
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeWithFileCreateAllSSD() throws Exception {
        this.testQuotaByStorageTypeWithFileCreateCase("ALL_SSD", StorageType.SSD, (short)3);
    }

    void testQuotaByStorageTypeWithFileCreateCase(String storagePolicy, StorageType storageType, short replication) throws Exception {
        Path foo = new Path(dir, "foo");
        Path createdFile1 = new Path(foo, "created_file1.data");
        this.dfs.mkdirs(foo);
        this.dfs.setStoragePolicy(foo, storagePolicy);
        this.dfs.setQuotaByStorageType(foo, storageType, 10240L);
        INodeDirectory fnode = this.getINode4Write(foo);
        long file1Len = 2560L;
        int bufLen = 64;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile1, bufLen, file1Len, 1024L, (short)3, 0L);
        Thread.sleep(1000L);
        long storageTypeConsumed = this.getSpaceConsumed(foo).getTypeSpaces().get((Enum)storageType);
        Assert.assertEquals((long)(file1Len * (long)replication), (long)storageTypeConsumed);
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeWithFileCreateAppend() throws Exception {
        Path foo = new Path(dir, "foo");
        Path createdFile1 = new Path(foo, "created_file1.data");
        this.dfs.mkdirs(foo);
        this.dfs.setStoragePolicy(foo, "ONE_SSD");
        this.dfs.setQuotaByStorageType(foo, StorageType.SSD, 4096L);
        INodeDirectory fnode = this.getINode4Write(foo);
        long file1Len = 2048L;
        int bufLen = 64;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile1, bufLen, file1Len, 1024L, (short)3, 0L);
        Thread.sleep(1000L);
        long ssdConsumed = this.getSpaceConsumed(foo).getTypeSpaces().get((Enum)StorageType.SSD);
        Assert.assertEquals((long)file1Len, (long)ssdConsumed);
        int appendLen = 2048;
        DFSTestUtil.appendFile((FileSystem)this.dfs, createdFile1, appendLen);
        Thread.sleep(1000L);
        ssdConsumed = this.getSpaceConsumed(foo).getTypeSpaces().get((Enum)StorageType.SSD);
        Assert.assertEquals((long)(file1Len += (long)appendLen), (long)ssdConsumed);
        ContentSummary cs = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)cs.getSpaceConsumed(), (long)(file1Len * 3L));
        Assert.assertEquals((long)cs.getTypeConsumed(StorageType.SSD), (long)file1Len);
        Assert.assertEquals((long)cs.getTypeConsumed(StorageType.DISK), (long)(file1Len * 2L));
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeWithFileCreateDelete() throws Exception {
        Path foo = new Path(dir, "foo");
        Path createdFile1 = new Path(foo, "created_file1.data");
        this.dfs.mkdirs(foo);
        this.dfs.setStoragePolicy(foo, "ONE_SSD");
        this.dfs.setQuotaByStorageType(foo, StorageType.SSD, 10240L);
        INodeDirectory fnode = this.getINode4Write(foo);
        long file1Len = 2560L;
        int bufLen = 64;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile1, bufLen, file1Len, 1024L, (short)3, 0L);
        Thread.sleep(1000L);
        long storageTypeConsumed = this.getSpaceConsumed(foo).getTypeSpaces().get((Enum)StorageType.SSD);
        Assert.assertEquals((long)file1Len, (long)storageTypeConsumed);
        this.dfs.delete(createdFile1, false);
        Thread.sleep(1000L);
        storageTypeConsumed = this.getSpaceConsumed(foo).getTypeSpaces().get((Enum)StorageType.SSD);
        Assert.assertEquals((long)0L, (long)storageTypeConsumed);
        QuotaCounts counts = this.computeQuotaUsage(foo);
        String subTree = this.dumpTreeRecursively(foo);
        Assert.assertEquals((String)subTree, (long)0L, (long)counts.getTypeSpaces().get((Enum)StorageType.SSD));
        ContentSummary cs = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)cs.getSpaceConsumed(), (long)0L);
        Assert.assertEquals((long)cs.getTypeConsumed(StorageType.SSD), (long)0L);
        Assert.assertEquals((long)cs.getTypeConsumed(StorageType.DISK), (long)0L);
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeWithFileCreateRename() throws Exception {
        Path foo = new Path(dir, "foo");
        this.dfs.mkdirs(foo);
        Path createdFile1foo = new Path(foo, "created_file1.data");
        Path bar = new Path(dir, "bar");
        this.dfs.mkdirs(bar);
        Path createdFile1bar = new Path(bar, "created_file1.data");
        this.dfs.setStoragePolicy(foo, "ONE_SSD");
        this.dfs.setStoragePolicy(bar, "ONE_SSD");
        this.dfs.setQuotaByStorageType(foo, StorageType.SSD, 4096L);
        this.dfs.setQuotaByStorageType(bar, StorageType.SSD, 2048L);
        INodeDirectory fnode = this.getINode4Write(foo);
        long file1Len = 3072L;
        int bufLen = 64;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile1foo, bufLen, file1Len, 1024L, (short)3, 0L);
        Thread.sleep(1000L);
        long ssdConsumed = this.getSpaceConsumed(foo).getTypeSpaces().get((Enum)StorageType.SSD);
        Assert.assertEquals((long)file1Len, (long)ssdConsumed);
        try {
            this.dfs.rename(createdFile1foo, createdFile1bar);
            Assert.fail((String)"Should have failed with QuotaByStorageTypeExceededException ");
        }
        catch (Throwable t) {
            LOG.info((Object)"Got expected exception ", t);
        }
        ContentSummary cs = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)cs.getSpaceConsumed(), (long)(file1Len * 3L));
        Assert.assertEquals((long)cs.getTypeConsumed(StorageType.SSD), (long)file1Len);
        Assert.assertEquals((long)cs.getTypeConsumed(StorageType.DISK), (long)(file1Len * 2L));
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeExceptionWithFileCreate() throws Exception {
        Path foo = new Path(dir, "foo");
        Path createdFile1 = new Path(foo, "created_file1.data");
        this.dfs.mkdirs(foo);
        this.dfs.setStoragePolicy(foo, "ONE_SSD");
        this.dfs.setQuotaByStorageType(foo, StorageType.SSD, 4096L);
        INodeDirectory fnode = this.getINode4Write(foo);
        long file1Len = 2048L;
        int bufLen = 64;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile1, bufLen, file1Len, 1024L, (short)3, 0L);
        Thread.sleep(1000L);
        long currentSSDConsumed = this.getSpaceConsumed(foo).getTypeSpaces().get((Enum)StorageType.SSD);
        Assert.assertEquals((long)file1Len, (long)currentSSDConsumed);
        Path createdFile2 = new Path(foo, "created_file2.data");
        long file2Len = 1536L;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile2, bufLen, file2Len, 1024L, (short)3, 0L);
        Thread.sleep(1000L);
        currentSSDConsumed = this.getSpaceConsumed(foo).getTypeSpaces().get((Enum)StorageType.SSD);
        Assert.assertEquals((long)(file1Len + file2Len), (long)currentSSDConsumed);
        Path createdFile3 = new Path(foo, "created_file3.data");
        long file3Len = 1024L;
        try {
            DFSTestUtil.createFile((FileSystem)this.dfs, createdFile3, bufLen, file3Len, 1024L, (short)3, 0L);
            Assert.fail((String)"Should have failed with QuotaByStorageTypeExceededException ");
        }
        catch (Throwable t) {
            LOG.info((Object)"Got expected exception ", t);
            Thread.sleep(1000L);
            currentSSDConsumed = this.getSpaceConsumed(foo).getTypeSpaces().get((Enum)StorageType.SSD);
            Assert.assertEquals((long)(file1Len + file2Len), (long)currentSSDConsumed);
        }
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeParentOffChildOff() throws Exception {
        Path parent = new Path(dir, "parent");
        Path child = new Path(parent, "child");
        this.dfs.mkdirs(parent);
        this.dfs.mkdirs(child);
        this.dfs.setStoragePolicy(parent, "ONE_SSD");
        Path createdFile1 = new Path(child, "created_file1.data");
        long file1Len = 2560L;
        int bufLen = 64;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile1, bufLen, file1Len, 1024L, (short)3, 0L);
        Thread.sleep(5000L);
        long ssdConsumed = this.getSpaceConsumed(new Path("/")).getTypeSpaces().get((Enum)StorageType.SSD);
        Assert.assertEquals((long)file1Len, (long)ssdConsumed);
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeParentOffChildOn() throws Exception {
        Path parent = new Path(dir, "parent");
        Path child = new Path(parent, "child");
        this.dfs.mkdirs(parent);
        this.dfs.mkdirs(child);
        this.dfs.setStoragePolicy(parent, "ONE_SSD");
        this.dfs.setQuotaByStorageType(child, StorageType.SSD, 2048L);
        Path createdFile1 = new Path(child, "created_file1.data");
        long file1Len = 2560L;
        int bufLen = 64;
        try {
            DFSTestUtil.createFile((FileSystem)this.dfs, createdFile1, bufLen, file1Len, 1024L, (short)3, 0L);
            Assert.fail((String)"Should have failed with QuotaByStorageTypeExceededException ");
        }
        catch (Throwable t) {
            LOG.info((Object)"Got expected exception ", t);
        }
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeParentOnChildOff() throws Exception {
        short replication = 1;
        Path parent = new Path(dir, "parent");
        Path child = new Path(parent, "child");
        this.dfs.mkdirs(parent);
        this.dfs.mkdirs(child);
        this.dfs.setStoragePolicy(parent, "ONE_SSD");
        this.dfs.setQuotaByStorageType(parent, StorageType.SSD, 3072L);
        Path createdFile1 = new Path(child, "created_file1.data");
        long file1Len = 2560L;
        int bufLen = 64;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile1, bufLen, file1Len, 1024L, replication, 0L);
        Thread.sleep(5000L);
        INodeDirectory fnode = this.getINode4Write(parent);
        long currentSSDConsumed = this.getSpaceConsumed(parent).getTypeSpaces().get((Enum)StorageType.SSD);
        Assert.assertEquals((long)file1Len, (long)currentSSDConsumed);
        Path createdFile2 = new Path(child, "created_file2.data");
        long file2Len = 1024L;
        try {
            DFSTestUtil.createFile((FileSystem)this.dfs, createdFile2, bufLen, file2Len, 1024L, replication, 0L);
            Assert.fail((String)"Should have failed with QuotaByStorageTypeExceededException ");
        }
        catch (Throwable t) {
            LOG.info((Object)"Got expected exception ", t);
            Thread.sleep(5000L);
            currentSSDConsumed = this.getSpaceConsumed(parent).getTypeSpaces().get((Enum)StorageType.SSD);
            Assert.assertEquals((long)file1Len, (long)currentSSDConsumed);
        }
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeParentOnChildOn() throws Exception {
        Path parent = new Path(dir, "parent");
        Path child = new Path(parent, "child");
        this.dfs.mkdirs(parent);
        this.dfs.mkdirs(child);
        this.dfs.setStoragePolicy(parent, "ONE_SSD");
        this.dfs.setQuotaByStorageType(parent, StorageType.SSD, 2048L);
        this.dfs.setQuotaByStorageType(child, StorageType.SSD, 3072L);
        Path createdFile1 = new Path(child, "created_file1.data");
        long file1Len = 2560L;
        int bufLen = 64;
        try {
            DFSTestUtil.createFile((FileSystem)this.dfs, createdFile1, bufLen, file1Len, 1024L, (short)3, 0L);
            Assert.fail((String)"Should have failed with QuotaByStorageTypeExceededException ");
        }
        catch (Throwable t) {
            LOG.info((Object)"Got expected exception ", t);
        }
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeWithTraditionalQuota() throws Exception {
        Path foo = new Path(dir, "foo");
        this.dfs.mkdirs(foo);
        this.dfs.setStoragePolicy(foo, "ONE_SSD");
        this.dfs.setQuotaByStorageType(foo, StorageType.SSD, 10240L);
        this.dfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 30720L);
        INodeDirectory fnode = this.getINode4Write(foo);
        Path createdFile = new Path(foo, "created_file.data");
        long fileLen = 2560L;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile, 64, fileLen, 1024L, (short)3, 0L);
        Thread.sleep(1000L);
        QuotaCounts cnt = this.getSpaceConsumed(foo);
        Assert.assertEquals((long)2L, (long)cnt.getNameSpace());
        Assert.assertEquals((long)(fileLen * 3L), (long)cnt.getStorageSpace());
        this.dfs.delete(createdFile, true);
        Thread.sleep(1000L);
        QuotaCounts cntAfterDelete = this.getSpaceConsumed(foo);
        Assert.assertEquals((long)1L, (long)cntAfterDelete.getNameSpace());
        Assert.assertEquals((long)0L, (long)cntAfterDelete.getStorageSpace());
        QuotaCounts counts = this.computeQuotaUsage(foo);
        String subtree = this.dumpTreeRecursively(foo);
        Assert.assertEquals((String)subtree, (long)1L, (long)counts.getNameSpace());
        Assert.assertEquals((String)subtree, (long)0L, (long)counts.getStorageSpace());
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeAndTraditionalQuotaException1() throws Exception {
        this.testQuotaByStorageTypeOrTraditionalQuotaExceededCase(12L, 4L, 5L, (short)3);
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeAndTraditionalQuotaException2() throws Exception {
        this.testQuotaByStorageTypeOrTraditionalQuotaExceededCase(15L, 4L, 5L, (short)3);
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeAndTraditionalQuotaException3() throws Exception {
        this.testQuotaByStorageTypeOrTraditionalQuotaExceededCase(12L, 5L, 5L, (short)3);
    }

    private void testQuotaByStorageTypeOrTraditionalQuotaExceededCase(long storageSpaceQuotaInBlocks, long ssdQuotaInBlocks, long testFileLenInBlocks, short replication) throws Exception {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path testDir = new Path(dir, METHOD_NAME);
        this.dfs.mkdirs(testDir);
        this.dfs.setStoragePolicy(testDir, "ONE_SSD");
        long ssdQuota = 1024L * ssdQuotaInBlocks;
        long storageSpaceQuota = 1024L * storageSpaceQuotaInBlocks;
        this.dfs.setQuota(testDir, 0x7FFFFFFFFFFFFFFEL, storageSpaceQuota);
        this.dfs.setQuotaByStorageType(testDir, StorageType.SSD, ssdQuota);
        INodeDirectory testDirNode = this.getINode4Write(testDir);
        Path createdFile = new Path(testDir, "created_file.data");
        long fileLen = testFileLenInBlocks * 1024L;
        try {
            DFSTestUtil.createFile((FileSystem)this.dfs, createdFile, 64, fileLen, 1024L, replication, 0L);
            Thread.sleep(1000L);
            Path createdFile2 = new Path(testDir, "created_file2.data");
            DFSTestUtil.createFile((FileSystem)this.dfs, createdFile2, 64, fileLen, 1024L, replication, 0L);
            Assert.fail((String)"Should have failed with DSQuotaExceededException or QuotaByStorageTypeExceededException ");
        }
        catch (Throwable t) {
            LOG.info((Object)"Got expected exception ", t);
            Thread.sleep(5000L);
            long currentSSDConsumed = this.getSpaceConsumed(testDir).getTypeSpaces().get((Enum)StorageType.SSD);
            Assert.assertTrue((String)("SSD consumed to high " + currentSSDConsumed), (fileLen >= currentSSDConsumed ? 1 : 0) != 0);
        }
    }

    @Test(timeout=60000L)
    public void testQuotaByStorageTypeWithFileCreateTruncate() throws Exception {
        Path foo = new Path(dir, "foo");
        Path createdFile1 = new Path(foo, "created_file1.data");
        this.dfs.mkdirs(foo);
        this.dfs.setStoragePolicy(foo, "ONE_SSD");
        this.dfs.setQuotaByStorageType(foo, StorageType.SSD, 4096L);
        INodeDirectory fnode = this.getINode4Write(foo);
        long file1Len = 2048L;
        int bufLen = 64;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile1, bufLen, file1Len, 1024L, (short)3, 0L);
        Thread.sleep(1000L);
        long ssdConsumed = this.getSpaceConsumed(foo).getTypeSpaces().get((Enum)StorageType.SSD);
        Assert.assertEquals((long)file1Len, (long)ssdConsumed);
        int newFile1Len = 1024;
        this.dfs.truncate(createdFile1, (long)newFile1Len);
        Thread.sleep(1000L);
        ssdConsumed = this.getSpaceConsumed(foo).getTypeSpaces().get((Enum)StorageType.SSD);
        Assert.assertEquals((long)newFile1Len, (long)ssdConsumed);
        ContentSummary cs = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)cs.getSpaceConsumed(), (long)(newFile1Len * 3));
        Assert.assertEquals((long)cs.getTypeConsumed(StorageType.SSD), (long)newFile1Len);
        Assert.assertEquals((long)cs.getTypeConsumed(StorageType.DISK), (long)(newFile1Len * 2));
    }

    INodeDirectory getINode4Write(Path foo) throws IOException {
        return this.getINode4Write(foo, true);
    }

    INodeDirectory getINode4Write(final Path foo, final boolean isQuotaset) throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, new String[]{foo.toString()});
                locks.add((Lock)il).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.READ, TestQuotaByStorageType.this.leaseCreationLockRows)).add(lf.getLeasePathLock(foo.toString())).add(lf.getBlockLock()).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR}));
            }

            public Object performTask() throws IOException {
                INodeDirectory fnode = TestQuotaByStorageType.this.fsdir.getINode4Write(foo.toString()).asDirectory();
                Assert.assertTrue((boolean)fnode.isDirectory());
                Assert.assertTrue((fnode.isQuotaSet() == isQuotaset ? 1 : 0) != 0);
                return fnode;
            }
        };
        return (INodeDirectory)handler.handle();
    }

    QuotaCounts getSpaceConsumed(final Path foo) throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, new String[]{foo.toString()});
                locks.add((Lock)il).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.READ, TestQuotaByStorageType.this.leaseCreationLockRows)).add(lf.getLeasePathLock(foo.toString())).add(lf.getBlockLock()).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR}));
            }

            public Object performTask() throws IOException {
                INodeDirectory fooNode = TestQuotaByStorageType.this.fsdir.getINode4Write(foo.toString()).asDirectory();
                Assert.assertTrue((boolean)fooNode.isQuotaSet());
                return fooNode.getDirectoryWithQuotaFeature().getSpaceConsumed();
            }
        };
        return (QuotaCounts)handler.handle();
    }

    QuotaCounts computeQuotaUsage(final Path foo) throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY, new String[]{foo.toString()});
                locks.add((Lock)il).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.READ, TestQuotaByStorageType.this.leaseCreationLockRows)).add(lf.getLeasePathLock(foo.toString())).add(lf.getBlockLock()).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR}));
            }

            public Object performTask() throws IOException {
                INodeDirectory fnode = TestQuotaByStorageType.this.fsdir.getINode4Write(foo.toString()).asDirectory();
                QuotaCounts counts = new QuotaCounts.Builder().build();
                fnode.computeQuotaUsage(TestQuotaByStorageType.this.fsn.getBlockManager().getStoragePolicySuite(), counts);
                return counts;
            }
        };
        return (QuotaCounts)handler.handle();
    }

    String dumpTreeRecursively(final Path foo) throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY, new String[]{foo.toString()});
                locks.add((Lock)il).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.READ, TestQuotaByStorageType.this.leaseCreationLockRows)).add(lf.getLeasePathLock(foo.toString())).add(lf.getBlockLock()).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR}));
            }

            public Object performTask() throws IOException {
                INodeDirectory fnode = TestQuotaByStorageType.this.fsdir.getINode4Write(foo.toString()).asDirectory();
                return fnode.dumpTreeRecursively().toString();
            }
        };
        return (String)handler.handle();
    }

    @Test(timeout=60000L)
    public void testContentSummaryWithoutQuotaByStorageType() throws Exception {
        Path foo = new Path(dir, "foo");
        Path createdFile1 = new Path(foo, "created_file1.data");
        this.dfs.mkdirs(foo);
        this.dfs.setStoragePolicy(foo, "ONE_SSD");
        INodeDirectory fnode = this.getINode4Write(foo, false);
        long file1Len = 2048L;
        int bufLen = 64;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile1, bufLen, file1Len, 1024L, (short)3, 0L);
        ContentSummary cs = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)cs.getSpaceConsumed(), (long)(file1Len * 3L));
        Assert.assertEquals((long)cs.getTypeConsumed(StorageType.SSD), (long)file1Len);
        Assert.assertEquals((long)cs.getTypeConsumed(StorageType.DISK), (long)(file1Len * 2L));
    }

    @Test(timeout=60000L)
    public void testContentSummaryWithoutStoragePolicy() throws Exception {
        Path foo = new Path(dir, "foo");
        Path createdFile1 = new Path(foo, "created_file1.data");
        this.dfs.mkdirs(foo);
        INodeDirectory fnode = this.getINode4Write(foo, false);
        long file1Len = 2048L;
        int bufLen = 64;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile1, bufLen, file1Len, 1024L, (short)3, 0L);
        ContentSummary cs = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)cs.getSpaceConsumed(), (long)(file1Len * 3L));
        for (StorageType t : StorageType.values()) {
            Assert.assertEquals((long)cs.getTypeConsumed(t), (long)0L);
            Assert.assertEquals((long)cs.getTypeQuota(t), (long)-1L);
        }
    }
}

