/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public abstract class BasicClusterTestCase
extends TestCase {
    protected static final int DFS_TEST_BLOCK_SIZE = 4096;
    private MiniDFSCluster cluster;
    private DistributedFileSystem dfs;
    private Configuration conf;

    protected BasicClusterTestCase() {
        this((Configuration)new HdfsConfiguration());
        this.conf.setLong("dfs.blocksize", 4096L);
        this.conf.setInt("dfs.replication", 3);
        this.conf.setBoolean("dfs.erasure_coding.enabled", true);
        this.conf.setInt("dfs.erasure_coding.recheck_interval", 10000);
    }

    protected BasicClusterTestCase(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setUp() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.getConf()).numDataNodes(this.getConf().getInt("dfs.replication", 3)).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem();
    }

    public void tearDown() throws Exception {
        FileStatus[] files;
        for (FileStatus file : files = this.dfs.globStatus(new Path("/*"))) {
            this.dfs.delete(file.getPath(), true);
        }
        this.dfs.close();
        this.cluster.shutdown();
    }

    public DistributedFileSystem getDfs() {
        return this.dfs;
    }

    public MiniDFSCluster getCluster() {
        return this.cluster;
    }
}

