/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceNotFoundException;
import com.logicalclocks.servicediscoverclient.resolvers.DnsResolver;
import com.logicalclocks.servicediscoverclient.service.Service;
import com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import io.hops.net.ServiceDiscoveryClientFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDFSUtil {
    @Before
    public void resetUGI() {
        UserGroupInformation.setConfiguration((Configuration)new Configuration());
    }

    @Test
    public void testLocatedBlocks2Locations() {
        DatanodeInfo d = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] ds = new DatanodeInfo[]{d};
        ExtendedBlock b1 = new ExtendedBlock("bpid", 1L, 1L, 1L);
        LocatedBlock l1 = new LocatedBlock(b1, ds);
        l1.setStartOffset(0L);
        l1.setCorrupt(false);
        ExtendedBlock b2 = new ExtendedBlock("bpid", 2L, 1L, 1L);
        LocatedBlock l2 = new LocatedBlock(b2, ds);
        l2.setStartOffset(0L);
        l2.setCorrupt(true);
        List<LocatedBlock> ls = Arrays.asList(l1, l2);
        LocatedBlocks lbs = new LocatedBlocks(10L, false, ls, l2, true, null);
        BlockLocation[] bs = DFSUtilClient.locatedBlocks2Locations((LocatedBlocks)lbs);
        Assert.assertTrue((String)("expected 2 blocks but got " + bs.length), (bs.length == 2 ? 1 : 0) != 0);
        int corruptCount = 0;
        for (BlockLocation b : bs) {
            if (!b.isCorrupt()) continue;
            ++corruptCount;
        }
        Assert.assertTrue((String)("expected 1 corrupt files but got " + corruptCount), (corruptCount == 1 ? 1 : 0) != 0);
        bs = DFSUtilClient.locatedBlocks2Locations((LocatedBlocks)new LocatedBlocks());
        Assert.assertEquals((long)0L, (long)bs.length);
    }

    @Test
    public void testLocatedBlockConstructorWithNullCachedLocs() {
        DatanodeInfo d = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] ds = new DatanodeInfo[]{d};
        ExtendedBlock b1 = new ExtendedBlock("bpid", 1L, 1L, 1L);
        LocatedBlock l1 = new LocatedBlock(b1, ds, null, null, 0L, false, null);
        DatanodeInfo[] cachedLocs = l1.getCachedLocations();
        Assert.assertTrue((cachedLocs.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetInfoServer() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        URI httpsport = DFSUtil.getInfoServer(null, (Configuration)conf, (String)"https");
        Assert.assertEquals((Object)new URI("https", null, "0.0.0.0", 50470, null, null, null), (Object)httpsport);
        URI httpport = DFSUtil.getInfoServer(null, (Configuration)conf, (String)"http");
        Assert.assertEquals((Object)new URI("http", null, "0.0.0.0", 50070, null, null, null), (Object)httpport);
        URI httpAddress = DFSUtil.getInfoServer((InetSocketAddress)new InetSocketAddress("localhost", 8020), (Configuration)conf, (String)"http");
        Assert.assertEquals((Object)URI.create("http://localhost:50070"), (Object)httpAddress);
    }

    @Test
    public void testSubstituteForWildcardAddress() throws IOException {
        Assert.assertEquals((Object)"foo:12345", (Object)DFSUtil.substituteForWildcardAddress((String)"0.0.0.0:12345", (String)"foo"));
        Assert.assertEquals((Object)"127.0.0.1:12345", (Object)DFSUtil.substituteForWildcardAddress((String)"127.0.0.1:12345", (String)"foo"));
    }

    @Test(timeout=15000L)
    public void testIsValidName() {
        Assert.assertFalse((boolean)DFSUtil.isValidName((String)"/foo/../bar"));
        Assert.assertFalse((boolean)DFSUtil.isValidName((String)"/foo//bar"));
        Assert.assertTrue((boolean)DFSUtil.isValidName((String)"/"));
        Assert.assertTrue((boolean)DFSUtil.isValidName((String)"/bar/"));
    }

    @Test(timeout=5000L)
    public void testGetSpnegoKeytabKey() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String defaultKey = "default.spengo.key";
        conf.unset("dfs.web.authentication.kerberos.keytab");
        Assert.assertEquals((String)"Test spnego key in config is null", (Object)defaultKey, (Object)DFSUtil.getSpnegoKeytabKey((Configuration)conf, (String)defaultKey));
        conf.set("dfs.web.authentication.kerberos.keytab", "");
        Assert.assertEquals((String)"Test spnego key is empty", (Object)defaultKey, (Object)DFSUtil.getSpnegoKeytabKey((Configuration)conf, (String)defaultKey));
        String spengoKey = "spengo.key";
        conf.set("dfs.web.authentication.kerberos.keytab", spengoKey);
        Assert.assertEquals((String)"Test spnego key is NOT null", (Object)"dfs.web.authentication.kerberos.keytab", (Object)DFSUtil.getSpnegoKeytabKey((Configuration)conf, (String)defaultKey));
    }

    @Test(timeout=1000L)
    public void testDurationToString() throws Exception {
        Assert.assertEquals((Object)"000:00:00:00.000", (Object)DFSUtil.durationToString((long)0L));
        Assert.assertEquals((Object)"001:01:01:01.000", (Object)DFSUtil.durationToString((long)90061000L));
        Assert.assertEquals((Object)"000:23:59:59.999", (Object)DFSUtil.durationToString((long)86399999L));
        Assert.assertEquals((Object)"-001:01:01:01.000", (Object)DFSUtil.durationToString((long)-90061000L));
        Assert.assertEquals((Object)"-000:23:59:59.574", (Object)DFSUtil.durationToString((long)-86399574L));
    }

    @Test(timeout=5000L)
    public void testRelativeTimeConversion() throws Exception {
        try {
            DFSUtil.parseRelativeTime((String)"1");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"too short", (Throwable)e);
        }
        try {
            DFSUtil.parseRelativeTime((String)"1z");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"unknown time unit", (Throwable)e);
        }
        try {
            DFSUtil.parseRelativeTime((String)"yyz");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"is not a number", (Throwable)e);
        }
        Assert.assertEquals((long)61000L, (long)DFSUtil.parseRelativeTime((String)"61s"));
        Assert.assertEquals((long)3660000L, (long)DFSUtil.parseRelativeTime((String)"61m"));
        Assert.assertEquals((long)0L, (long)DFSUtil.parseRelativeTime((String)"0s"));
        Assert.assertEquals((long)90000000L, (long)DFSUtil.parseRelativeTime((String)"25h"));
        Assert.assertEquals((long)345600000L, (long)DFSUtil.parseRelativeTime((String)"4d"));
        Assert.assertEquals((long)86313600000L, (long)DFSUtil.parseRelativeTime((String)"999d"));
    }

    @Test
    public void testGetPassword() throws Exception {
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        Configuration conf = new Configuration();
        Path jksPath = new Path(testDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(testDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] keypass = new char[]{'k', 'e', 'y', 'p', 'a', 's', 's'};
        char[] storepass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'a', 's', 's'};
        char[] trustpass = new char[]{'t', 'r', 'u', 's', 't', 'p', 'a', 's', 's'};
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("ssl.server.keystore.keypassword"));
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("ssl.server.keystore.password"));
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("ssl.server.truststore.password"));
        try {
            provider.createCredentialEntry("ssl.server.keystore.keypassword", keypass);
            provider.createCredentialEntry("ssl.server.keystore.password", storepass);
            provider.createCredentialEntry("ssl.server.truststore.password", trustpass);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        Assert.assertArrayEquals((char[])keypass, (char[])provider.getCredentialEntry("ssl.server.keystore.keypassword").getCredential());
        Assert.assertArrayEquals((char[])storepass, (char[])provider.getCredentialEntry("ssl.server.keystore.password").getCredential());
        Assert.assertArrayEquals((char[])trustpass, (char[])provider.getCredentialEntry("ssl.server.truststore.password").getCredential());
        Assert.assertEquals((Object)"keypass", (Object)DFSUtil.getPassword((Configuration)conf, (String)"ssl.server.keystore.keypassword"));
        Assert.assertEquals((Object)"storepass", (Object)DFSUtil.getPassword((Configuration)conf, (String)"ssl.server.keystore.password"));
        Assert.assertEquals((Object)"trustpass", (Object)DFSUtil.getPassword((Configuration)conf, (String)"ssl.server.truststore.password"));
        Assert.assertEquals(null, (Object)DFSUtil.getPassword((Configuration)conf, (String)"invalid-alias"));
    }

    @Test
    public void testNamenodeURIsFromServiceDiscovery() throws Exception {
        HashSet nns = Sets.newHashSet((Object[])new Service[]{Service.of((String)"namenode.service.consul", (String)"10.0.0.1", (Integer)8020), Service.of((String)"namenode.service.consul", (String)"10.0.0.2", (Integer)8020), Service.of((String)"namenode.service.consul", (String)"10.0.0.1", (Integer)50470), Service.of((String)"namenode.service.consul", (String)"10.0.0.2", (Integer)50470)});
        ArrayList expected = Lists.newArrayList((Object[])new InetSocketAddress[]{new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 8020), new InetSocketAddress(InetAddress.getByName("10.0.0.2"), 8020)});
        DnsResolver dnsResolver = (DnsResolver)Mockito.mock(DnsResolver.class);
        Mockito.when((Object)dnsResolver.getService((ServiceQuery)Mockito.any(ServiceQuery.class))).thenReturn(nns.stream());
        ServiceDiscoveryClientFactory.getInstance().setClient((ServiceDiscoveryClient)dnsResolver);
        Configuration conf = new Configuration(false);
        conf.setBoolean("hops.service-discovery.enabled", true);
        conf.set("dfs.namenodes.rpc.addresses", "namenode.service.lc:8020");
        List nnIps = DFSUtil.getNameNodesRPCAddresses((Configuration)conf);
        Assert.assertNotNull((Object)nnIps);
        Assert.assertEquals((long)2L, (long)nnIps.size());
        Assert.assertThat((Object)nnIps, (Matcher)Matchers.equalTo((Object)expected));
        Mockito.when((Object)dnsResolver.getService((ServiceQuery)Mockito.any(ServiceQuery.class))).thenReturn(nns.stream());
        conf = new Configuration(false);
        conf.setBoolean("hops.service-discovery.enabled", true);
        conf.set("fs.defaultFS", "namenode.service.lc:8020");
        nnIps = DFSUtil.getNameNodesRPCAddresses((Configuration)conf);
        Assert.assertNotNull((Object)nnIps);
        Assert.assertEquals((long)2L, (long)nnIps.size());
        Assert.assertThat((Object)nnIps, (Matcher)Matchers.equalTo((Object)expected));
        Mockito.when((Object)dnsResolver.getService((ServiceQuery)Mockito.any(ServiceQuery.class))).thenThrow(new Throwable[]{new ServiceNotFoundException("Service not found")});
        conf = new Configuration(false);
        conf.setBoolean("hops.service-discovery.enabled", true);
        conf.set("fs.defaultFS", "namenode.service.lc:8020");
        nnIps = DFSUtil.getNameNodesRPCAddresses((Configuration)conf);
        Assert.assertNotNull((Object)nnIps);
        Assert.assertTrue((boolean)nnIps.isEmpty());
    }
}

