/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.OngoingSubTreeOpsDataAccess;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Test;

public class TestFailedSTOLockCleaner
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSTOCleanup() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        long stoCleanDelay = 1000L;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setLong("dfs.subtree.clean.failed.ops.locks.delay", stoCleanDelay);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(3)).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem(0);
            FSNamesystem namesystem = cluster.getNamesystem(0);
            dfs.mkdir(new Path("/A"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/B"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/C"), FsPermission.getDefault());
            namesystem.lockSubtree("/A/C", SubTreeOperation.Type.NA);
            namesystem.lockSubtree("/A/B", SubTreeOperation.Type.NA);
            TestFailedSTOLockCleaner.assertEquals((String)"On going subtree ops table", (int)2, (int)TestFailedSTOLockCleaner.countOnGoingSTOs());
            TestFailedSTOLockCleaner.assertEquals((String)"Locked Inodes", (int)2, (int)TestFailedSTOLockCleaner.countLockedINodes());
            cluster.restartNameNode(0);
            long leadercheckInterval = conf.getInt("dfs.leader.check.interval", 2000);
            int missedHeartBeatThreshold = conf.getInt("dfs.leader.missed.hb", 2);
            long delay = stoCleanDelay + leadercheckInterval * (long)(missedHeartBeatThreshold + 1) + 3000L;
            FSNamesystem.LOG.debug((Object)("Testing STO: waiting for " + delay + ". After this the locks should have been reclaimed"));
            Thread.sleep(stoCleanDelay + leadercheckInterval * (long)(missedHeartBeatThreshold + 1) + 3000L);
            TestFailedSTOLockCleaner.assertEquals((String)"On going subtree ops table", (int)0, (int)TestFailedSTOLockCleaner.countOnGoingSTOs());
            TestFailedSTOLockCleaner.assertEquals((String)"Locked Inodes", (int)0, (int)TestFailedSTOLockCleaner.countLockedINodes());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static int countOnGoingSTOs() throws IOException {
        LightWeightRequestHandler subTreeLockChecker = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                OngoingSubTreeOpsDataAccess da = (OngoingSubTreeOpsDataAccess)HdfsStorageFactory.getDataAccess(OngoingSubTreeOpsDataAccess.class);
                return da.allOps().size();
            }
        };
        return (Integer)subTreeLockChecker.handle();
    }

    public static int countLockedINodes() throws IOException {
        LightWeightRequestHandler subTreeLockChecker = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                return ida.countSubtreeLockedInodes();
            }
        };
        return (Integer)subTreeLockChecker.handle();
    }
}

