/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.LeaseCreationLocksDataAccess;
import io.hops.metadata.hdfs.entity.LeaseCreationLock;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;

public class LeaseCreationLocksContext
extends BaseEntityContext<Integer, LeaseCreationLock> {
    private final LeaseCreationLocksDataAccess<LeaseCreationLock> dataAccess;

    public LeaseCreationLocksContext(LeaseCreationLocksDataAccess<LeaseCreationLock> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void update(LeaseCreationLock lease) throws TransactionContextException {
        throw new TransactionContextException("Updating lock rows is not supported");
    }

    public LeaseCreationLock find(FinderType<LeaseCreationLock> finder, Object ... params) throws TransactionContextException, StorageException {
        LeaseCreationLock.Finder lFinder = (LeaseCreationLock.Finder)finder;
        switch (lFinder) {
            case ByRowID: {
                return this.findByPK(finder, (Integer)params[0]);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void remove(LeaseCreationLock lease) throws TransactionContextException {
        throw new TransactionContextException("Counting lock rows is not supported");
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        assert (this.getRemoved().size() == 0 && this.getAdded().size() == 0 && this.getModified().size() == 0);
    }

    public void clear() throws TransactionContextException {
        super.clear();
    }

    Integer getKey(LeaseCreationLock lock) {
        return lock.getLock();
    }

    private LeaseCreationLock findByPK(FinderType<LeaseCreationLock> finder, Integer rowID) throws StorageCallPreventedException, StorageException {
        this.aboutToAccessStorage(finder, new Object[]{rowID});
        LeaseCreationLock lock = (LeaseCreationLock)this.dataAccess.lock(rowID.intValue());
        this.miss(finder, lock, new Object[0]);
        return lock;
    }
}

