/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.junit.Assert;
import org.junit.Test;

public class TestInodeChildrenCount {
    private static final Log LOG = LogFactory.getLog(TestInodeChildrenCount.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInodeChildrenCount() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        Object shell = null;
        DistributedFileSystem fs = null;
        DFSClient dfsClient = null;
        try {
            fs = cluster.getFileSystem();
            dfsClient = fs.getClient();
            fs.mkdirs(new Path("/test"));
            this.createFile(fs, "/test/test1/src");
            fs.rename(new Path("/test/test1/src"), new Path("/test/test1/dst"));
            HdfsFileStatus status = dfsClient.getFileInfo("/test/test1/dst");
            Assert.assertEquals((long)0L, (long)status.getChildrenNum());
            status = dfsClient.getFileInfo("/test/test1");
            Assert.assertEquals((long)1L, (long)status.getChildrenNum());
            fs.rename(new Path("/test/test1"), new Path("/test/test2"));
            status = dfsClient.getFileInfo("/test/test2");
            Assert.assertEquals((long)1L, (long)status.getChildrenNum());
            this.createFile(fs, "/test/test2/newfile");
            status = dfsClient.getFileInfo("/test/test2");
            Assert.assertEquals((long)2L, (long)status.getChildrenNum());
            fs.rename(new Path("/test/test2/dst"), new Path("/test/test2/newfile"), new Options.Rename[]{Options.Rename.OVERWRITE});
            status = dfsClient.getFileInfo("/test/test2");
            this.createFile(fs, "/test/test2/newfile");
            status = dfsClient.getFileInfo("/test/test2");
            Assert.assertEquals((long)1L, (long)status.getChildrenNum());
            fs.delete(new Path("/test/test2/newfile"), true);
            status = dfsClient.getFileInfo("/test/test2");
            Assert.assertEquals((long)0L, (long)status.getChildrenNum());
            int count = 5;
            for (int i = 0; i < count; ++i) {
                Path path = new Path("/test/test2/newfile" + i);
                this.createFile(fs, path.toString());
            }
            status = dfsClient.getFileInfo("/test/test2");
            Assert.assertEquals((long)5L, (long)status.getChildrenNum());
            fs.delete(new Path("/test/test2"), true);
            status = dfsClient.getFileInfo("/test");
            Assert.assertEquals((long)0L, (long)status.getChildrenNum());
            this.createFile(fs, "/test/concat");
            count = 5;
            Path[] srcs = new Path[5];
            for (int i = 0; i < count; ++i) {
                Path path;
                srcs[i] = path = new Path("/test/newfile" + i);
                this.createFile(fs, path.toString());
            }
            status = dfsClient.getFileInfo("/test");
            Assert.assertEquals((long)6L, (long)status.getChildrenNum());
            fs.concat(new Path("/test/concat"), srcs);
            status = dfsClient.getFileInfo("/test");
            Assert.assertEquals((long)1L, (long)status.getChildrenNum());
            fs.delete(new Path("/test"), true);
            status = dfsClient.getFileInfo("/");
            Assert.assertEquals((long)0L, (long)status.getChildrenNum());
        }
        finally {
            if (null != shell) {
                shell.close();
            }
            cluster.shutdown();
        }
    }

    private void createFile(DistributedFileSystem dfs, String filename) throws IOException {
        FSDataOutputStream out = dfs.create(new Path(filename), true);
        out.writeBytes("testfile");
        out.close();
    }
}

