/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDeadDatanode {
    private static final Log LOG = LogFactory.getLog(TestDeadDatanode.class);
    private MiniDFSCluster cluster;

    @After
    public void cleanup() {
        this.cluster.shutdown();
    }

    @Test
    public void testDeadDatanode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setLong("dfs.heartbeat.interval", 1L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        this.cluster.waitActive();
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        DataNode dn = this.cluster.getDataNodes().get(0);
        DatanodeRegistration reg = DataNodeTestUtils.getDNRegistrationForBP(this.cluster.getDataNodes().get(0), poolId);
        DFSTestUtil.waitForDatanodeState(this.cluster, reg.getDatanodeUuid(), true, 20000);
        dn.shutdown();
        DFSTestUtil.waitForDatanodeState(this.cluster, reg.getDatanodeUuid(), false, 20000);
        NamenodeProtocols dnp = this.cluster.getNameNodeRpc();
        ReceivedDeletedBlockInfo[] blocks = new ReceivedDeletedBlockInfo[]{new ReceivedDeletedBlockInfo(new Block(0L), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null)};
        StorageReceivedDeletedBlocks[] storageBlocks = new StorageReceivedDeletedBlocks[]{new StorageReceivedDeletedBlocks(reg.getDatanodeUuid(), blocks)};
        try {
            dnp.blockReceivedAndDeleted(reg, poolId, storageBlocks);
            Assert.fail((String)"Expected IOException is not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int numBuckets = conf.getInt("dfs.blockreport.numbuckets", 1000);
        StorageBlockReport[] report = new StorageBlockReport[]{new StorageBlockReport(new DatanodeStorage(reg.getDatanodeUuid()), BlockReport.builder((int)numBuckets).build())};
        try {
            dnp.blockReport(reg, poolId, report, new BlockReportContext(1, 0, System.nanoTime()));
            Assert.fail((String)"Expected IOException is not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StorageReport[] rep = new StorageReport[]{new StorageReport(new DatanodeStorage(reg.getDatanodeUuid()), false, 0L, 0L, 0L, 0L)};
        DatanodeCommand[] cmd = dnp.sendHeartbeat(reg, rep, 0L, 0L, 0, 0, 0, null).getCommands();
        Assert.assertEquals((long)1L, (long)cmd.length);
        Assert.assertEquals((long)cmd[0].getAction(), (long)RegisterCommand.REGISTER.getAction());
    }
}

