/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.PathUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestAuditLogs {
    static final String auditLogFile = PathUtils.getTestDirName(TestAuditLogs.class) + "/TestAuditLogs-audit.log";
    boolean useAsyncLog;
    static final Pattern auditPattern = Pattern.compile("allowed=.*?\\sugi=.*?\\sip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\scmd=.*?\\ssrc=.*?\\sdst=null\\sperm=.*?");
    static final Pattern successPattern = Pattern.compile(".*allowed=true.*");
    static final Pattern webOpenPattern = Pattern.compile(".*cmd=open.*proto=webhdfs.*");
    static final String username = "bob";
    static final String[] groups = new String[]{"group1"};
    static final String fileName = "/srcdat";
    DFSTestUtil util;
    MiniDFSCluster cluster;
    FileSystem fs;
    String[] fnames;
    Configuration conf;
    UserGroupInformation userGroupInfo;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{new Boolean(false)});
        params.add(new Object[]{new Boolean(true)});
        return params;
    }

    public TestAuditLogs(boolean useAsyncLog) {
        this.useAsyncLog = useAsyncLog;
    }

    @Before
    public void setupCluster() throws Exception {
        this.configureAuditLogs();
        this.conf = new HdfsConfiguration();
        long precision = 1L;
        this.conf.setLong("dfs.namenode.accesstime.precision", 1L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        this.conf.setBoolean("dfs.namenode.audit.log.async", this.useAsyncLog);
        this.util = new DFSTestUtil.Builder().setName("TestAuditAllowed").setNumFiles(20).build();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(4).build();
        this.fs = this.cluster.getFileSystem();
        this.util.createFiles(this.fs, fileName);
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        ArrayList appenders = Collections.list(logger.getAllAppenders());
        Assert.assertEquals((long)1L, (long)appenders.size());
        Assert.assertEquals((Object)this.useAsyncLog, (Object)(appenders.get(0) instanceof AsyncAppender));
        this.fnames = this.util.getFileNames(fileName);
        this.util.waitReplication(this.fs, fileName, (short)3);
        this.userGroupInfo = UserGroupInformation.createUserForTesting((String)username, (String[])groups);
    }

    @After
    public void teardownCluster() throws Exception {
        this.util.cleanup(this.fs, fileName);
        this.fs.close();
        this.cluster.shutdown();
    }

    @Test
    public void testAuditAllowed() throws Exception {
        Path file = new Path(this.fnames[0]);
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        this.setupAuditLogs();
        FSDataInputStream istream = userfs.open(file);
        int val = istream.read();
        istream.close();
        this.verifyAuditLogs(true);
        Assert.assertTrue((String)"failed to read from file", (val >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAuditAllowedStat() throws Exception {
        Path file = new Path(this.fnames[0]);
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        this.setupAuditLogs();
        FileStatus st = userfs.getFileStatus(file);
        this.verifyAuditLogs(true);
        Assert.assertTrue((String)"failed to stat file", (st != null && st.isFile() ? 1 : 0) != 0);
    }

    @Test
    public void testAuditDenied() throws Exception {
        Path file = new Path(this.fnames[0]);
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        this.fs.setPermission(file, new FsPermission(384));
        this.fs.setOwner(file, "root", null);
        this.setupAuditLogs();
        try {
            userfs.open(file);
            Assert.fail((String)"open must not succeed");
        }
        catch (AccessControlException e) {
            System.out.println("got access denied, as expected.");
        }
        this.verifyAuditLogs(false);
    }

    @Test
    public void testAuditWebHdfs() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(420));
        this.fs.setOwner(file, "root", null);
        this.setupAuditLogs();
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf, "webhdfs");
        FSDataInputStream istream = webfs.open(file);
        int val = istream.read();
        istream.close();
        this.verifyAuditLogsRepeat(true, 3);
        Assert.assertTrue((String)"failed to read from file", (val >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAuditWebHdfsStat() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(420));
        this.fs.setOwner(file, "root", null);
        this.setupAuditLogs();
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf, "webhdfs");
        FileStatus st = webfs.getFileStatus(file);
        this.verifyAuditLogs(true);
        Assert.assertTrue((String)"failed to stat file", (st != null && st.isFile() ? 1 : 0) != 0);
    }

    @Test
    public void testAuditWebHdfsDenied() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(384));
        this.fs.setOwner(file, "root", null);
        this.setupAuditLogs();
        try {
            WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf, "webhdfs");
            FSDataInputStream istream = webfs.open(file);
            int val = istream.read();
            Assert.fail((String)("open+read must not succeed, got " + val));
        }
        catch (AccessControlException E) {
            System.out.println("got access denied, as expected.");
        }
        this.verifyAuditLogsRepeat(false, 2);
    }

    @Test
    public void testAuditWebHdfsOpen() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(420));
        this.fs.setOwner(file, "root", null);
        this.setupAuditLogs();
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf, "webhdfs");
        webfs.open(file);
        this.verifyAuditLogsCheckPattern(true, 3, webOpenPattern);
    }

    private void setupAuditLogs() throws IOException {
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        logger.setLevel(Level.INFO);
    }

    private void configureAuditLogs() throws IOException {
        LogManager.shutdown();
        File file = new File(auditLogFile);
        if (file.exists()) {
            file.delete();
        }
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        logger.setLevel(Level.OFF);
        PatternLayout layout = new PatternLayout("%m%n");
        RollingFileAppender appender = new RollingFileAppender((Layout)layout, auditLogFile);
        logger.addAppender((Appender)appender);
    }

    private void verifyAuditLogs(boolean expectSuccess) throws IOException {
        this.verifyAuditLogsRepeat(expectSuccess, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAuditLogsRepeat(boolean expectSuccess, int ndupe) throws IOException {
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        logger.setLevel(Level.OFF);
        Enumeration appenders = logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            appender.close();
        }
        BufferedReader reader = new BufferedReader(new FileReader(auditLogFile));
        String line = null;
        boolean ret = true;
        try {
            for (int i = 0; i < ndupe; ++i) {
                line = reader.readLine();
                Assert.assertNotNull((Object)line);
                Assert.assertTrue((String)"Expected audit event not found in audit log", (boolean)auditPattern.matcher(line).matches());
                ret &= successPattern.matcher(line).matches();
            }
            Assert.assertNull((String)"Unexpected event in audit log", (Object)reader.readLine());
            Assert.assertTrue((String)("Expected success=" + expectSuccess), (ret == expectSuccess ? 1 : 0) != 0);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAuditLogsCheckPattern(boolean expectSuccess, int ndupe, Pattern pattern) throws IOException {
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        logger.setLevel(Level.OFF);
        Enumeration appenders = logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            appender.close();
        }
        BufferedReader reader = new BufferedReader(new FileReader(auditLogFile));
        String line = null;
        boolean ret = true;
        boolean patternMatches = false;
        try {
            for (int i = 0; i < ndupe; ++i) {
                line = reader.readLine();
                Assert.assertNotNull((Object)line);
                patternMatches |= pattern.matcher(line).matches();
                ret &= successPattern.matcher(line).matches();
            }
            Assert.assertNull((String)"Unexpected event in audit log", (Object)reader.readLine());
            Assert.assertTrue((String)"Expected audit event not found in audit log", (boolean)patternMatches);
            Assert.assertTrue((String)("Expected success=" + expectSuccess), (ret == expectSuccess ? 1 : 0) != 0);
        }
        finally {
            reader.close();
        }
    }
}

