/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.util.LightWeightLinkedSet;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLightWeightLinkedSet {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestLightWeightLinkedSet");
    private ArrayList<Integer> list = new ArrayList();
    private final int NUM = 100;
    private LightWeightLinkedSet<Integer> set;
    private Random rand;

    @Before
    public void setUp() {
        float maxF = 0.75f;
        float minF = 0.2f;
        int initCapacity = 16;
        this.rand = new Random(Time.now());
        this.list.clear();
        for (int i = 0; i < 100; ++i) {
            this.list.add(this.rand.nextInt());
        }
        this.set = new LightWeightLinkedSet(initCapacity, maxF, minF);
    }

    @Test
    public void testEmptyBasic() {
        LOG.info((Object)"Test empty basic");
        Iterator iter = this.set.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((long)0L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.isEmpty());
        Assert.assertNull((Object)this.set.pollFirst());
        Assert.assertEquals((long)0L, (long)this.set.pollAll().size());
        Assert.assertEquals((long)0L, (long)this.set.pollN(10).size());
        LOG.info((Object)"Test empty - DONE");
    }

    @Test
    public void testOneElementBasic() {
        LOG.info((Object)"Test one element basic");
        this.set.add((Object)this.list.get(0));
        Assert.assertEquals((long)1L, (long)this.set.size());
        Assert.assertFalse((boolean)this.set.isEmpty());
        Iterator iter = this.set.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)this.list.get(0), iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
        LOG.info((Object)"Test one element basic - DONE");
    }

    @Test
    public void testMultiBasic() {
        LOG.info((Object)"Test multi element basic");
        for (Integer i : this.list) {
            Assert.assertTrue((boolean)this.set.add((Object)i));
        }
        Assert.assertEquals((long)this.list.size(), (long)this.set.size());
        for (Integer i : this.list) {
            Assert.assertTrue((boolean)this.set.contains((Object)i));
        }
        for (Integer i : this.list) {
            Assert.assertFalse((boolean)this.set.add((Object)i));
        }
        for (Integer i : this.list) {
            Assert.assertTrue((boolean)this.set.contains((Object)i));
        }
        Iterator iter = this.set.iterator();
        int num = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((Object)this.list.get(num++), iter.next());
        }
        Assert.assertEquals((long)this.list.size(), (long)num);
        LOG.info((Object)"Test multi element basic - DONE");
    }

    @Test
    public void testRemoveOne() {
        LOG.info((Object)"Test remove one");
        Assert.assertTrue((boolean)this.set.add((Object)this.list.get(0)));
        Assert.assertEquals((long)1L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.remove((Object)this.list.get(0)));
        Assert.assertEquals((long)0L, (long)this.set.size());
        Iterator iter = this.set.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertNull((Object)this.set.pollFirst());
        Assert.assertEquals((long)0L, (long)this.set.pollAll().size());
        Assert.assertEquals((long)0L, (long)this.set.pollN(10).size());
        Assert.assertTrue((boolean)this.set.add((Object)this.list.get(0)));
        Assert.assertEquals((long)1L, (long)this.set.size());
        iter = this.set.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        LOG.info((Object)"Test remove one - DONE");
    }

    @Test
    public void testRemoveMulti() {
        int i;
        LOG.info((Object)"Test remove multi");
        for (Integer i2 : this.list) {
            Assert.assertTrue((boolean)this.set.add((Object)i2));
        }
        for (i = 0; i < 50; ++i) {
            Assert.assertTrue((boolean)this.set.remove((Object)this.list.get(i)));
        }
        for (i = 0; i < 50; ++i) {
            Assert.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        for (i = 50; i < 100; ++i) {
            Assert.assertTrue((boolean)this.set.contains((Object)this.list.get(i)));
        }
        Iterator iter = this.set.iterator();
        int num = 50;
        while (iter.hasNext()) {
            Assert.assertEquals((Object)this.list.get(num++), iter.next());
        }
        Assert.assertEquals((long)num, (long)100L);
        LOG.info((Object)"Test remove multi - DONE");
    }

    @Test
    public void testRemoveAll() {
        int i;
        LOG.info((Object)"Test remove all");
        for (Integer i2 : this.list) {
            Assert.assertTrue((boolean)this.set.add((Object)i2));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)this.set.remove((Object)this.list.get(i)));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        Iterator iter = this.set.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertTrue((boolean)this.set.isEmpty());
        LOG.info((Object)"Test remove all - DONE");
    }

    @Test
    public void testPollOneElement() {
        LOG.info((Object)"Test poll one element");
        this.set.add((Object)this.list.get(0));
        Assert.assertEquals((Object)this.list.get(0), (Object)this.set.pollFirst());
        Assert.assertNull((Object)this.set.pollFirst());
        LOG.info((Object)"Test poll one element - DONE");
    }

    @Test
    public void testPollMulti() {
        int i;
        int i2;
        LOG.info((Object)"Test poll multi");
        for (Integer i3 : this.list) {
            Assert.assertTrue((boolean)this.set.add((Object)i3));
        }
        for (i2 = 0; i2 < 50; ++i2) {
            Assert.assertEquals((Object)this.list.get(i2), (Object)this.set.pollFirst());
        }
        Assert.assertEquals((long)50L, (long)this.set.size());
        for (i2 = 0; i2 < 50; ++i2) {
            Assert.assertFalse((boolean)this.set.contains((Object)this.list.get(i2)));
        }
        for (i2 = 50; i2 < 100; ++i2) {
            Assert.assertTrue((boolean)this.set.contains((Object)this.list.get(i2)));
        }
        Iterator iter = this.set.iterator();
        int num = 50;
        while (iter.hasNext()) {
            Assert.assertEquals((Object)this.list.get(num++), iter.next());
        }
        Assert.assertEquals((long)num, (long)100L);
        for (i = 0; i < 50; ++i) {
            Assert.assertTrue((boolean)this.set.add((Object)this.list.get(i)));
        }
        Assert.assertEquals((long)100L, (long)this.set.size());
        for (i = 50; i < 100; ++i) {
            Assert.assertEquals((Object)this.list.get(i), (Object)this.set.pollFirst());
        }
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((Object)this.list.get(i), (Object)this.set.pollFirst());
        }
        Assert.assertEquals((long)0L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.isEmpty());
        LOG.info((Object)"Test poll multi - DONE");
    }

    @Test
    public void testPollAll() {
        LOG.info((Object)"Test poll all");
        for (Integer i : this.list) {
            Assert.assertTrue((boolean)this.set.add((Object)i));
        }
        while (this.set.pollFirst() != null) {
        }
        Assert.assertEquals((long)0L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.isEmpty());
        for (int i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        Iterator iter = this.set.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
        LOG.info((Object)"Test poll all - DONE");
    }

    @Test
    public void testPollNOne() {
        LOG.info((Object)"Test pollN one");
        this.set.add((Object)this.list.get(0));
        List l = this.set.pollN(10);
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertEquals((Object)this.list.get(0), l.get(0));
        LOG.info((Object)"Test pollN one - DONE");
    }

    @Test
    public void testPollNMulti() {
        int i;
        LOG.info((Object)"Test pollN multi");
        this.set.addAll(this.list);
        List l = this.set.pollN(10);
        Assert.assertEquals((long)10L, (long)l.size());
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)this.list.get(i), l.get(i));
        }
        l = this.set.pollN(1000);
        Assert.assertEquals((long)90L, (long)l.size());
        for (i = 10; i < 100; ++i) {
            Assert.assertEquals((Object)this.list.get(i), l.get(i - 10));
        }
        Assert.assertTrue((boolean)this.set.isEmpty());
        Assert.assertEquals((long)0L, (long)this.set.size());
        LOG.info((Object)"Test pollN multi - DONE");
    }

    @Test
    public void testClear() {
        LOG.info((Object)"Test clear");
        this.set.addAll(this.list);
        Assert.assertEquals((long)100L, (long)this.set.size());
        Assert.assertFalse((boolean)this.set.isEmpty());
        this.set.clear();
        Assert.assertEquals((long)0L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.isEmpty());
        Assert.assertEquals((long)0L, (long)this.set.pollAll().size());
        Assert.assertEquals((long)0L, (long)this.set.pollN(10).size());
        Assert.assertNull((Object)this.set.pollFirst());
        Iterator iter = this.set.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
        LOG.info((Object)"Test clear - DONE");
    }

    @Test
    public void testOther() {
        LOG.info((Object)"Test other");
        Assert.assertTrue((boolean)this.set.addAll(this.list));
        Integer[] array = (Integer[])this.set.toArray((Object[])new Integer[0]);
        Assert.assertEquals((long)100L, (long)array.length);
        for (Integer anArray : array) {
            Assert.assertTrue((boolean)this.list.contains(anArray));
        }
        Assert.assertEquals((long)100L, (long)this.set.size());
        Object[] array2 = this.set.toArray();
        Assert.assertEquals((long)100L, (long)array2.length);
        for (Object anArray2 : array2) {
            Assert.assertTrue((boolean)this.list.contains((Integer)anArray2));
        }
        LOG.info((Object)"Test capacity - DONE");
    }
}

