/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.LockUpgradeException;
import io.hops.exception.OutOfDBExtentsException;
import io.hops.exception.TransientDeadLockException;
import io.hops.exception.TransientStorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.LogVerificationAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Test;

public class TestSuppressTransientExceptions {
    private static final Log LOG = LogFactory.getLog(TestSuppressTransientExceptions.class);

    @Test
    public void TestSuppressTransientExceptions() throws IOException {
        Logger logger = Logger.getRootLogger();
        Logger.getLogger(RequestHandler.class).setLevel(Level.ALL);
        Logger.getLogger(TestSuppressTransientExceptions.class).setLevel(Level.ALL);
        int MAX_RETRY = 2;
        HdfsConfiguration conf = new HdfsConfiguration();
        RequestHandler.setRetryCount((int)2);
        HdfsStorageFactory.reset();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        LOG.info((Object)"******* Test 0 ********");
        LogVerificationAppender appender = new LogVerificationAppender();
        logger.addAppender((Appender)appender);
        Throwable e = new TransientStorageException("TransientStorageException");
        try {
            this.runWithErrors(3, (IOException)e, HDFSOperationType.TEST);
            Assert.fail((String)"Expecting Exception");
        }
        catch (TransientStorageException te) {
            Assert.assertTrue((this.getExceptionCount(appender.getLog(), e.getClass()) == 3 ? 1 : 0) != 0);
        }
        LOG.info((Object)"******* Test 1 ********");
        LogVerificationAppender appender1 = new LogVerificationAppender();
        logger.addAppender((Appender)appender1);
        e = new TransientStorageException("TransientStorageException");
        this.runWithErrors(2, (IOException)e, HDFSOperationType.TEST);
        Assert.assertTrue((this.getExceptionCount(appender1.getLog(), e.getClass()) == 2 ? 1 : 0) != 0);
        LOG.info((Object)"******* Test 2 ********");
        LogVerificationAppender appender2 = new LogVerificationAppender();
        logger.addAppender((Appender)appender2);
        e = new TransientDeadLockException("TransientDeadLockException");
        this.runWithErrors(2, (IOException)e, HDFSOperationType.TEST);
        Assert.assertTrue((this.getExceptionCount(appender2.getLog(), e.getClass()) == 0 ? 1 : 0) != 0);
        LOG.info((Object)"******* Test 3 ********");
        LogVerificationAppender appender3 = new LogVerificationAppender();
        logger.addAppender((Appender)appender3);
        e = new TransientDeadLockException("TransientDeadLockException");
        try {
            this.runWithErrors(3, (IOException)e, HDFSOperationType.TEST);
            Assert.fail((String)"Expecting Exception");
        }
        catch (TransientDeadLockException de) {
            Assert.assertTrue((this.getExceptionCount(appender3.getLog(), e.getClass()) == 3 ? 1 : 0) != 0);
        }
        LOG.info((Object)"******* Test 4 ********");
        int failures = 100;
        LogVerificationAppender appender4 = new LogVerificationAppender();
        logger.addAppender((Appender)appender4);
        try {
            e = new OutOfDBExtentsException("OutOfDBExtentsException");
            this.runWithErrors(failures, (IOException)e, HDFSOperationType.TEST);
            Assert.fail();
        }
        catch (OutOfDBExtentsException outOfDBExtentsException) {
            // empty catch block
        }
        Assert.assertTrue((this.getExceptionCount(appender4.getLog(), e.getClass()) == 1 ? 1 : 0) != 0);
        LOG.info((Object)"******* Test 5 ********");
        failures = 100;
        LogVerificationAppender appender5 = new LogVerificationAppender();
        logger.addAppender((Appender)appender5);
        try {
            e = new OutOfDBExtentsException("OutOfDBExtentsException");
            this.runWithErrors(failures, (IOException)e, HDFSOperationType.COMPLETE_FILE);
            Assert.fail();
        }
        catch (OutOfDBExtentsException outOfDBExtentsException) {
            // empty catch block
        }
        Assert.assertTrue((this.getExceptionCount(appender5.getLog(), e.getClass()) == 0 ? 1 : 0) != 0);
        LOG.info((Object)"******* Test 6 ********");
        failures = 100;
        LogVerificationAppender appender6 = new LogVerificationAppender();
        logger.addAppender((Appender)appender6);
        try {
            e = new LockUpgradeException("LockUpgradeException");
            this.runWithErrors(failures, (IOException)e, HDFSOperationType.TEST);
            Assert.fail();
        }
        catch (LockUpgradeException lockUpgradeException) {
            // empty catch block
        }
        Assert.assertTrue((this.getExceptionCount(appender6.getLog(), e.getClass()) == 1 ? 1 : 0) != 0);
        LOG.info((Object)"******* Test 7 ********");
        failures = 100;
        LogVerificationAppender appender7 = new LogVerificationAppender();
        logger.addAppender((Appender)appender7);
        try {
            e = new LockUpgradeException("LockUpgradeException");
            this.runWithErrors(failures, (IOException)e, HDFSOperationType.GET_BLOCK_LOCATIONS);
            Assert.fail();
        }
        catch (LockUpgradeException lockUpgradeException) {
            // empty catch block
        }
        Assert.assertTrue((this.getExceptionCount(appender7.getLog(), e.getClass()) == 0 ? 1 : 0) != 0);
    }

    int getExceptionCount(List<LoggingEvent> log, Class e) {
        int count = 0;
        for (int i = 0; i < log.size(); ++i) {
            if (!log.get(i).getMessage().toString().contains(e.getCanonicalName())) continue;
            ++count;
        }
        return count;
    }

    void runWithErrors(final int failures, final IOException e, HDFSOperationType type) throws IOException {
        final AtomicInteger count = new AtomicInteger(0);
        HopsTransactionalRequestHandler completeFileHandler = new HopsTransactionalRequestHandler(type){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws IOException {
                if (count.get() >= failures) {
                    return null;
                }
                count.incrementAndGet();
                throw e;
            }
        };
        completeFileHandler.handle((Object)this);
    }
}

