/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.QuotaUpdate;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INode;

final class QuotaUpdateLock
extends Lock {
    private final String[] targets;
    private final boolean includeChildren;
    private final List<QuotaUpdate> updates;

    QuotaUpdateLock(boolean includeChildren, String ... targets) {
        this.includeChildren = includeChildren;
        this.targets = targets;
        this.updates = null;
    }

    QuotaUpdateLock(String ... paths) {
        this(false, paths);
    }

    QuotaUpdateLock(List<QuotaUpdate> updates) {
        this.includeChildren = false;
        this.targets = null;
        this.updates = updates;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        block3: {
            block2: {
                if (this.targets == null) break block2;
                INodeLock inodeLock = (INodeLock)locks.getLock(Lock.Type.INode);
                for (String target : this.targets) {
                    this.acquireQuotaUpdate(inodeLock.getTargetINode(target));
                    if (!this.includeChildren) continue;
                    this.acquireQuotaUpdate(inodeLock.getChildINodes(target));
                }
                break block3;
            }
            if (this.updates == null) break block3;
            for (QuotaUpdate update : this.updates) {
                this.acquireQuotaUpdate(update);
            }
        }
    }

    private void acquireQuotaUpdate(List<INode> iNodes) throws StorageException, TransactionContextException {
        if (iNodes != null) {
            for (INode iNode : iNodes) {
                this.acquireQuotaUpdate(iNode);
            }
        }
    }

    private void acquireQuotaUpdate(INode iNode) throws StorageException, TransactionContextException {
        this.acquireLockList(DEFAULT_LOCK_TYPE, (FinderType)QuotaUpdate.Finder.ByINodeId, new Object[]{iNode.getId()});
    }

    private void acquireQuotaUpdate(QuotaUpdate update) throws StorageException, TransactionContextException {
        this.acquireLock(DEFAULT_LOCK_TYPE, (FinderType)QuotaUpdate.Finder.ByKey, new Object[]{update.getId(), update.getInodeId()});
    }

    protected final Lock.Type getType() {
        return Lock.Type.QuotaUpdate;
    }
}

