/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHost2NodesMap {
    private Host2NodesMap map = new Host2NodesMap();
    private DatanodeDescriptor[] dataNodes;

    @Before
    public void setup() {
        for (DatanodeDescriptor node : this.dataNodes = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", 5021, "/d1/r2")}) {
            this.map.add(node);
        }
        this.map.add(null);
    }

    @Test
    public void testContains() throws Exception {
        DatanodeDescriptor nodeNotInMap = DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r4");
        for (DatanodeDescriptor dataNode : this.dataNodes) {
            Assert.assertTrue((boolean)this.map.contains(dataNode));
        }
        Assert.assertFalse((boolean)this.map.contains(null));
        Assert.assertFalse((boolean)this.map.contains(nodeNotInMap));
    }

    @Test
    public void testGetDatanodeByHost() throws Exception {
        Assert.assertEquals((Object)this.map.getDatanodeByHost("1.1.1.1"), (Object)this.dataNodes[0]);
        Assert.assertEquals((Object)this.map.getDatanodeByHost("2.2.2.2"), (Object)this.dataNodes[1]);
        DatanodeDescriptor node = this.map.getDatanodeByHost("3.3.3.3");
        Assert.assertTrue((node == this.dataNodes[2] || node == this.dataNodes[3] ? 1 : 0) != 0);
        Assert.assertNull((Object)this.map.getDatanodeByHost("4.4.4.4"));
    }

    @Test
    public void testRemove() throws Exception {
        DatanodeDescriptor nodeNotInMap = DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r4");
        Assert.assertFalse((boolean)this.map.remove(nodeNotInMap));
        Assert.assertTrue((boolean)this.map.remove(this.dataNodes[0]));
        Assert.assertTrue((this.map.getDatanodeByHost("1.1.1.1.") == null ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByHost("2.2.2.2") == this.dataNodes[1] ? 1 : 0) != 0);
        DatanodeDescriptor node = this.map.getDatanodeByHost("3.3.3.3");
        Assert.assertTrue((node == this.dataNodes[2] || node == this.dataNodes[3] ? 1 : 0) != 0);
        Assert.assertNull((Object)this.map.getDatanodeByHost("4.4.4.4"));
        Assert.assertTrue((boolean)this.map.remove(this.dataNodes[2]));
        Assert.assertNull((Object)this.map.getDatanodeByHost("1.1.1.1"));
        Assert.assertEquals((Object)this.map.getDatanodeByHost("2.2.2.2"), (Object)this.dataNodes[1]);
        Assert.assertEquals((Object)this.map.getDatanodeByHost("3.3.3.3"), (Object)this.dataNodes[3]);
        Assert.assertTrue((boolean)this.map.remove(this.dataNodes[3]));
        Assert.assertNull((Object)this.map.getDatanodeByHost("1.1.1.1"));
        Assert.assertEquals((Object)this.map.getDatanodeByHost("2.2.2.2"), (Object)this.dataNodes[1]);
        Assert.assertNull((Object)this.map.getDatanodeByHost("3.3.3.3"));
        Assert.assertFalse((boolean)this.map.remove(null));
        Assert.assertTrue((boolean)this.map.remove(this.dataNodes[1]));
        Assert.assertFalse((boolean)this.map.remove(this.dataNodes[1]));
    }
}

