/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import io.hops.exception.StorageException;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FSAclBaseTest {
    private static final UserGroupInformation BRUCE = UserGroupInformation.createUserForTesting((String)"bruce", (String[])new String[0]);
    private static final UserGroupInformation DIANA = UserGroupInformation.createUserForTesting((String)"diana", (String[])new String[0]);
    private static final UserGroupInformation SUPERGROUP_MEMBER = UserGroupInformation.createUserForTesting((String)"super", (String[])new String[]{"supergroup"});
    private static final UserGroupInformation BOB = UserGroupInformation.createUserForTesting((String)"bob", (String[])new String[]{"groupY", "groupZ"});
    protected static MiniDFSCluster cluster;
    protected static Configuration conf;
    private static int pathCount;
    private static Path path;
    private FileSystem fs;
    private FileSystem fsAsBruce;
    private FileSystem fsAsDiana;
    private FileSystem fsAsSupergroupMember;
    private FileSystem fsAsBob;

    @AfterClass
    public static void shutdown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        path = new Path("/p" + ++pathCount);
        this.initFileSystems();
    }

    @After
    public void destroyFileSystems() {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.fs, this.fsAsBruce, this.fsAsDiana, this.fsAsSupergroupMember});
        this.fsAsBob = null;
        this.fsAsSupergroupMember = null;
        this.fsAsDiana = null;
        this.fsAsBruce = null;
        this.fs = null;
    }

    protected FileSystem createFileSystem() throws Exception {
        return cluster.getFileSystem();
    }

    protected FileSystem createFileSystem(UserGroupInformation user) throws Exception {
        return DFSTestUtil.getFileSystemAs(user, cluster.getConfiguration(0));
    }

    @Test
    public void testModifyAclEntries() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesMinimal() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_WRITE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4528);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesMinimalDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesCustomMask() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.NONE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4480);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)5096);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testModifyAclEntriesPathNotFound() throws IOException {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testModifyAclEntriesDefaultOnFile() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
    }

    @Test
    public void testRemoveAclEntries() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        this.fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo")});
        this.fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE)}, (Object[])returned);
        this.assertPermission((short)4592);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bar", FsAction.READ_EXECUTE)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        this.fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesMinimal() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)496));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK)});
        this.fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)496);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclEntriesMinimalDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        this.fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        this.fs.removeAclEntries(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)5096);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveAclEntriesPathNotFound() throws IOException {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo")});
        this.fs.removeAclEntries(path, (List)aclSpec);
    }

    @Test
    public void testRemoveDefaultAcl() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveDefaultAclOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveDefaultAclOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveDefaultAclMinimal() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveDefaultAclStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)5112);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveDefaultAclPathNotFound() throws IOException {
        this.fs.removeDefaultAcl(path);
    }

    @Test
    public void testRemoveAcl() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclMinimalAcl() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        this.fs.removeAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)416);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)1000);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.removeAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveAclPathNotFound() throws IOException {
        this.fs.removeAcl(path);
    }

    @Test
    public void testSetAcl() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4512);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclMinimal() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)420));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)416);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testSetAclMinimalDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclCustomMask() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4536);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclStickyBit() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)5112);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSetAclPathNotFound() throws IOException {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testSetAclDefaultOnFile() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
    }

    @Test
    public void testSetPermission() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.setPermission(path, FsPermission.createImmutable((short)448));
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4544);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetPermissionOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.setPermission(path, FsPermission.createImmutable((short)384));
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4480);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetPermissionOnlyDefault() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        this.fs.setPermission(path, FsPermission.createImmutable((short)448));
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4544);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetPermissionCannotSetAclBit() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setPermission(path, FsPermission.createImmutable((short)448));
        this.assertPermission((short)448);
        this.fs.setPermission(path, (FsPermission)new FsPermissionExtension(FsPermission.createImmutable((short)493), true, true));
        INode inode = this.getInode();
        Assert.assertNotNull((Object)inode);
        FsPermission perm = inode.getFsPermission();
        Assert.assertNotNull((Object)perm);
        Assert.assertEquals((long)493L, (long)perm.toShort());
        Assert.assertEquals((long)493L, (long)perm.toExtendedShort());
        FSAclBaseTest.assertAclFeature(false);
    }

    private INode getInode() throws IOException {
        return (INode)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, new String[]{path.toUri().getPath()}).setNameNodeID(cluster.getNameNode().getId()).setActiveNameNodes((Collection)cluster.getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockLock());
            }

            public Object performTask() throws StorageException, IOException {
                return cluster.getNamesystem().getFSDirectory().getINode(path.toUri().getPath(), false);
            }
        }.handle();
    }

    @Test
    public void testDefaultAclNewFile() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        AclStatus s = this.fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission(filePath, (short)4516);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testOnlyAccessAclNewFile() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        AclStatus s = this.fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission(filePath, (short)420);
        FSAclBaseTest.assertAclFeature(filePath, false);
    }

    @Test
    public void testDefaultMinimalAclNewFile() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)});
        this.fs.setAcl(path, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        AclStatus s = this.fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission(filePath, (short)4516);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testDefaultAclNewDir() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        this.fs.mkdirs(dirPath);
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission(dirPath, (short)4589);
        FSAclBaseTest.assertAclFeature(dirPath, true);
    }

    @Test
    public void testOnlyAccessAclNewDir() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        this.fs.mkdirs(dirPath);
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission(dirPath, (short)493);
        FSAclBaseTest.assertAclFeature(dirPath, false);
    }

    @Test
    public void testDefaultMinimalAclNewDir() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)});
        this.fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        this.fs.mkdirs(dirPath);
        System.out.println("AUSUGST: " + this.fs.getFileStatus(dirPath).getPermission());
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission(dirPath, (short)4589);
        FSAclBaseTest.assertAclFeature(dirPath, true);
    }

    @Test
    public void testDefaultAclNewFileIntermediate() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        Path filePath = new Path(dirPath, "file1");
        this.fs.create(filePath).close();
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(dirPath, (short)4584);
        FSAclBaseTest.assertAclFeature(dirPath, true);
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        s = this.fs.getAclStatus(filePath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(filePath, (short)4516);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testDefaultAclNewDirIntermediate() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        Path subdirPath = new Path(dirPath, "subdir1");
        this.fs.mkdirs(subdirPath);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(dirPath, (short)4589);
        FSAclBaseTest.assertAclFeature(dirPath, true);
        s = this.fs.getAclStatus(subdirPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(subdirPath, (short)4589);
        FSAclBaseTest.assertAclFeature(subdirPath, true);
    }

    public void testDefaultAclNewSymlinkIntermediate() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        this.fs.setPermission(filePath, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        Path linkPath = new Path(dirPath, "link1");
        this.fs.createSymlink(filePath, linkPath, true);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)};
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(dirPath, (short)488);
        FSAclBaseTest.assertAclFeature(dirPath, true);
        expected = new AclEntry[]{};
        s = this.fs.getAclStatus(linkPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(linkPath, (short)416);
        FSAclBaseTest.assertAclFeature(linkPath, false);
        s = this.fs.getAclStatus(filePath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(filePath, (short)4512);
        FSAclBaseTest.assertAclFeature(filePath, false);
    }

    @Test
    public void testDefaultAclNewFileWithMode() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)493));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path filePath = new Path(path, "file1");
        int bufferSize = cluster.getConfiguration(0).getInt("io.file.buffer.size", 4096);
        this.fs.create(filePath, new FsPermission(480), false, bufferSize, this.fs.getDefaultReplication(filePath), this.fs.getDefaultBlockSize(path), null).close();
        AclStatus s = this.fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission(filePath, (short)4576);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testDefaultAclNewDirWithMode() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)493));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        this.fs.setAcl(path, (List)aclSpec);
        Path dirPath = new Path(path, "dir1");
        this.fs.mkdirs(dirPath, new FsPermission(480));
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission(dirPath, (short)4576);
        FSAclBaseTest.assertAclFeature(dirPath, true);
    }

    @Test
    public void testAccess() throws IOException, InterruptedException {
        Path p1 = new Path("/p1");
        this.fs.mkdirs(p1);
        this.fs.setOwner(p1, BRUCE.getShortUserName(), "groupX");
        this.fsAsBruce.setAcl(p1, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)}));
        this.fsAsBruce.access(p1, FsAction.READ);
        try {
            this.fsAsBruce.access(p1, FsAction.WRITE);
            Assert.fail((String)"The access call should have failed.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        Path badPath = new Path("/bad/bad");
        try {
            this.fsAsBruce.access(badPath, FsAction.READ);
            Assert.fail((String)"The access call should have failed");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.fsAsBruce.modifyAclEntries(p1, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "groupY", FsAction.READ)}));
        this.fsAsBob.access(p1, FsAction.READ);
        try {
            this.fsAsBob.access(p1, FsAction.WRITE);
            Assert.fail((String)"The access call should have failed.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.fsAsBruce.modifyAclEntries(p1, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "groupZ", FsAction.WRITE)}));
        this.fsAsBob.access(p1, FsAction.WRITE);
        this.fsAsBruce.modifyAclEntries(p1, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bob", FsAction.NONE)}));
        try {
            this.fsAsBob.access(p1, FsAction.READ);
            Assert.fail((String)"The access call should have failed.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    @Test
    public void testEffectiveAccess() throws Exception {
        Path p1 = new Path("/testEffectiveAccess");
        this.fs.mkdirs(p1);
        this.fs.setPermission(p1, FsPermission.valueOf((String)"-rwxrwxrwx"));
        AclStatus aclStatus = this.fs.getAclStatus(p1);
        Assert.assertEquals((String)"Entries should be empty", (long)0L, (long)aclStatus.getEntries().size());
        Assert.assertEquals((String)"Permission should be carried by AclStatus", (Object)this.fs.getFileStatus(p1).getPermission(), (Object)aclStatus.getPermission());
        this.fs.modifyAclEntries(p1, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "groupY", FsAction.ALL)}));
        aclStatus = this.fs.getAclStatus(p1);
        Assert.assertEquals((String)"Entries should contain owner group entry also", (long)3L, (long)aclStatus.getEntries().size());
        this.fs.setPermission(p1, FsPermission.valueOf((String)"-rwxr-----"));
        aclStatus = this.fs.getAclStatus(p1);
        List entries = aclStatus.getEntries();
        for (AclEntry aclEntry : entries) {
            if (aclEntry.getName() == null && aclEntry.getType() != AclEntryType.GROUP) continue;
            Assert.assertEquals((Object)FsAction.ALL, (Object)aclEntry.getPermission());
            Assert.assertEquals((Object)FsAction.READ, (Object)aclStatus.getEffectivePermission(aclEntry));
        }
        this.fsAsBruce.access(p1, FsAction.READ);
        try {
            this.fsAsBruce.access(p1, FsAction.WRITE);
            Assert.fail((String)"Access should not be given");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.fsAsBob.access(p1, FsAction.READ);
        try {
            this.fsAsBob.access(p1, FsAction.WRITE);
            Assert.fail((String)"Access should not be given");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private static void assertAclFeature(boolean expectAclFeature) throws IOException {
        FSAclBaseTest.assertAclFeature(path, expectAclFeature);
    }

    private static void assertAclFeature(final Path pathToCheck, final boolean expectAclFeature) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, new String[]{pathToCheck.toString()}).setNameNodeID(cluster.getNameNode().getId()).setActiveNameNodes((Collection)cluster.getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                INode inode = cluster.getNamesystem().getINode(pathToCheck.toString());
                Assert.assertNotNull((Object)inode);
                List aclEntries = AclStorage.readINodeAcl((INode)inode);
                if (expectAclFeature) {
                    Assert.assertFalse((boolean)aclEntries.isEmpty());
                } else {
                    Assert.assertTrue((boolean)aclEntries.isEmpty());
                }
                return null;
            }
        }.handle();
    }

    private void initFileSystems() throws Exception {
        this.fs = this.createFileSystem();
        this.fsAsBruce = this.createFileSystem(BRUCE);
        this.fsAsDiana = this.createFileSystem(DIANA);
        this.fsAsBob = this.createFileSystem(BOB);
        this.fsAsSupergroupMember = this.createFileSystem(SUPERGROUP_MEMBER);
    }

    private void assertPermission(short perm) throws IOException {
        this.assertPermission(path, perm);
    }

    private void assertPermission(Path pathToCheck, short perm) throws IOException {
        AclTestHelpers.assertPermission(this.fs, pathToCheck, perm);
    }

    @Test
    public void testModifyAclMask() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(path, (List)aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.ALL)}, (Object[])returned);
        for (Object entry : returned) {
            Assert.assertEquals((Object)entry.getPermission(), (Object)s.getEffectivePermission((AclEntry)entry));
        }
        this.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ)});
        this.fs.modifyAclEntries(path, (List)aclSpec);
        s = this.fs.getAclStatus(path);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.ALL)}, (Object[])returned);
        for (Object entry : returned) {
            Assert.assertEquals((Object)FsAction.READ, (Object)s.getEffectivePermission((AclEntry)entry));
        }
        this.assertPermission((short)4576);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSettingMaskOnInheritedAcl() throws IOException {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        Path file = new Path(path, "file1");
        ArrayList aclEntries = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "charlie", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.WRITE_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "charlie", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "sales", FsAction.ALL)});
        this.fs.modifyAclEntries(path, (List)aclEntries);
        DFSTestUtil.createFile(this.fs, file, 0L, (short)1, 0L);
        aclEntries = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_WRITE)});
        this.fs.modifyAclEntries(file, (List)aclEntries);
        AclStatus aclStatus = this.fs.getAclStatus(file);
        Object[] returned = aclStatus.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "charlie", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL)}, (Object[])returned);
        Assert.assertArrayEquals((Object[])new FsAction[]{FsAction.READ_WRITE, FsAction.READ, FsAction.READ_WRITE}, (Object[])new FsAction[]{aclStatus.getEffectivePermission((AclEntry)returned[0]), aclStatus.getEffectivePermission((AclEntry)returned[1]), aclStatus.getEffectivePermission((AclEntry)returned[2])});
        aclEntries = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "charlie", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "sales", FsAction.READ)});
        this.fs.modifyAclEntries(path, (List)aclEntries);
        aclStatus = this.fs.getAclStatus(file);
        returned = aclStatus.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "charlie", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.READ)}, (Object[])returned);
        for (Object entry : returned) {
            Assert.assertEquals((Object)FsAction.READ, (Object)aclStatus.getEffectivePermission((AclEntry)entry));
        }
    }

    static {
        pathCount = 0;
    }
}

