/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Test;

public class TestMultiNNURI
extends TestCase {
    static final Log LOG = LogFactory.getLog(TestMultiNNURI.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailover() throws IOException {
        Logger.getRootLogger().setLevel(Level.ERROR);
        Logger.getLogger(TestMultiNNURI.class).setLevel(Level.ALL);
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        int NUM_NAMENODES = 2;
        int NUM_DATANODES = 1;
        boolean NN0 = false;
        boolean NN1 = true;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(NUM_NAMENODES)).numDataNodes(NUM_DATANODES).build();
            cluster.waitActive();
            LOG.info((Object)"Started Cluster");
            String file = "/file";
            DistributedFileSystem dfs0 = (DistributedFileSystem)cluster.getNewFileSystemInstance(0);
            DistributedFileSystem dfs1 = (DistributedFileSystem)cluster.getNewFileSystemInstance(1);
            dfs0.create(new Path(file)).close();
            LOG.info((Object)("dfs.namenodes.rpc.addresses : " + conf.get("dfs.namenodes.rpc.addresses", "")));
            String fileNN0URI = cluster.getFileSystem(0).getUri() + file;
            String fileNN1URI = cluster.getFileSystem(1).getUri() + file;
            LOG.info((Object)("NN0 URI " + fileNN0URI));
            LOG.info((Object)("NN1 URI " + fileNN1URI));
            try {
                dfs0.getFileStatus(new Path(file));
                LOG.info((Object)"Reading file using dfs0 works");
                dfs1.getFileStatus(new Path(file));
                LOG.info((Object)"Reading file using dfs1 works");
                dfs0.getFileStatus(new Path(fileNN0URI));
                LOG.info((Object)"Reading fileNN0URI using dfs0 works");
                dfs1.getFileStatus(new Path(fileNN1URI));
                LOG.info((Object)"Reading fileNN1URI using dfs1 works");
                dfs0.getFileStatus(new Path(fileNN1URI));
                LOG.info((Object)"Reading fileNN1URI using dfs0 works");
                dfs1.getFileStatus(new Path(fileNN0URI));
                LOG.info((Object)"Reading fileNN0URI using dfs1 works");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                TestMultiNNURI.fail();
            }
            try {
                String wrongURI = "hdfs://localhost:9999" + file;
                dfs0.getFileStatus(new Path(wrongURI));
                TestMultiNNURI.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

