/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.RetryCacheEntryDataAccess;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.ipc.ClientId;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestNamenodeRetryCacheCleaner {
    public static final Log LOG = LogFactory.getLog(TestNamenodeRetryCacheCleaner.class);

    @Test
    public void testCleanerFewEntries() throws Exception {
        this.testcleaner(10);
    }

    @Test
    public void testCleanerToneOfEntries() throws Exception {
        this.testcleaner(10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testcleaner(int entriesPerEpoch) throws Exception {
        Logger.getRootLogger().setLevel(Level.ERROR);
        Logger.getLogger(FSNamesystem.RetryCacheCleaner.class).setLevel(Level.ALL);
        Logger.getLogger(TestNamenodeRetryCacheCleaner.class).setLevel(Level.ALL);
        byte[] CLIENT_ID = ClientId.getClientId();
        int callId = 1;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.enable.retrycache", true);
        conf.setLong("dfs.namenode.retrycache.expirytime.millis", 5000L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            long startEpoch = System.currentTimeMillis() / 1000L;
            int totalEpochs = 5;
            int span = 5;
            for (long epoch = startEpoch; epoch < startEpoch + (long)(totalEpochs * span); epoch += (long)span) {
                ArrayList<RetryCacheEntry> entries = new ArrayList<RetryCacheEntry>(entriesPerEpoch);
                for (int i = 0; i < entriesPerEpoch; ++i) {
                    entries.add(new RetryCacheEntry(CLIENT_ID, callId++, epoch));
                }
                this.addCacheEntry(entries);
            }
            assert (this.countEntries() == totalEpochs * entriesPerEpoch);
            Thread.sleep(span * 1000 / 2);
            for (int i = 1; i <= totalEpochs; ++i) {
                Thread.sleep(span * 1000);
                assert (this.countEntries() == (totalEpochs - i) * entriesPerEpoch);
                LOG.info((Object)("Epoch " + i + " cleared"));
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        finally {
            cluster.shutdown();
        }
    }

    private void addCacheEntry(final List<RetryCacheEntry> entries) throws IOException {
        new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                RetryCacheEntryDataAccess da = (RetryCacheEntryDataAccess)HdfsStorageFactory.getDataAccess(RetryCacheEntryDataAccess.class);
                da.prepare((Collection)Collections.EMPTY_LIST, (Collection)entries);
                return null;
            }
        }.handle();
    }

    private int countEntries() throws IOException {
        return (Integer)new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                RetryCacheEntryDataAccess da = (RetryCacheEntryDataAccess)HdfsStorageFactory.getDataAccess(RetryCacheEntryDataAccess.class);
                return da.count();
            }
        }.handle();
    }

    @Test
    public void testCacheEnabled() throws Exception {
        this.simpleTest(true);
    }

    @Test
    public void testCacheDisabled() throws Exception {
        this.simpleTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleTest(boolean enableCache) throws Exception {
        long BlockSize = 1024L;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.enable.retrycache", enableCache);
        conf.setLong("dfs.namenode.retrycache.expirytime.millis", 5000L);
        conf.setLong("dfs.blocksize", BlockSize);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setInt("ipc.client.connect.max.retries", 0);
        conf.set("dfs.client.retry.policy.spec", "1000,2");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            DFSTestUtil.runOperations(cluster, dfs, (Configuration)conf, BlockSize, 0);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        finally {
            cluster.shutdown();
        }
    }
}

