/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Test;

public class TestSubtreeLockACL
extends TestCase {
    private static Log log = LogFactory.getLog(TestSubtreeLockACL.class);
    Configuration conf = new HdfsConfiguration();
    MiniDFSCluster cluster;
    Path subtrees = new Path("/subtrees");
    Path subtree1 = new Path(this.subtrees, "subtree1");
    Path level1folder1 = new Path(this.subtree1, "level1folder1");
    Path level1folder2 = new Path(this.subtree1, "level1folder2");
    Path level2folder1 = new Path(this.level1folder1, "level2folder1");
    Path level2file1 = new Path(this.level1folder1, "level2file1");
    Path level3file1 = new Path(this.level2folder1, "level2file1");
    Path subtree2 = new Path(this.subtrees, "subtree2");
    String sharedGroup = "sharedgroup";
    UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"user1", this.sharedGroup});
    UserGroupInformation user2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])new String[]{"user2", this.sharedGroup});

    public TestSubtreeLockACL() {
        this.conf.setBoolean("dfs.namenode.acls.enabled", true);
    }

    public void setup() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(true).numDataNodes(1).build();
        this.cluster.waitActive();
        this.createFileTree();
    }

    public void teardown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testRenameBlockedByDestinationParentAccessAcl() throws IOException, InterruptedException {
        try {
            this.setup();
            this.setReadOnlyUserAccessAcl(this.user2.getShortUserName(), this.subtree2);
            FileSystem user2fs = (FileSystem)this.user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((Configuration)TestSubtreeLockACL.this.conf);
                }
            });
            try {
                user2fs.rename(this.level1folder1, new Path(this.subtree2, "newname"));
                TestSubtreeLockACL.fail((String)"Owner permission should block rename");
            }
            catch (AccessControlException expected) {
                TestSubtreeLockACL.assertTrue((String)"Wrong inode triggered access control exception.", (boolean)expected.getMessage().contains("inode=\"/subtrees/subtree2\""));
            }
        }
        finally {
            this.teardown();
        }
    }

    @Test
    public void testSubtreeMoveBlockedSourceParentAccessAcl() throws IOException, InterruptedException {
        try {
            this.setup();
            this.setReadOnlyUserAccessAcl(this.user2.getShortUserName(), this.subtree1);
            FileSystem user2fs = (FileSystem)this.user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((Configuration)TestSubtreeLockACL.this.conf);
                }
            });
            try {
                user2fs.rename(this.level1folder1, new Path(this.subtree2, "newname"));
                TestSubtreeLockACL.fail((String)"Acl should block move");
            }
            catch (AccessControlException expected) {
                TestSubtreeLockACL.assertTrue((String)"Wrong inode triggered access control exception.", (boolean)expected.getMessage().contains("inode=\"/subtrees/subtree1\""));
            }
        }
        finally {
            this.teardown();
        }
    }

    @Test
    public void testSubtreeMoveBlockedByInheritedDefaultAcl() throws IOException, InterruptedException {
        try {
            this.setup();
            this.setReadOnlyUserDefaultAcl(this.user2.getShortUserName(), this.subtree1);
            FileSystem user2fs = (FileSystem)this.user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((Configuration)TestSubtreeLockACL.this.conf);
                }
            });
            try {
                user2fs.rename(this.level2folder1, new Path(this.subtree2, "newname"));
                TestSubtreeLockACL.fail((String)"Acl should block move");
            }
            catch (AccessControlException expected) {
                TestSubtreeLockACL.assertTrue((String)"Wrong inode triggered access control exception.", (boolean)expected.getMessage().contains("inode=\"/subtrees/subtree1/level1folder1\""));
            }
        }
        finally {
            this.teardown();
        }
    }

    @Test
    public void testSubtreeMoveNotBlockedByDeepAcl() throws IOException, InterruptedException {
        try {
            this.setup();
            this.setDenyUserAccessAcl(this.user2.getShortUserName(), this.level2folder1);
            FileSystem user2fs = (FileSystem)this.user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((Configuration)TestSubtreeLockACL.this.conf);
                }
            });
            try {
                user2fs.rename(this.subtree1, new Path(this.subtree2, "newname"));
            }
            catch (AccessControlException expected) {
                TestSubtreeLockACL.fail((String)"Operation should complete without errors");
            }
        }
        finally {
            this.teardown();
        }
    }

    @Test
    public void testSubtreeDeleteBlockedByAccessAcl() throws IOException, InterruptedException {
        try {
            this.setup();
            this.setDenyUserAccessAcl(this.user2.getShortUserName(), this.level1folder1);
            FileSystem user2fs = (FileSystem)this.user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((Configuration)TestSubtreeLockACL.this.conf);
                }
            });
            try {
                user2fs.delete(this.subtree1, true);
                TestSubtreeLockACL.fail((String)"Acl should block delete");
            }
            catch (AccessControlException expected) {
                TestSubtreeLockACL.assertTrue((String)"Wrong inode triggered access control exception.", (boolean)expected.getMessage().contains("projectedInode=\"level1folder1\""));
            }
        }
        finally {
            this.teardown();
        }
    }

    @Test
    public void testSubtreeDeleteBlockedByInheritedDefaultAcl() throws IOException, InterruptedException {
        try {
            this.setup();
            this.setDenyUserDefaultAcl(this.user2.getShortUserName(), this.subtree1);
            FileSystem user2fs = (FileSystem)this.user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((Configuration)TestSubtreeLockACL.this.conf);
                }
            });
            try {
                user2fs.delete(this.subtree1, true);
                TestSubtreeLockACL.fail((String)"Acl should block delete");
            }
            catch (AccessControlException expected) {
                TestSubtreeLockACL.assertTrue((String)"Wrong inode triggered access control exception.", (boolean)expected.getMessage().contains("projectedInode=\"level1folder1\""));
            }
        }
        finally {
            this.teardown();
        }
    }

    @Test
    public void testSubtreeDeleteBlockedByInheritedDefaultDeepAcl() throws IOException, InterruptedException {
        try {
            this.setup();
            this.setDenyUserDefaultAcl(this.user2.getShortUserName(), this.level1folder1);
            FileSystem user2fs = (FileSystem)this.user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((Configuration)TestSubtreeLockACL.this.conf);
                }
            });
            try {
                user2fs.delete(this.subtree1, true);
                TestSubtreeLockACL.fail((String)"Acl should block delete");
            }
            catch (AccessControlException expected) {
                TestSubtreeLockACL.assertTrue((String)"Wrong inode triggered access control exception.", (boolean)expected.getMessage().contains("projectedInode=\"level2folder1\""));
            }
        }
        finally {
            this.teardown();
        }
    }

    private void createFileTree() throws IOException {
        DistributedFileSystem superFs = this.cluster.getFileSystem();
        FsPermission defaultPerm = FsPermission.createImmutable((short)509);
        superFs.mkdirs(this.subtrees);
        superFs.setPermission(this.subtrees, defaultPerm);
        superFs.setOwner(this.subtrees, this.user1.getShortUserName(), this.sharedGroup);
        superFs.mkdirs(this.subtree1);
        superFs.setPermission(this.subtree1, defaultPerm);
        superFs.mkdirs(this.level1folder1);
        superFs.setPermission(this.level1folder1, defaultPerm);
        superFs.mkdirs(this.level1folder2);
        superFs.setPermission(this.level1folder2, defaultPerm);
        superFs.mkdirs(this.level2folder1);
        superFs.setPermission(this.level2folder1, defaultPerm);
        DFSTestUtil.createFile((FileSystem)superFs, this.level2file1, 1000L, (short)1, 0L);
        superFs.setPermission(this.level2file1, defaultPerm);
        DFSTestUtil.createFile((FileSystem)superFs, this.level3file1, 1000L, (short)1, 0L);
        superFs.setPermission(this.level3file1, defaultPerm);
        superFs.setOwner(this.subtree1, this.user1.getShortUserName(), this.sharedGroup);
        superFs.setOwner(this.level1folder1, this.user1.getShortUserName(), this.sharedGroup);
        superFs.setOwner(this.level1folder2, this.user1.getShortUserName(), this.sharedGroup);
        superFs.setOwner(this.level2folder1, this.user1.getShortUserName(), this.sharedGroup);
        superFs.setOwner(this.level2file1, this.user1.getShortUserName(), this.sharedGroup);
        superFs.setOwner(this.level3file1, this.user1.getShortUserName(), this.sharedGroup);
        superFs.mkdirs(this.subtree2);
        superFs.setPermission(this.subtree2, defaultPerm);
        superFs.setOwner(this.subtree2, this.user1.getShortUserName(), this.sharedGroup);
    }

    private List<AclEntry> createUserEntry(String username, boolean isDefaultScope, FsAction permission) {
        ArrayList<AclEntry> newEntry = new ArrayList<AclEntry>();
        newEntry.add(new AclEntry.Builder().setScope(isDefaultScope ? AclEntryScope.DEFAULT : AclEntryScope.ACCESS).setType(AclEntryType.USER).setName(username).setPermission(permission).build());
        return newEntry;
    }

    private void setReadOnlyUserAccessAcl(String username, Path path) throws IOException {
        DistributedFileSystem fileSystem = this.cluster.getFileSystem();
        List<AclEntry> readOnlyUserAcl = this.createUserEntry(username, false, FsAction.READ_EXECUTE);
        fileSystem.modifyAclEntries(path, readOnlyUserAcl);
        AclStatus aclStatus = fileSystem.getAclStatus(path);
        boolean found = false;
        for (AclEntry aclEntry : aclStatus.getEntries()) {
            if (!aclEntry.getScope().equals((Object)AclEntryScope.ACCESS) || !aclEntry.getType().equals((Object)AclEntryType.USER) || !aclEntry.getName().equals(username) || !aclEntry.getPermission().equals((Object)FsAction.READ_EXECUTE)) continue;
            found = true;
            break;
        }
        TestSubtreeLockACL.assertTrue((String)("Did not manage to update acl for path " + path.toString()), (boolean)found);
    }

    private void setReadOnlyUserDefaultAcl(String username, Path path) throws IOException {
        DistributedFileSystem fileSystem = this.cluster.getFileSystem();
        List<AclEntry> userEntry = this.createUserEntry(username, true, FsAction.READ_EXECUTE);
        fileSystem.modifyAclEntries(path, userEntry);
        AclStatus aclStatus = fileSystem.getAclStatus(path);
        boolean found = false;
        for (AclEntry aclEntry : aclStatus.getEntries()) {
            if (!aclEntry.getScope().equals((Object)AclEntryScope.DEFAULT) || !aclEntry.getType().equals((Object)AclEntryType.USER) || !aclEntry.getName().equals(username) || !aclEntry.getPermission().equals((Object)FsAction.READ_EXECUTE)) continue;
            found = true;
            break;
        }
        TestSubtreeLockACL.assertTrue((String)("Did not manage to update acl for path " + path.toString()), (boolean)found);
    }

    private void setDenyUserAccessAcl(String username, Path path) throws IOException {
        DistributedFileSystem fileSystem = this.cluster.getFileSystem();
        List<AclEntry> denyUserAcl = this.createUserEntry(username, false, FsAction.NONE);
        fileSystem.modifyAclEntries(path, denyUserAcl);
        AclStatus aclStatus = fileSystem.getAclStatus(path);
        boolean found = false;
        for (AclEntry aclEntry : aclStatus.getEntries()) {
            if (!aclEntry.getScope().equals((Object)AclEntryScope.ACCESS) || !aclEntry.getType().equals((Object)AclEntryType.USER) || !aclEntry.getName().equals(username) || !aclEntry.getPermission().equals((Object)FsAction.NONE)) continue;
            found = true;
            break;
        }
        TestSubtreeLockACL.assertTrue((String)("Did not manage to update acl for path " + path.toString()), (boolean)found);
    }

    private void setDenyUserDefaultAcl(String username, Path path) throws IOException {
        DistributedFileSystem fileSystem = this.cluster.getFileSystem();
        List<AclEntry> denyUserDefaultAcl = this.createUserEntry(username, true, FsAction.NONE);
        fileSystem.modifyAclEntries(path, denyUserDefaultAcl);
        AclStatus aclStatus = fileSystem.getAclStatus(path);
        boolean found = false;
        for (AclEntry aclEntry : aclStatus.getEntries()) {
            if (!aclEntry.getScope().equals((Object)AclEntryScope.DEFAULT) || !aclEntry.getType().equals((Object)AclEntryType.USER) || !aclEntry.getName().equals(username) || !aclEntry.getPermission().equals((Object)FsAction.NONE)) continue;
            found = true;
            break;
        }
        TestSubtreeLockACL.assertTrue((String)("Did not manage to update acl for path " + path.toString()), (boolean)found);
    }

    @Test
    public void testRenameFileInAclSubtree() throws IOException, InterruptedException {
        this.testRenameFileInAclSubtreeInt(false);
    }

    @Test
    public void testOldRenameFileInAclSubtree() throws IOException, InterruptedException {
        this.testRenameFileInAclSubtreeInt(true);
    }

    private void testRenameFileInAclSubtreeInt(boolean oldRename) throws IOException, InterruptedException {
        try {
            this.setup();
            this.setReadOnlyUserAccessAcl(this.user2.getShortUserName(), this.subtree2);
            FileSystem user1fs = (FileSystem)this.user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((Configuration)TestSubtreeLockACL.this.conf);
                }
            });
            this.renameTo(user1fs, this.level2file1, new Path(this.subtree2, "newname"), oldRename);
        }
        finally {
            this.teardown();
        }
    }

    private void renameTo(FileSystem fileSystem, Path src, Path dst, boolean oldRename) throws IOException {
        DistributedFileSystem dfs = (DistributedFileSystem)fileSystem;
        if (oldRename) {
            dfs.rename(src, dst);
        } else {
            dfs.rename(src, dst, new Options.Rename[]{Options.Rename.NONE});
        }
    }
}

