/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.BasicClusterTestCase;
import io.hops.erasure_coding.Codec;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.junit.Test;

public class TestErasureCodingApi
extends BasicClusterTestCase {
    private final Path testFile = new Path("/test_file");

    @Test
    public void testCreateEncodedFile() throws IOException {
        FSDataOutputStream out = this.getDfs().create(this.testFile);
        out.close();
        TestErasureCodingApi.assertNotNull((Object)this.getDfs().getEncodingStatus(this.testFile.toUri().getPath()));
    }

    @Test
    public void testGetEncodingStatusIfRequested() throws IOException {
        Codec codec = Codec.getCodec((String)"src");
        EncodingPolicy policy = new EncodingPolicy(codec.getId(), 1);
        HdfsDataOutputStream out = this.getDfs().create(this.testFile, policy);
        out.close();
        EncodingStatus status = this.getDfs().getEncodingStatus(this.testFile.toUri().getPath());
        TestErasureCodingApi.assertNotNull((Object)status);
        TestErasureCodingApi.assertEquals((Object)EncodingStatus.Status.ENCODING_REQUESTED, (Object)status.getStatus());
    }

    public void testGetEncodingStatusForNonExistingFile() throws IOException {
        try {
            this.getDfs().getEncodingStatus("/DEAD_BEEF");
            TestErasureCodingApi.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetEncodingStatusIfNotRequested() throws IOException {
        FSDataOutputStream out = this.getDfs().create(this.testFile);
        out.close();
        EncodingStatus status = this.getDfs().getEncodingStatus(this.testFile.toUri().getPath());
        TestErasureCodingApi.assertNotNull((Object)status);
        TestErasureCodingApi.assertEquals((Object)EncodingStatus.Status.NOT_ENCODED, (Object)status.getStatus());
    }
}

