/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.Test;

public class TestLocalDFS {
    private void writeFile(FileSystem fileSys, Path name) throws IOException {
        FSDataOutputStream stm = fileSys.create(name);
        stm.writeBytes("oom");
        stm.close();
    }

    private void readFile(FileSystem fileSys, Path name) throws IOException {
        FSDataInputStream stm = fileSys.open(name);
        byte[] buffer = new byte[4];
        int bytesRead = stm.read(buffer, 0, 4);
        Assert.assertEquals((Object)"oom", (Object)new String(buffer, 0, bytesRead));
        stm.close();
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assert.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    static String getUserName(FileSystem fs) throws IOException {
        if (fs instanceof DistributedFileSystem) {
            return ((DistributedFileSystem)fs).dfs.ugi.getShortUserName();
        }
        return System.getProperty("user.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWorkingDirectory() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fileSys = cluster.getFileSystem();
        try {
            Path orig_path = fileSys.getWorkingDirectory();
            Assert.assertTrue((boolean)orig_path.isAbsolute());
            Path file1 = new Path("somewhat/random.txt");
            this.writeFile((FileSystem)fileSys, file1);
            Assert.assertTrue((boolean)fileSys.exists(new Path(orig_path, file1.toString())));
            fileSys.delete(file1, true);
            Path subdir1 = new Path("/somewhere");
            fileSys.setWorkingDirectory(subdir1);
            this.writeFile((FileSystem)fileSys, file1);
            this.cleanupFile((FileSystem)fileSys, new Path(subdir1, file1.toString()));
            Path subdir2 = new Path("else");
            fileSys.setWorkingDirectory(subdir2);
            this.writeFile((FileSystem)fileSys, file1);
            this.readFile((FileSystem)fileSys, file1);
            this.cleanupFile((FileSystem)fileSys, new Path(new Path(subdir1, subdir2.toString()), file1.toString()));
            Path home = fileSys.makeQualified(new Path("/user/" + TestLocalDFS.getUserName((FileSystem)fileSys)));
            Path fsHome = fileSys.getHomeDirectory();
            Assert.assertEquals((Object)home, (Object)fsHome);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testHomeDirectory() throws IOException {
        String[] homeBases = new String[]{"/home", "/home/user"};
        HdfsConfiguration conf = new HdfsConfiguration();
        for (String homeBase : homeBases) {
            conf.set("dfs.user.home.dir.prefix", homeBase);
            MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            try {
                Path home = fileSys.makeQualified(new Path(homeBase + "/" + TestLocalDFS.getUserName((FileSystem)fileSys)));
                Path fsHome = fileSys.getHomeDirectory();
                Assert.assertEquals((Object)home, (Object)fsHome);
            }
            finally {
                fileSys.close();
                cluster.shutdown();
            }
        }
    }
}

