/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import io.hops.TestUtil;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.MetadataLogDataAccess;
import io.hops.metadata.hdfs.dal.XAttrDataAccess;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.metadata.hdfs.entity.MetaStatus;
import io.hops.metadata.hdfs.entity.MetadataLogEntry;
import io.hops.metadata.hdfs.entity.StoredXAttr;
import io.hops.metadata.hdfs.entity.XAttrMetadataLogEntry;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.XAttrStorage;
import org.apache.hadoop.hdfs.server.namenode.XAttrTestHelpers;
import org.junit.Assert;
import org.junit.Test;

public class TestMetadataLog
extends TestCase {
    private static final int ANY_DATASET = -1;
    private static final String ANY_NAME = "-1";
    private static Comparator<MetadataLogEntry> LOGICAL_TIME_COMPARATOR = new Comparator<MetadataLogEntry>(){

        @Override
        public int compare(MetadataLogEntry o1, MetadataLogEntry o2) {
            return Integer.compare(o1.getLogicalTime(), o2.getLogicalTime());
        }
    };

    private boolean checkLog(INode inode, INodeMetadataLogEntry.Operation operation) throws IOException {
        return this.checkLog(null, inode, operation);
    }

    private boolean checkLog(INode dataset, INode inode, INodeMetadataLogEntry.Operation operation) throws IOException {
        long datasetId = dataset == null ? -1L : dataset.getId();
        Collection<MetadataLogEntry> logEntries = this.getMetadataLogEntries(inode.getId());
        for (MetadataLogEntry logEntry : logEntries) {
            if (logEntry.getOperationId() != operation.getId()) continue;
            return (datasetId == -1L || datasetId == logEntry.getDatasetId()) && inode.getPartitionId().longValue() == logEntry.getInodePartitionId() && inode.getParentId() == logEntry.getInodeParentId() && inode.getLocalName().equals(logEntry.getInodeName());
        }
        return false;
    }

    private boolean checkXAttrLogAddAll(INode dataset, INode inode) throws IOException {
        return this.checkXAttrLog(dataset, inode, ANY_NAME, (byte)-1, (short)-1, XAttrMetadataLogEntry.Operation.AddAll);
    }

    private boolean checkXAttrLog(INode dataset, INode inode, String xAttrName, XAttrMetadataLogEntry.Operation operation) throws IOException {
        return this.checkXAttrLog(dataset, inode, xAttrName, (byte)0, (short)1, operation);
    }

    private boolean checkXAttrLog(INode dataset, INode inode, String xAttrName, byte namesapce, short numParts, XAttrMetadataLogEntry.Operation operation) throws IOException {
        long datasetId = dataset == null ? -1L : dataset.getId();
        Collection<MetadataLogEntry> logEntries = this.getMetadataLogEntries(inode.getId());
        for (MetadataLogEntry logEntry : logEntries) {
            if (logEntry.getOperationId() != operation.getId()) continue;
            XAttrMetadataLogEntry xAttrLogEntry = (XAttrMetadataLogEntry)logEntry;
            return !(datasetId != -1L && datasetId != logEntry.getDatasetId() || !xAttrName.equals(ANY_NAME) && !xAttrName.equals(xAttrLogEntry.getName()) || namesapce != xAttrLogEntry.getNamespace() || numParts != xAttrLogEntry.getNumParts() || inode.getPartitionId().longValue() != logEntry.getInodePartitionId() || inode.getParentId() != logEntry.getInodeParentId() || !inode.getLocalName().equals(logEntry.getInodeName()));
        }
        return false;
    }

    private Collection<MetadataLogEntry> getMetadataLogEntries(INode inode) throws IOException {
        return this.getMetadataLogEntries(inode.getId());
    }

    private Collection<MetadataLogEntry> getMetadataLogEntries(final long inodeId) throws IOException {
        return (Collection)new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.GET_METADATA_LOG_ENTRIES){

            public Object performTask() throws IOException {
                MetadataLogDataAccess da = (MetadataLogDataAccess)HdfsStorageFactory.getDataAccess(MetadataLogDataAccess.class);
                return da.find(inodeId);
            }
        }.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonLoggingFolder() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path subdir = new Path(dataset, "subdir");
            Path file = new Path(dataset, "file");
            dfs.mkdirs(dataset, FsPermission.getDefault());
            dfs.mkdirs(subdir);
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), dataset), INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), subdir), INodeMetadataLogEntry.Operation.Add));
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), file), INodeMetadataLogEntry.Operation.Add));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreate() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path subdir = new Path(dataset, "subdir");
            Path file = new Path(subdir, "file");
            dfs.mkdirs(dataset, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            dfs.mkdirs(subdir);
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), dataset), INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), subdir), INodeMetadataLogEntry.Operation.Add));
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), file), INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, subdir, file}, new int[]{1, 1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path subdir = new Path(dataset, "subdir");
            Path file = new Path(subdir, "file");
            dfs.mkdirs(dataset, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            dfs.mkdirs(subdir);
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), dataset), INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), subdir), INodeMetadataLogEntry.Operation.Add));
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            INode inode = TestUtil.getINode(cluster.getNameNode(), file);
            TestMetadataLog.assertTrue((boolean)this.checkLog(inode, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, subdir, file}, new int[]{1, 1, 1});
            dfs.append(file).close();
            dfs.append(file).close();
            ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inode));
            Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
            TestMetadataLog.assertTrue((inodeLogEntries.size() == 3 ? 1 : 0) != 0);
            for (int i = 0; i < 3; ++i) {
                TestMetadataLog.assertEquals((int)(i + 1), (int)((MetadataLogEntry)inodeLogEntries.get(i)).getLogicalTime());
                TestMetadataLog.assertTrue((((INodeMetadataLogEntry)inodeLogEntries.get(i)).getOperation() == INodeMetadataLogEntry.Operation.Add ? 1 : 0) != 0);
            }
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, subdir, file}, new int[]{1, 1, 3});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoLogEntryBeforeClosing() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path file = new Path(dataset, "file");
            dfs.mkdirs(dataset, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), dataset), INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), file), INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, file}, new int[]{1, 0});
            out.close();
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), file), INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, file}, new int[]{1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            INode inodeId = TestUtil.getINode(cluster.getNameNode(), file);
            INode folderId = TestUtil.getINode(cluster.getNameNode(), folder);
            INode datasetId = TestUtil.getINode(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{1, 1, 1});
            dfs.delete(folder, true);
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Delete));
            this.checkLogicalTimeDeleteAfterAdd(new INode[]{folderId, inodeId});
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset}, new int[]{1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testOldRename() throws Exception {
        this.testRename(true);
    }

    @Test
    public void testRename() throws Exception {
        this.testRename(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRename(boolean oldRename) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset0 = new Path(project, "dataset0");
            Path dataset1 = new Path(project, "dataset1");
            Path file0 = new Path(dataset0, "file");
            Path file1 = new Path(dataset1, "file");
            dfs.mkdirs(dataset0, FsPermission.getDefault());
            dfs.mkdirs(dataset1, FsPermission.getDefault());
            dfs.setMetaStatus(dataset0, MetaStatus.META_ENABLED);
            dfs.setMetaStatus(dataset1, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file0, 1);
            out.close();
            INode file0Id = TestUtil.getINode(cluster.getNameNode(), file0);
            INode dataset0Id = TestUtil.getINode(cluster.getNameNode(), dataset0);
            INode dataset1Id = TestUtil.getINode(cluster.getNameNode(), dataset1);
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset0Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(file0Id, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset0, dataset1, file0}, new int[]{1, 1, 1});
            if (oldRename) {
                TestMetadataLog.assertTrue((boolean)dfs.rename(file0, file1));
            } else {
                dfs.rename(file0, file1, new Options.Rename[]{Options.Rename.NONE});
            }
            INode file1Id = TestUtil.getINode(cluster.getNameNode(), file1);
            TestMetadataLog.assertEquals((long)file0Id.getId(), (long)file1Id.getId());
            TestMetadataLog.assertFalse((boolean)this.checkLog(dataset1Id, file0Id, INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, file1Id, INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(file0Id).size());
            this.checkLogicalTimeAddRename(file0Id);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset0, dataset1, file1}, new int[]{1, 1, 2});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testDeepOldRename() throws Exception {
        this.testDeepRename(true);
    }

    @Test
    public void testDeepRename() throws Exception {
        this.testDeepRename(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeepRename(boolean oldRename) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset0 = new Path(project, "dataset0");
            Path folder0 = new Path(dataset0, "folder0");
            Path dataset1 = new Path(project, "dataset1");
            Path folder1 = new Path(dataset1, "folder1");
            Path file0 = new Path(folder0, "file");
            dfs.mkdirs(folder0, FsPermission.getDefault());
            dfs.mkdirs(dataset1, FsPermission.getDefault());
            dfs.setMetaStatus(dataset0, MetaStatus.META_ENABLED);
            dfs.setMetaStatus(dataset1, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file0, 1);
            out.close();
            INode inodeId = TestUtil.getINode(cluster.getNameNode(), file0);
            INode folder0Id = TestUtil.getINode(cluster.getNameNode(), folder0);
            INode dataset0Id = TestUtil.getINode(cluster.getNameNode(), dataset0);
            INode dataset1Id = TestUtil.getINode(cluster.getNameNode(), dataset1);
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset0Id, dataset0Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset0Id, folder0Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset0Id, inodeId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, dataset1Id, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset0, dataset1, folder0, file0}, new int[]{1, 1, 1, 1});
            if (oldRename) {
                dfs.rename(folder0, folder1);
            } else {
                dfs.rename(folder0, folder1, new Options.Rename[]{Options.Rename.NONE});
            }
            INode folder1Id = TestUtil.getINode(cluster.getNameNode(), folder1);
            TestMetadataLog.assertEquals((long)folder0Id.getId(), (long)folder1Id.getId());
            TestMetadataLog.assertFalse((boolean)this.checkLog(dataset1Id, folder0Id, INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, folder1Id, INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, inodeId, INodeMetadataLogEntry.Operation.ChangeDataset));
            this.checkLogicalTimeAddRename(folder0Id);
            this.checkLogicalTimeAddRChangeDataset(inodeId);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset0, dataset1, folder1, new Path(folder1, file0.getName())}, new int[]{1, 1, 2, 2});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableLogForExistingDirectory() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{projects, project, dataset, folder, file}, new int[]{0, 0, 0, 0, 0});
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            INode inodeId = TestUtil.getINode(cluster.getNameNode(), file);
            INode folderId = TestUtil.getINode(cluster.getNameNode(), folder);
            INode datasetId = TestUtil.getINode(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{projects, project, dataset, folder, file}, new int[]{0, 0, 1, 1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFileWhileOpen() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean BYTES_PER_CHECKSUM = true;
        boolean PACKET_SIZE = true;
        boolean BLOCK_SIZE = true;
        conf.setInt("dfs.bytes-per-checksum", 1);
        conf.setLong("dfs.blocksize", 1L);
        conf.setInt("dfs.client-write-packet-size", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            FSDataOutputStream out = dfs.create(file);
            out.writeByte(0);
            INode inodeId = TestUtil.getINode(cluster.getNameNode(), file);
            INode folderId = TestUtil.getINode(cluster.getNameNode(), folder);
            INode datasetId = TestUtil.getINode(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertFalse((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{1, 1, 0});
            DistributedFileSystem dfs2 = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
            try {
                dfs2.delete(file, false);
            }
            catch (Exception ex) {
                TestMetadataLog.fail((String)("we shouldn't have any exception: " + ex.getMessage()));
            }
            TestMetadataLog.assertFalse((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Delete));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder}, new int[]{1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testDeepOldRenameInTheSameDataset() throws Exception {
        this.testDeepRenameInTheSameDataset(true);
    }

    @Test
    public void testDeepRenameInTheSameDataset() throws Exception {
        this.testDeepRenameInTheSameDataset(false);
    }

    @Test
    public void testOldDeepRenameToNonMetaEnabledDir() throws Exception {
        this.testDeepRenameToNonMetaEnabledDir(true);
    }

    @Test
    public void testDeepRenameToNonMetaEnabledDir() throws Exception {
        this.testDeepRenameToNonMetaEnabledDir(false);
    }

    @Test
    public void testDeleteDatasetAfterOldRename() throws Exception {
        this.testDeleteDatasetAfterRename(true);
    }

    @Test
    public void testDeleteDatasetAfterRename() throws Exception {
        this.testDeleteDatasetAfterRename(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeepRenameInTheSameDataset(boolean oldRename) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder0 = new Path(dataset, "folder0");
            Path folder1 = new Path(folder0, "folder1");
            Path file = new Path(folder1, "file");
            Path newFolder = new Path(dataset, "newFolder");
            dfs.mkdirs(folder1, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            INode inodeId = TestUtil.getINode(cluster.getNameNode(), file);
            INode folder0Id = TestUtil.getINode(cluster.getNameNode(), folder0);
            INode folder1Id = TestUtil.getINode(cluster.getNameNode(), folder1);
            INode datasetId = TestUtil.getINode(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder0, folder1, file}, new int[]{1, 1, 1, 1});
            if (oldRename) {
                dfs.rename(folder0, newFolder);
            } else {
                dfs.rename(folder0, newFolder, new Options.Rename[]{Options.Rename.NONE});
            }
            INode newFolderId = TestUtil.getINode(cluster.getNameNode(), newFolder);
            TestMetadataLog.assertEquals((long)folder0Id.getId(), (long)newFolderId.getId());
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, folder0Id, INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, newFolderId, INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged during a rename in the same dataset", (int)1, (int)this.getMetadataLogEntries(folder1Id).size());
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged during a rename in the same dataset", (int)1, (int)this.getMetadataLogEntries(inodeId).size());
            this.checkLogicalTimeAddRename(folder0Id);
            Path newFolder1 = new Path(newFolder, folder1.getName());
            Path newFile = new Path(newFolder1, file.getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, newFolder, newFolder1, newFile}, new int[]{1, 2, 1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeepRenameToNonMetaEnabledDir(boolean oldRename) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder0 = new Path(dataset, "folder0");
            Path folder1 = new Path(folder0, "folder1");
            Path file = new Path(folder1, "file");
            Path newFolder = new Path(project, "newFolder");
            dfs.mkdirs(folder1, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            INode inodeId = TestUtil.getINode(cluster.getNameNode(), file);
            INode folder0Id = TestUtil.getINode(cluster.getNameNode(), folder0);
            INode folder1Id = TestUtil.getINode(cluster.getNameNode(), folder1);
            INode datasetId = TestUtil.getINode(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder0, folder1, file}, new int[]{1, 1, 1, 1});
            if (oldRename) {
                dfs.rename(folder0, newFolder);
            } else {
                dfs.rename(folder0, newFolder, new Options.Rename[]{Options.Rename.NONE});
            }
            INode newFolderId = TestUtil.getINode(cluster.getNameNode(), newFolder);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, inodeId, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, newFolderId, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged for addition during a move to a non MetaEnabled directoy", (int)2, (int)this.getMetadataLogEntries(folder1Id).size());
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged for addition during a move to a non MetaEnabled directoy", (int)2, (int)this.getMetadataLogEntries(inodeId).size());
            this.checkLogicalTimeDeleteAfterAdd(new INode[]{folder0Id, folder1Id, inodeId});
            Path newFolder1 = new Path(newFolder, folder1.getName());
            Path newFile = new Path(newFolder1, file.getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, newFolder, newFolder1, newFile}, new int[]{1, 2, 2, 2});
            if (oldRename) {
                dfs.rename(newFolder, folder0);
            } else {
                dfs.rename(newFolder, folder0, new Options.Rename[]{Options.Rename.NONE});
            }
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeAddDeleteAdd(folder0Id);
            this.checkLogicalTimeAddDeleteAdd(folder1Id);
            this.checkLogicalTimeAddDeleteAdd(inodeId);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder0, folder1, file}, new int[]{1, 3, 3, 3});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteDatasetAfterRename(boolean oldRename) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dataset = new Path("/dataset");
            Path folder1 = new Path(dataset, "folder1");
            Path folder2 = new Path(folder1, "folder2");
            Path folder3 = new Path(folder2, "folder3");
            dfs.mkdirs(folder3, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            INode datasetId = TestUtil.getINode(cluster.getNameNode(), dataset);
            INode folder1Id = TestUtil.getINode(cluster.getNameNode(), folder1);
            INode folder2Id = TestUtil.getINode(cluster.getNameNode(), folder2);
            INode folder3Id = TestUtil.getINode(cluster.getNameNode(), folder3);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder2Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder3Id, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder1, folder2, folder3}, new int[]{1, 1, 1, 1});
            Path file1 = new Path(folder3, "file1");
            TestFileCreation.create(dfs, file1, 1).close();
            Path file2 = new Path(folder3, "file2");
            TestFileCreation.create(dfs, file2, 1).close();
            INode file1Id = TestUtil.getINode(cluster.getNameNode(), file1);
            INode file2Id = TestUtil.getINode(cluster.getNameNode(), file2);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, file1Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, file2Id, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder1, folder2, folder3, file1, file2}, new int[]{1, 1, 1, 1, 1, 1});
            Path newDataset = new Path("/newDataset");
            if (oldRename) {
                dfs.rename(dataset, newDataset);
            } else {
                dfs.rename(dataset, newDataset, new Options.Rename[]{Options.Rename.NONE});
            }
            INode newDatasetId = TestUtil.getINode(cluster.getNameNode(), newDataset);
            TestMetadataLog.assertEquals((long)newDatasetId.getId(), (long)datasetId.getId());
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, datasetId, INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, newDatasetId, INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, folder1Id, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, folder2Id, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, folder3Id, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, file1Id, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, file2Id, INodeMetadataLogEntry.Operation.Delete));
            Path newFolder1 = new Path(newDataset, folder1.getName());
            Path newFolder2 = new Path(newFolder1, folder2.getName());
            Path newFolder3 = new Path(newFolder2, folder3.getName());
            Path newFile1 = new Path(newFolder3, file1.getName());
            Path newFile2 = new Path(newFolder3, file2.getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{newDataset, newFolder1, newFolder2, newFolder3, newFile1, newFile2}, new int[]{2, 1, 1, 1, 1, 1});
            TestMetadataLog.assertTrue((boolean)dfs.delete(newDataset, true));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, newDatasetId, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder2Id, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder3Id, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, file1Id, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, file2Id, INodeMetadataLogEntry.Operation.Delete));
            this.checkLogicalTimeDeleteAfterAdd(new INode[]{folder1Id, folder2Id, folder3Id, file1Id, file2Id});
            this.checkLogicalTimeAddRenameDelete(datasetId);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingAndUnsettingMetaEnabled() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            INode inodeId = TestUtil.getINode(cluster.getNameNode(), file);
            INode folderId = TestUtil.getINode(cluster.getNameNode(), folder);
            INode datasetId = TestUtil.getINode(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{1, 1, 1});
            dfs.setMetaStatus(dataset, MetaStatus.DISABLED);
            TestMetadataLog.assertEquals((int)1, (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)1, (int)this.getMetadataLogEntries(folderId).size());
            TestMetadataLog.assertEquals((int)1, (int)this.getMetadataLogEntries(datasetId).size());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{1, 1, 1});
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(folderId).size());
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(datasetId).size());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{2, 2, 2});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void checkLogicalTimeDeleteAfterAdd(INode[] inodes) throws IOException {
        for (INode inode : inodes) {
            ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inode));
            Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
            TestMetadataLog.assertTrue((inodeLogEntries.size() == 2 ? 1 : 0) != 0);
            TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperationId() == INodeMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
            TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperationId() == INodeMetadataLogEntry.Operation.Delete.getId() ? 1 : 0) != 0);
        }
    }

    private void checkLogicalTimeAddDeleteAdd(INode inode) throws IOException {
        ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inode));
        Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((inodeLogEntries.size() == 3 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperationId() == INodeMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperationId() == INodeMetadataLogEntry.Operation.Delete.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(2)).getOperationId() == INodeMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
    }

    private void checkLogicalTimeAddRenameDelete(INode inode) throws IOException {
        ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inode));
        Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((inodeLogEntries.size() == 3 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperationId() == INodeMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperationId() == INodeMetadataLogEntry.Operation.Rename.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(2)).getOperationId() == INodeMetadataLogEntry.Operation.Delete.getId() ? 1 : 0) != 0);
    }

    private void checkLogicalTimeAddRename(INode inode) throws IOException {
        ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inode));
        Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((inodeLogEntries.size() == 2 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperationId() == INodeMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperationId() == INodeMetadataLogEntry.Operation.Rename.getId() ? 1 : 0) != 0);
    }

    private void checkLogicalTimeAddRChangeDataset(INode inode) throws IOException {
        ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inode));
        Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((inodeLogEntries.size() == 2 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperationId() == INodeMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperationId() == INodeMetadataLogEntry.Operation.ChangeDataset.getId() ? 1 : 0) != 0);
    }

    private void checkLogicalTimeForINodes(NameNode nameNode, Path[] inodesPaths, int[] logicalTimes) throws IOException {
        int i = 0;
        for (Path path : inodesPaths) {
            TestMetadataLog.assertEquals((int)logicalTimes[i], (int)TestUtil.getINode(nameNode, path).getLogicalTime());
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXAttrNonLogginFolder() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        String name1 = "user.metadata";
        byte[] value1 = "this file metadata".getBytes(Charsets.UTF_8);
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            dfs.mkdirs(dir);
            Path file = new Path(dir, "file");
            DFSTestUtil.createFile((FileSystem)dfs, file, 0L, (short)1, 0L);
            INode inodeId = TestUtil.getINode(cluster.getNameNode(), file);
            INode datasetId = TestUtil.getINode(cluster.getNameNode(), dir);
            TestMetadataLog.assertTrue((boolean)this.getMetadataLogEntries(inodeId).isEmpty());
            dfs.setXAttr(file, "user.metadata", value1);
            TestMetadataLog.assertTrue((boolean)this.getMetadataLogEntries(inodeId).isEmpty());
            dfs.setMetaStatus(dir, MetaStatus.META_ENABLED);
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertTrue((boolean)this.checkXAttrLogAddAll(datasetId, inodeId));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, inodeId, INodeMetadataLogEntry.Operation.Add));
            dfs.delete(file, true);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, inodeId, INodeMetadataLogEntry.Operation.Delete));
            this.checkIfNoXAttrsForINode(inodeId);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXAttrOnMetaEnabledDir() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        String name1 = "user.metadata";
        byte[] value1 = "this file metadata".getBytes(Charsets.UTF_8);
        String name2 = "user.path";
        byte[] value2 = "/this/is/my/test/path/".getBytes(Charsets.UTF_8);
        byte[] value3 = "/replace/the/old/path".getBytes(Charsets.UTF_8);
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            dfs.mkdirs(dir);
            dfs.setMetaStatus(dir, MetaStatus.META_ENABLED);
            Path file = new Path(dir, "file");
            DFSTestUtil.createFile((FileSystem)dfs, file, 0L, (short)1, 0L);
            INode inodeId = TestUtil.getINode(cluster.getNameNode(), file);
            INode datasetId = TestUtil.getINode(cluster.getNameNode(), dir);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file, dir}, new int[]{1, 1});
            dfs.setXAttr(file, "user.metadata", value1);
            TestMetadataLog.assertTrue((boolean)Arrays.equals(value1, dfs.getXAttr(file, "user.metadata")));
            TestMetadataLog.assertTrue((boolean)this.checkXAttrLog(datasetId, inodeId, XAttrHelper.buildXAttr((String)"user.metadata").getName(), XAttrMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(inodeId).size());
            dfs.setXAttr(file, "user.path", value2);
            TestMetadataLog.assertTrue((boolean)Arrays.equals(value2, dfs.getXAttr(file, "user.path")));
            TestMetadataLog.assertTrue((boolean)this.checkXAttrLog(datasetId, inodeId, XAttrHelper.buildXAttr((String)"user.path").getName(), XAttrMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertEquals((int)3, (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)3, (int)TestUtil.getINode(cluster.getNameNode(), file).getLogicalTime());
            dfs.removeXAttr(file, "user.metadata");
            this.checkXAttrLogicalTimeAddDelete(inodeId, XAttrHelper.buildXAttr((String)"user.metadata").getName());
            TestMetadataLog.assertEquals((int)4, (int)TestUtil.getINode(cluster.getNameNode(), file).getLogicalTime());
            dfs.setXAttr(file, "user.path", value3);
            TestMetadataLog.assertTrue((boolean)Arrays.equals(value3, dfs.getXAttr(file, "user.path")));
            TestMetadataLog.assertEquals((int)5, (int)TestUtil.getINode(cluster.getNameNode(), file).getLogicalTime());
            dfs.removeXAttr(file, "user.path");
            this.checkXAttrLogicalTimeAddUpdateDelete(inodeId, XAttrHelper.buildXAttr((String)"user.path").getName());
            TestMetadataLog.assertEquals((int)6, (int)TestUtil.getINode(cluster.getNameNode(), file).getLogicalTime());
            dfs.setXAttr(dir, "user.metadata", value1);
            TestMetadataLog.assertTrue((boolean)Arrays.equals(value1, dfs.getXAttr(dir, "user.metadata")));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file, dir}, new int[]{6, 2});
            dfs.setXAttr(dir, "user.metadata", value2);
            TestMetadataLog.assertTrue((boolean)Arrays.equals(value2, dfs.getXAttr(dir, "user.metadata")));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file, dir}, new int[]{6, 3});
            dfs.setXAttr(dir, "user.path", value3);
            TestMetadataLog.assertTrue((boolean)Arrays.equals(value3, dfs.getXAttr(dir, "user.path")));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file, dir}, new int[]{6, 4});
            dfs.removeXAttr(dir, "user.metadata");
            this.checkXAttrLogicalTimeAddUpdateDelete(datasetId, XAttrHelper.buildXAttr((String)"user.metadata").getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file, dir}, new int[]{6, 5});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void checkXAttrLogicalTimeAddDelete(INode inode, final String name) throws IOException {
        ArrayList<MetadataLogEntry> allEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inode));
        Collection filtered = Collections2.filter(allEntries, (Predicate)new Predicate<MetadataLogEntry>(){

            public boolean apply(@Nullable MetadataLogEntry logEntry) {
                if (logEntry instanceof XAttrMetadataLogEntry) {
                    return ((XAttrMetadataLogEntry)logEntry).getName().equals(name);
                }
                return false;
            }
        });
        ArrayList xAttrLogEntries = new ArrayList(filtered);
        Collections.sort(xAttrLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((xAttrLogEntries.size() == 2 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)xAttrLogEntries.get(0)).getOperationId() == XAttrMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)xAttrLogEntries.get(1)).getOperationId() == XAttrMetadataLogEntry.Operation.Delete.getId() ? 1 : 0) != 0);
    }

    private void checkXAttrLogicalTimeAddUpdateDelete(INode inode, final String name) throws IOException {
        ArrayList<MetadataLogEntry> allEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inode));
        Collection filtered = Collections2.filter(allEntries, (Predicate)new Predicate<MetadataLogEntry>(){

            public boolean apply(@Nullable MetadataLogEntry logEntry) {
                if (logEntry instanceof XAttrMetadataLogEntry) {
                    return ((XAttrMetadataLogEntry)logEntry).getName().equals(name);
                }
                return false;
            }
        });
        ArrayList xAttrLogEntries = new ArrayList(filtered);
        Collections.sort(xAttrLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((xAttrLogEntries.size() == 3 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)xAttrLogEntries.get(0)).getOperationId() == XAttrMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)xAttrLogEntries.get(1)).getOperationId() == XAttrMetadataLogEntry.Operation.Update.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)xAttrLogEntries.get(2)).getOperationId() == XAttrMetadataLogEntry.Operation.Delete.getId() ? 1 : 0) != 0);
    }

    private boolean checkIfNoXAttrsForINode(final INode inode) throws IOException {
        return (Boolean)new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                XAttrDataAccess da = (XAttrDataAccess)HdfsStorageFactory.getDataAccess(XAttrDataAccess.class);
                return da.getXAttrsByInodeId(inode.getId()) == null;
            }
        }.handle();
    }

    @Test
    public void testRenameDataset() throws Exception {
        this.testRenameDataset(false);
    }

    @Test
    public void testOldRenameDataset() throws Exception {
        this.testRenameDataset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRenameDataset(boolean oldRename) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder0 = new Path(dataset, "folder0");
            Path folder1 = new Path(folder0, "folder1");
            Path file = new Path(folder1, "file");
            Path newDataset = new Path(project, "newDataset");
            dfs.mkdirs(folder1, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            INode inodeId = TestUtil.getINode(cluster.getNameNode(), file);
            INode folder0Id = TestUtil.getINode(cluster.getNameNode(), folder0);
            INode folder1Id = TestUtil.getINode(cluster.getNameNode(), folder1);
            INode datasetId = TestUtil.getINode(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{projects, project, dataset, folder0, folder1, file}, new int[]{0, 0, 1, 1, 1, 1});
            if (oldRename) {
                dfs.rename(dataset, newDataset);
            } else {
                dfs.rename(dataset, newDataset, new Options.Rename[]{Options.Rename.NONE});
            }
            INode newDatasetId = TestUtil.getINode(cluster.getNameNode(), newDataset);
            TestMetadataLog.assertEquals((long)datasetId.getId(), (long)newDatasetId.getId());
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, datasetId, INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, newDatasetId, INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged during a rename in the same dataset", (int)1, (int)this.getMetadataLogEntries(folder1Id).size());
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged during a rename in the same dataset", (int)1, (int)this.getMetadataLogEntries(folder0Id).size());
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged during a rename in the same dataset", (int)1, (int)this.getMetadataLogEntries(inodeId).size());
            Path newFolder0 = new Path(newDataset, folder0.getName());
            Path newFolder1 = new Path(newFolder0, folder1.getName());
            Path newFile = new Path(newFolder1, file.getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{newDataset, newFolder0, newFolder1, newFile}, new int[]{2, 1, 1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetMetaEnabledOnNonExistingDirectory() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path root = new Path("/");
            Path dir = new Path(root, "dir");
            try {
                dfs.setMetaStatus(dir, MetaStatus.META_ENABLED);
                TestMetadataLog.fail((String)"should fail to set metaEnabled on non existing directory");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            dfs.mkdirs(dir, FsPermission.getDefault());
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), dir), INodeMetadataLogEntry.Operation.Add));
            dfs.setMetaStatus(dir, MetaStatus.META_ENABLED);
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), dir), INodeMetadataLogEntry.Operation.Add));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetMetaEnabledOnRoot() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path root = new Path("/");
            Path dir = new Path(root, "dir");
            dfs.mkdirs(dir, FsPermission.getDefault());
            try {
                dfs.setMetaStatus(root, MetaStatus.META_ENABLED);
                TestMetadataLog.fail((String)"should fail to set metaEnabled on the root since subtree locks are disabled for the root");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), dir), INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINode(cluster.getNameNode(), root), INodeMetadataLogEntry.Operation.Add));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testLargeXAttrMetaEnabled_27KB() throws Exception {
        this.testLargeXAttrMetaEnabled(2, 5);
    }

    @Test
    public void testLargeXAttrMetaEnabled_135KB() throws Exception {
        this.testLargeXAttrMetaEnabled(10, 5);
    }

    @Test
    public void testLargeXAttrMetaEnabled_1_3MB() throws Exception {
        this.testLargeXAttrMetaEnabled(100, 5);
    }

    @Test
    public void testLargeXAttrMetaEnabled_3_44MB() throws Exception {
        this.testLargeXAttrMetaEnabled(255, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLargeXAttrMetaEnabled(int rows, int numXAttrs) throws Exception {
        int MAX_VALUE_SIZE = rows * XAttrStorage.getDefaultXAttrValueSize();
        int MAX_SIZE = XAttrStorage.getMaxXAttrNameSize() + MAX_VALUE_SIZE;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", numXAttrs);
        conf.setInt("dfs.namenode.fs-limits.max-xattr-size", MAX_SIZE);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        try {
            int i;
            String name;
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            dfs.mkdirs(dir);
            dfs.setMetaStatus(dir, MetaStatus.META_ENABLED);
            Path file = new Path(dir, "file");
            DFSTestUtil.createFile((FileSystem)dfs, file, 0L, (short)1, 0L);
            INode inodeId = TestUtil.getINode(cluster.getNameNode(), file);
            INode datasetId = TestUtil.getINode(cluster.getNameNode(), dir);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file, dir}, new int[]{1, 1});
            String nameBase = "user.test";
            HashMap<String, byte[]> testXAttrs = new HashMap<String, byte[]>();
            for (int i2 = 0; i2 < numXAttrs; ++i2) {
                Iterator name2 = "user.test" + i2;
                byte[] value = XAttrTestHelpers.generateRandomByteArrayWithRandomSize(MAX_VALUE_SIZE);
                testXAttrs.put((String)((Object)name2), value);
                dfs.setXAttr(file, (String)((Object)name2), value);
                byte[] returnedValue = dfs.getXAttr(file, (String)((Object)name2));
                Assert.assertArrayEquals((byte[])value, (byte[])returnedValue);
            }
            this.checkAllXAttrLogs(datasetId, inodeId, testXAttrs, XAttrMetadataLogEntry.Operation.Add);
            TestMetadataLog.assertEquals((int)(numXAttrs + 1), (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)(numXAttrs + 1), (int)TestUtil.getINode(cluster.getNameNode(), file).getLogicalTime());
            Map returnedXAttrs = dfs.getXAttrs(file);
            TestMetadataLog.assertEquals((int)numXAttrs, (int)returnedXAttrs.size());
            for (Map.Entry entry : testXAttrs.entrySet()) {
                Assert.assertArrayEquals((byte[])((byte[])returnedXAttrs.get(entry.getKey())), (byte[])((byte[])entry.getValue()));
            }
            returnedXAttrs = dfs.getXAttrs(file, new ArrayList(testXAttrs.keySet()));
            TestMetadataLog.assertEquals((int)numXAttrs, (int)returnedXAttrs.size());
            for (Map.Entry entry : testXAttrs.entrySet()) {
                Assert.assertArrayEquals((byte[])((byte[])returnedXAttrs.get(entry.getKey())), (byte[])((byte[])entry.getValue()));
            }
            for (int i3 = 0; i3 < numXAttrs; ++i3) {
                name = "user.test" + i3;
                byte[] value = XAttrTestHelpers.generateRandomByteArrayWithRandomSize(MAX_VALUE_SIZE);
                testXAttrs.put(name, value);
                dfs.setXAttr(file, name, value, EnumSet.of(XAttrSetFlag.REPLACE));
                byte[] returnedValue = dfs.getXAttr(file, name);
                Assert.assertArrayEquals((byte[])value, (byte[])returnedValue);
            }
            this.checkAllXAttrLogs(datasetId, inodeId, testXAttrs, XAttrMetadataLogEntry.Operation.Update);
            TestMetadataLog.assertEquals((int)(2 * numXAttrs + 1), (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)(2 * numXAttrs + 1), (int)TestUtil.getINode(cluster.getNameNode(), file).getLogicalTime());
            returnedXAttrs = dfs.getXAttrs(file);
            TestMetadataLog.assertEquals((int)numXAttrs, (int)returnedXAttrs.size());
            for (Map.Entry entry : testXAttrs.entrySet()) {
                Assert.assertArrayEquals((byte[])((byte[])returnedXAttrs.get(entry.getKey())), (byte[])((byte[])entry.getValue()));
            }
            for (i = 0; i < numXAttrs; ++i) {
                name = "user.test" + i;
                dfs.removeXAttr(file, name);
                returnedXAttrs = dfs.getXAttrs(file);
                TestMetadataLog.assertEquals((int)(numXAttrs - (i + 1)), (int)returnedXAttrs.size());
                for (Map.Entry entry : returnedXAttrs.entrySet()) {
                    Assert.assertArrayEquals((byte[])((byte[])entry.getValue()), (byte[])((byte[])testXAttrs.get(entry.getKey())));
                }
            }
            for (i = 0; i < numXAttrs; ++i) {
                XAttr xAttr = XAttrHelper.buildXAttr((String)("user.test" + i));
                this.checkXAttrLogicalTimeAddUpdateDelete(inodeId, xAttr.getName());
            }
            TestMetadataLog.assertEquals((int)(3 * numXAttrs + 1), (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)(3 * numXAttrs + 1), (int)TestUtil.getINode(cluster.getNameNode(), file).getLogicalTime());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void checkAllXAttrLogs(INode dataset, INode inode, Map<String, byte[]> xAttrs, XAttrMetadataLogEntry.Operation operation) throws IOException {
        ArrayList<MetadataLogEntry> allEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inode));
        HashMap<String, XAttrMetadataLogEntry> logEntriesByName = new HashMap<String, XAttrMetadataLogEntry>();
        for (MetadataLogEntry logEntry : allEntries) {
            XAttrMetadataLogEntry xAttrMetadataLogEntry;
            if (!(logEntry instanceof XAttrMetadataLogEntry) || (xAttrMetadataLogEntry = (XAttrMetadataLogEntry)logEntry).getOperation() != operation) continue;
            logEntriesByName.put(xAttrMetadataLogEntry.getName(), xAttrMetadataLogEntry);
        }
        int totalNumOfParts = 0;
        TestMetadataLog.assertEquals((int)xAttrs.size(), (int)logEntriesByName.size());
        for (Map.Entry<String, byte[]> xattrEntry : xAttrs.entrySet()) {
            XAttr xAttr = XAttrHelper.buildXAttr((String)xattrEntry.getKey());
            XAttrMetadataLogEntry logEntry = (XAttrMetadataLogEntry)logEntriesByName.get(xAttr.getName());
            TestMetadataLog.assertNotNull((Object)logEntry);
            TestMetadataLog.assertEquals((long)dataset.getId(), (long)logEntry.getDatasetId());
            TestMetadataLog.assertEquals((long)inode.getId(), (long)logEntry.getInodeId());
            TestMetadataLog.assertEquals((String)inode.getLocalName(), (String)logEntry.getInodeName());
            TestMetadataLog.assertEquals((long)inode.getParentId(), (long)logEntry.getInodeParentId());
            TestMetadataLog.assertTrue((inode.getPartitionId().longValue() == logEntry.getInodePartitionId() ? 1 : 0) != 0);
            TestMetadataLog.assertEquals((String)xAttr.getName(), (String)logEntry.getName());
            TestMetadataLog.assertEquals((byte)xAttr.getNameSpace().getId(), (byte)logEntry.getNamespace());
            TestMetadataLog.assertEquals((short)StoredXAttr.getNumParts((byte[])xattrEntry.getValue()), (short)logEntry.getNumParts());
            totalNumOfParts += logEntry.getNumParts();
        }
        TestMetadataLog.assertEquals((int)totalNumOfParts, (int)XAttrTestHelpers.getXAttrTableRowCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingAndUnsettingMetaEnabledOnDirWithXAttrs() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 2);
        conf.setInt("dfs.namenode.fs-limits.max-xattr-size", 100);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            TestFileCreation.create(dfs, file, 1).close();
            String name1 = "user.test1";
            byte[] value1 = "this is my test value".getBytes();
            String name2 = "user.test2";
            byte[] value2 = "this is my test value2".getBytes();
            dfs.setXAttr(dataset, name1, value1);
            dfs.setXAttr(dataset, name2, value2);
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            INode inodeId = TestUtil.getINode(cluster.getNameNode(), file);
            INode folderId = TestUtil.getINode(cluster.getNameNode(), folder);
            INode datasetId = TestUtil.getINode(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkXAttrLogAddAll(datasetId, datasetId));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{2, 1, 1});
            dfs.setMetaStatus(dataset, MetaStatus.DISABLED);
            TestMetadataLog.assertEquals((int)1, (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)1, (int)this.getMetadataLogEntries(folderId).size());
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(datasetId).size());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{2, 1, 1});
            dfs.setXAttr(folder, name1, value1);
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            TestMetadataLog.assertTrue((boolean)this.checkXAttrLogAddAll(datasetId, folderId));
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)3, (int)this.getMetadataLogEntries(folderId).size());
            TestMetadataLog.assertEquals((int)4, (int)this.getMetadataLogEntries(datasetId).size());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{4, 3, 2});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

