/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.junit.Assert;
import org.junit.Test;

public class TestRollingUpgrade {
    private static final Log LOG = LogFactory.getLog(TestRollingUpgrade.class);

    public static void runCmd(DFSAdmin dfsadmin, boolean success, String ... args) throws Exception {
        if (success) {
            Assert.assertEquals((long)0L, (long)dfsadmin.run(args));
        } else {
            Assert.assertTrue((dfsadmin.run(args) != 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSAdminRollingUpgradeCommands() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            Path foo = new Path("/foo");
            Path bar = new Path("/bar");
            Path baz = new Path("/baz");
            DistributedFileSystem dfs = cluster.getFileSystem();
            DFSAdmin dfsadmin = new DFSAdmin((Configuration)conf);
            dfs.mkdirs(foo);
            TestRollingUpgrade.runCmd(dfsadmin, false, "-rollingUpgrade", "abc");
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade");
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "prepare");
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "query");
            dfs.mkdirs(bar);
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "finalize");
            dfs.mkdirs(baz);
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade");
            Assert.assertTrue((boolean)dfs.exists(foo));
            Assert.assertTrue((boolean)dfs.exists(bar));
            Assert.assertTrue((boolean)dfs.exists(baz));
            cluster.restartNameNode(new String[0]);
            dfs = cluster.getFileSystem();
            Assert.assertTrue((boolean)dfs.exists(foo));
            Assert.assertTrue((boolean)dfs.exists(bar));
            Assert.assertTrue((boolean)dfs.exists(baz));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSAdminDatanodeUpgradeControlCommands() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DFSAdmin dfsadmin = new DFSAdmin((Configuration)conf);
            DataNode dn = cluster.getDataNodes().get(0);
            String dnAddr = dn.getDatanodeId().getIpcAddr(false);
            String[] args1 = new String[]{"-getDatanodeInfo", dnAddr};
            Assert.assertEquals((long)0L, (long)dfsadmin.run(args1));
            String[] args2 = new String[]{"-shutdownDatanode", dnAddr, "upgrade"};
            Assert.assertEquals((long)0L, (long)dfsadmin.run(args2));
            Thread.sleep(2000L);
            Assert.assertFalse((String)"DataNode should exit", (boolean)dn.isDatanodeUp());
            Assert.assertEquals((long)-1L, (long)dfsadmin.run(args1));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testQueryAfterRestart() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            cluster.restartNameNodes();
            dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

