/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;

public class TestBpOfferServiceScheduler {
    protected static final Log LOG = LogFactory.getLog(TestBpOfferServiceScheduler.class);
    @Rule
    public Timeout timeout = new Timeout(300000);
    private static final long HEARTBEAT_INTERVAL_MS = 5000L;
    private static final long BLOCK_REPORT_INTERVAL_MS = 10000L;
    private final Random random = new Random(System.nanoTime());

    @Test
    public void testInit() {
        for (long now : this.getTimestamps()) {
            BPOfferService.Scheduler scheduler = this.makeMockScheduler(now);
            Assert.assertTrue((boolean)scheduler.isHeartbeatDue(now));
            Assert.assertTrue((boolean)scheduler.isBlockReportDue());
        }
    }

    @Test
    public void testScheduleBlockReportImmediate() {
        for (long now : this.getTimestamps()) {
            BPOfferService.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.scheduleBlockReport(0L);
            Assert.assertTrue((boolean)scheduler.resetBlockReportTime);
            Assert.assertThat((Object)scheduler.nextBlockReportTime, (Matcher)Is.is((Object)now));
        }
    }

    @Test
    public void testScheduleBlockReportDelayed() {
        for (long now : this.getTimestamps()) {
            BPOfferService.Scheduler scheduler = this.makeMockScheduler(now);
            long delayMs = 10L;
            scheduler.scheduleBlockReport(10L);
            Assert.assertTrue((boolean)scheduler.resetBlockReportTime);
            Assert.assertTrue((scheduler.nextBlockReportTime - now >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((scheduler.nextBlockReportTime - (now + 10L) < 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testScheduleNextBlockReport() {
        for (long now : this.getTimestamps()) {
            BPOfferService.Scheduler scheduler = this.makeMockScheduler(now);
            Assert.assertTrue((boolean)scheduler.resetBlockReportTime);
            scheduler.scheduleNextBlockReport();
            Assert.assertTrue((scheduler.nextBlockReportTime - (now + 10000L) < 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testScheduleNextBlockReport2() {
        for (long now : this.getTimestamps()) {
            BPOfferService.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.resetBlockReportTime = false;
            scheduler.scheduleNextBlockReport();
            Assert.assertThat((Object)scheduler.nextBlockReportTime, (Matcher)Is.is((Object)(now + 10000L)));
        }
    }

    @Test
    public void testScheduleNextBlockReport3() {
        for (long now : this.getTimestamps()) {
            long origBlockReportTime;
            BPOfferService.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.resetBlockReportTime = false;
            long blockReportDelay = 10000L + (long)this.random.nextInt(20000);
            scheduler.nextBlockReportTime = origBlockReportTime = now - blockReportDelay;
            scheduler.scheduleNextBlockReport();
            Assert.assertTrue((scheduler.nextBlockReportTime - now < 10000L ? 1 : 0) != 0);
            Assert.assertTrue(((scheduler.nextBlockReportTime - origBlockReportTime) % 10000L == 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testScheduleHeartbeat() {
        for (long now : this.getTimestamps()) {
            BPOfferService.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.scheduleNextHeartbeat();
            Assert.assertFalse((boolean)scheduler.isHeartbeatDue(now));
            scheduler.scheduleHeartbeat();
            Assert.assertTrue((boolean)scheduler.isHeartbeatDue(now));
        }
    }

    private BPOfferService.Scheduler makeMockScheduler(long now) {
        LOG.info((Object)("Using now = " + now));
        BPOfferService.Scheduler mockScheduler = (BPOfferService.Scheduler)Mockito.spy((Object)new BPOfferService.Scheduler(5000L, 10000L));
        ((BPOfferService.Scheduler)Mockito.doReturn((Object)now).when((Object)mockScheduler)).monotonicNow();
        mockScheduler.nextBlockReportTime = now;
        mockScheduler.nextHeartbeatTime = now;
        return mockScheduler;
    }

    List<Long> getTimestamps() {
        return Arrays.asList(0L, Long.MIN_VALUE, Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL, Math.abs(this.random.nextLong()), -Math.abs(this.random.nextLong()));
    }
}

