/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.HopsFilesTestHelper;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestSmallFilesCreation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class TestSmallFilesDiskFull {
    private static final Log LOG = LogFactory.getLog(TestSmallFilesDiskFull.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=900000L)
    public void TestWriteMaxSpillToDN() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int MAX_SMALL_FILE_SIZE = 0xA00000;
            conf.setInt("dfs.db.file.max.size", 0xA00000);
            conf.setInt("dfs.blocksize", 0x8000000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).format(true).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            int count = 13;
            int i = 0;
            try {
                for (i = 0; i < count; ++i) {
                    HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/file" + i, 0xA00000);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed after creating " + i + " files"));
            }
            try {
                for (i = 0; i < count; ++i) {
                    HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/file" + i, 0xA00000);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"Failed to verify files");
            }
            int dbFiles = HopsFilesTestHelper.countDBFiles();
            Assert.assertTrue((String)("Count of db file should be more than 0 and less than " + count), (dbFiles > 0 && dbFiles < count ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @AfterClass
    public static void Cleanup() throws IOException {
        TestSmallFilesCreation.TestZLastTestCleanUp();
    }
}

