/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.InvalidateBlocks;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.util.VersionInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TestComputeInvalidateWork {
    private Configuration conf;
    private final int NUM_OF_DATANODES = 3;
    private MiniDFSCluster cluster;
    private FSNamesystem namesystem;
    private BlockManager bm;
    private DatanodeDescriptor[] nodes;

    @Before
    public void setup() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.namenode.replication.interval", Integer.MAX_VALUE);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.namesystem = this.cluster.getNamesystem();
        this.bm = this.namesystem.getBlockManager();
        this.nodes = this.bm.getDatanodeManager().getHeartbeatManager().getDatanodes();
        Assert.assertEquals((long)this.nodes.length, (long)3L);
    }

    @After
    public void teardown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=120000L)
    public void testCompInvalidate() throws Exception {
        int blockInvalidateLimit = this.bm.getDatanodeManager().blockInvalidateLimit;
        for (int i = 0; i < this.nodes.length; ++i) {
            for (int j = 0; j < 3 * blockInvalidateLimit + 1; ++j) {
                Block block = new Block((long)(i * (blockInvalidateLimit + 1) + j), 0L, 1000L);
                this.addToInvalidates(this.bm, block, this.nodes[i], this.namesystem);
            }
        }
        Assert.assertEquals((long)(blockInvalidateLimit * 3), (long)this.bm.computeInvalidateWork(4));
        Assert.assertEquals((long)(blockInvalidateLimit * 3), (long)this.bm.computeInvalidateWork(3));
        Assert.assertEquals((long)(blockInvalidateLimit * 2), (long)this.bm.computeInvalidateWork(2));
        int workCount = this.bm.computeInvalidateWork(1);
        if (workCount == 1) {
            Assert.assertEquals((long)(blockInvalidateLimit + 1), (long)this.bm.computeInvalidateWork(2));
        } else {
            Assert.assertEquals((long)workCount, (long)blockInvalidateLimit);
            Assert.assertEquals((long)2L, (long)this.bm.computeInvalidateWork(2));
        }
    }

    @Test(timeout=120000L)
    public void testDatanodeReformat() throws Exception {
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        DatanodeRegistration dnr = this.cluster.getDataNode(this.nodes[0].getIpcPort()).getDNRegistrationForBP(poolId);
        dnr = new DatanodeRegistration(UUID.randomUUID().toString(), dnr);
        this.cluster.stopDataNode(this.nodes[0].getXferAddr());
        Block block = new Block(0L, 0L, 1000L);
        this.addToInvalidates(this.bm, block, this.nodes[0], this.namesystem);
        this.bm.getDatanodeManager().registerDatanode(dnr);
        Assert.assertEquals((long)0L, (long)this.bm.computeInvalidateWork(1));
        Assert.assertEquals((long)0L, (long)this.bm.getPendingDeletionBlocksCount());
    }

    @Test(timeout=12000L)
    public void testDatanodeReRegistration() throws Exception {
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        Path path = new Path("/testRR");
        DFSTestUtil.createFile((FileSystem)dfs, path, dfs.getDefaultBlockSize(), (short)3, 0xED0ED0L);
        for (DataNode dn : this.cluster.getDataNodes()) {
            dn.shutdown();
        }
        dfs.delete(path, false);
        int expected = 3;
        InvalidateBlocks invalidateBlocks = (InvalidateBlocks)Whitebox.getInternalState((Object)this.cluster.getNamesystem().getBlockManager(), (String)"invalidateBlocks");
        Assert.assertEquals((String)"Expected invalidate blocks to be the number of DNs", (long)expected, (long)invalidateBlocks.numBlocks());
        for (DataNode dn : this.cluster.getDataNodes()) {
            DatanodeID did = dn.getDatanodeId();
            DatanodeRegistration reg = new DatanodeRegistration(new DatanodeID(UUID.randomUUID().toString(), did), new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE), new ExportedBlockKeys(), VersionInfo.getVersion());
            this.bm.getDatanodeManager().registerDatanode(reg);
            Assert.assertEquals((String)"Expected number of invalidate blocks to decrease", (long)(--expected), (long)invalidateBlocks.numBlocks());
        }
    }

    private void addToInvalidates(final BlockManager bm, final Block block, final DatanodeDescriptor node, FSNamesystem namesystem) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.COMP_INVALIDATE){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException, IOException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.IV}));
            }

            public Object performTask() throws StorageException, IOException {
                TestComputeInvalidateWork.this.addToInvalidates(block, (DatanodeInfo)node, bm);
                return null;
            }
        }.handle((Object)namesystem);
    }

    void addToInvalidates(Block block, DatanodeInfo datanode, BlockManager bm) throws StorageException, TransactionContextException, UnregisteredNodeException, IOException {
        DatanodeDescriptor dn = bm.getDatanodeManager().getDatanode((DatanodeID)datanode);
        DatanodeStorageInfo storage = dn.getStorageInfos()[0];
        BlockInfoContiguous storedBlock = bm.getStoredBlock(block);
        if (storedBlock == null) {
            storedBlock = new BlockInfoContiguous();
            storedBlock.setINodeIdNoPersistance((long)BlockInfoContiguous.NON_EXISTING_ID);
            storedBlock.setNoPersistance(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp());
        }
        bm.addToInvalidates(storedBlock, storage);
    }
}

