/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.CachedBlock;
import io.hops.metadata.hdfs.entity.CorruptReplica;
import io.hops.metadata.hdfs.entity.ExcessReplica;
import io.hops.metadata.hdfs.entity.InvalidatedBlock;
import io.hops.metadata.hdfs.entity.Replica;
import io.hops.metadata.hdfs.entity.UnderReplicatedBlock;
import io.hops.transaction.lock.BaseIndividualBlockLock;
import io.hops.transaction.lock.BlockLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockWithType;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingBlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.ReplicaUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;

final class BlockRelatedLock
extends LockWithType {
    Collection<Object> blks = new ArrayList<Object>();

    BlockRelatedLock(Lock.Type type) {
        super(type);
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        Lock lock = locks.getLock(Lock.Type.Block);
        if (lock instanceof BaseIndividualBlockLock) {
            BaseIndividualBlockLock individualBlockLock = (BaseIndividualBlockLock)lock;
            for (BlockInfoContiguous blk : individualBlockLock.getBlocks()) {
                if (this.isList()) {
                    Collection list = this.acquireLockList(DEFAULT_LOCK_TYPE, this.getFinderType(true), new Object[]{blk.getBlockId(), blk.getInodeId()});
                    if (list == null) continue;
                    this.blks.addAll(list);
                    continue;
                }
                Object b = this.acquireLock(DEFAULT_LOCK_TYPE, this.getFinderType(true), new Object[]{blk.getBlockId(), blk.getInodeId()});
                if (b == null) continue;
                this.blks.add(b);
            }
            if (lock instanceof BlockLock) {
                BlockLock blockLock = (BlockLock)lock;
                for (INodeFile file : blockLock.getFiles()) {
                    if (!file.isFileStoredInDB()) {
                        Collection list = this.acquireLockList(DEFAULT_LOCK_TYPE, this.getFinderType(false), new Object[]{file.getId()});
                        if (list == null) continue;
                        this.blks.addAll(list);
                        continue;
                    }
                    LOG.debug((Object)("Stuffed Inode:  BlockRelateLock. " + this.getType() + "'s lock skipped as the file(s) data is stored in the database. File Name: " + file.getLocalName()));
                }
            }
        } else {
            throw new TransactionLocks.LockNotAddedException("Block Lock wasn't added");
        }
    }

    private FinderType getFinderType(boolean byBlockID) {
        switch (this.getType()) {
            case Replica: {
                return byBlockID ? Replica.Finder.ByBlockIdAndINodeId : Replica.Finder.ByINodeId;
            }
            case CorruptReplica: {
                return byBlockID ? CorruptReplica.Finder.ByBlockIdAndINodeId : CorruptReplica.Finder.ByINodeId;
            }
            case ExcessReplica: {
                return byBlockID ? ExcessReplica.Finder.ByBlockIdAndINodeId : ExcessReplica.Finder.ByINodeId;
            }
            case ReplicaUnderConstruction: {
                return byBlockID ? ReplicaUnderConstruction.Finder.ByBlockIdAndINodeId : ReplicaUnderConstruction.Finder.ByINodeId;
            }
            case InvalidatedBlock: {
                return byBlockID ? InvalidatedBlock.Finder.ByBlockIdAndINodeId : InvalidatedBlock.Finder.ByINodeId;
            }
            case UnderReplicatedBlock: {
                return byBlockID ? UnderReplicatedBlock.Finder.ByBlockIdAndINodeId : UnderReplicatedBlock.Finder.ByINodeId;
            }
            case PendingBlock: {
                return byBlockID ? PendingBlockInfo.Finder.ByBlockIdAndINodeId : PendingBlockInfo.Finder.ByINodeId;
            }
            case CachedBlock: {
                return byBlockID ? CachedBlock.Finder.ByBlockIdAndInodeId : CachedBlock.Finder.ByInodeId;
            }
        }
        return null;
    }

    private boolean isList() {
        switch (this.getType()) {
            case UnderReplicatedBlock: 
            case PendingBlock: {
                return false;
            }
        }
        return true;
    }

    public Collection<Object> getBlocks() {
        return this.blks;
    }
}

