/*
 * Decompiled with CFR 0.152.
 */
package io.hops.common;

import com.google.common.collect.Lists;
import io.hops.common.CountersQueue;
import io.hops.common.IDsGenerator;
import io.hops.exception.StorageException;
import io.hops.metadata.HdfsVariables;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IDsGeneratorFactory {
    private static final Log LOG = LogFactory.getLog(IDsGeneratorFactory.class);
    private static IDsGeneratorFactory factory;
    private List<IDsGenerator> iDsGenerators = Lists.newArrayList();
    Boolean isConfigured = false;

    private IDsGeneratorFactory() {
    }

    public static IDsGeneratorFactory getInstance() {
        if (factory == null) {
            factory = new IDsGeneratorFactory();
        }
        return factory;
    }

    public static void reset() {
        factory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConfiguration(int inodeIdsBatchSize, int blockIdsBatchSize, int quotaUpdateIdsBatchSize, int cacheDirectiveIdsBatchSize, float inodeIdsThreshold, float blockIdsThreshold, float quotaUpdateIdsThreshold, float cacheDirectiveIdsThreshold) {
        Boolean bl = this.isConfigured;
        synchronized (bl) {
            if (this.isConfigured.booleanValue()) {
                LogFactory.getLog(this.getClass()).warn((Object)"Called setConfiguration more than once.");
                return;
            }
            this.isConfigured = true;
        }
        this.iDsGenerators.add(new INodeIDGen(inodeIdsBatchSize, inodeIdsThreshold));
        this.iDsGenerators.add(new BlockIDGen(blockIdsBatchSize, blockIdsThreshold));
        this.iDsGenerators.add(new QuotaUpdateIDGen(quotaUpdateIdsBatchSize, quotaUpdateIdsThreshold));
        this.iDsGenerators.add(new CacheDirectiveIDGen(cacheDirectiveIdsBatchSize, cacheDirectiveIdsThreshold));
    }

    public long getUniqueINodeID() throws StorageException {
        long id = this.iDsGenerators.get(0).getUniqueID();
        LOG.debug((Object)("Unique INode generated. id=" + id));
        return id;
    }

    public long getUniqueBlockID() throws StorageException {
        return this.iDsGenerators.get(1).getUniqueID();
    }

    public int getUniqueQuotaUpdateID() throws StorageException {
        return (int)this.iDsGenerators.get(2).getUniqueID();
    }

    public long getUniqueCacheDirectiveID() throws StorageException {
        long id = this.iDsGenerators.get(3).getUniqueID();
        if (id == 0L) {
            id = this.iDsGenerators.get(3).getUniqueID();
        }
        return id;
    }

    void getNewIDs() throws IOException {
        for (IDsGenerator iDsGenerator : this.iDsGenerators) {
            if (!iDsGenerator.getMoreIdsIfNeeded()) continue;
            LOG.debug((Object)("get more ids for [" + iDsGenerator.getClass().getSimpleName() + "] " + iDsGenerator.getCQ()));
        }
    }

    private class CacheDirectiveIDGen
    extends IDsGenerator {
        CacheDirectiveIDGen(int batchSize, float threshold) {
            super(batchSize, threshold);
        }

        @Override
        CountersQueue.Counter incrementCounter(int inc) throws IOException {
            return HdfsVariables.incrementCacheDirectiveIdCounter(inc);
        }
    }

    private class QuotaUpdateIDGen
    extends IDsGenerator {
        QuotaUpdateIDGen(int batchSize, float threshold) {
            super(batchSize, threshold);
        }

        @Override
        CountersQueue.Counter incrementCounter(int inc) throws IOException {
            return HdfsVariables.incrementQuotaUpdateIdCounter(inc);
        }
    }

    private class BlockIDGen
    extends IDsGenerator {
        BlockIDGen(int batchSize, float threshold) {
            super(batchSize, threshold);
        }

        @Override
        CountersQueue.Counter incrementCounter(int inc) throws IOException {
            return HdfsVariables.incrementBlockIdCounter(inc);
        }
    }

    private class INodeIDGen
    extends IDsGenerator {
        INodeIDGen(int batchSize, float threshold) {
            super(batchSize, threshold);
        }

        @Override
        CountersQueue.Counter incrementCounter(int inc) throws IOException {
            return HdfsVariables.incrementINodeIdCounter(inc);
        }
    }
}

